/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webbeans.ejb;

import com.sun.enterprise.deployment.EjbSessionDescriptor;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.ejb.api.EjbContainerServices;
import org.glassfish.webbeans.ejb.EjbDescriptorImpl;
import org.glassfish.webbeans.ejb.SessionObjectReferenceImpl;
import org.jboss.webbeans.ejb.api.SessionObjectReference;
import org.jboss.webbeans.ejb.spi.EjbDescriptor;
import org.jboss.webbeans.ejb.spi.EjbServices;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbServicesImpl
implements EjbServices {
    private Habitat habitat;

    public EjbServicesImpl(Habitat h) {
        this.habitat = h;
    }

    @Override
    public SessionObjectReference resolveEjb(EjbDescriptor<?> ejbDescriptor) {
        SessionObjectReferenceImpl sessionObj = null;
        String globalJndiName = this.getDefaultGlobalJndiName(ejbDescriptor);
        if (globalJndiName != null) {
            try {
                InitialContext ic = new InitialContext();
                Object ejbRef = ic.lookup(globalJndiName);
                EjbContainerServices containerServices = (EjbContainerServices)this.habitat.getByContract(EjbContainerServices.class);
                sessionObj = new SessionObjectReferenceImpl(containerServices, ejbRef);
            }
            catch (NamingException ne) {
                throw new IllegalStateException("Error resolving session object reference for ejb name " + ejbDescriptor.getBeanClass() + " and jndi name " + globalJndiName, ne);
            }
        } else {
            throw new IllegalArgumentException("Not enough type information to resolve ejb for  ejb name " + ejbDescriptor.getBeanClass());
        }
        return sessionObj;
    }

    private String getDefaultGlobalJndiName(EjbDescriptor ejbDesc) {
        EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)((EjbDescriptorImpl)ejbDesc).getEjbDescriptor();
        String clientView = null;
        if (sessionDesc.isLocalBean()) {
            clientView = sessionDesc.getEjbClassName();
        } else if (sessionDesc.getLocalBusinessClassNames().size() == 1) {
            clientView = (String)sessionDesc.getLocalBusinessClassNames().iterator().next();
        } else if (sessionDesc.getRemoteBusinessClassNames().size() == 1) {
            clientView = (String)sessionDesc.getRemoteBusinessClassNames().iterator().next();
        }
        return clientView != null ? sessionDesc.getPortableJndiName(clientView) : null;
    }

    @Override
    public void cleanup() {
    }
}

