/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Scope;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.bean.AbstractBean;
import org.jboss.webbeans.bean.DecoratorImpl;
import org.jboss.webbeans.bean.SerializableBeanInstance;
import org.jboss.webbeans.bean.proxy.DecoratorProxyMethodHandler;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.injection.FieldInjectionPoint;
import org.jboss.webbeans.injection.MethodInjectionPoint;
import org.jboss.webbeans.injection.WBInjectionPoint;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Proxies;
import org.jboss.webbeans.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassBean<T>
extends AbstractBean<T, Class<T>>
implements InjectionTarget<T> {
    private static final LogProvider log = Logging.getLogProvider(AbstractClassBean.class);
    protected WBClass<T> annotatedItem;
    private Set<FieldInjectionPoint<?, ?>> injectableFields;
    private Set<MethodInjectionPoint<?, ?>> initializerMethods;
    private Set<String> dependencies;
    private List<Decorator<?>> decorators;
    private final String id;
    private Class<T> proxyClassForDecorators;
    private final ThreadLocal<Integer> decoratorStackPosition;
    private WBMethod<?, ?> postConstruct;
    private WBMethod<?, ?> preDestroy;

    protected AbstractClassBean(WBClass<T> type, BeanManagerImpl manager) {
        super(manager);
        this.annotatedItem = type;
        this.id = AbstractClassBean.createId(this.getClass().getSimpleName() + "-" + type.getName());
        this.decoratorStackPosition = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
        this.initStereotypes();
        this.initPolicy();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        this.initInitializerMethods();
        this.initInjectableFields();
        super.initialize(environment);
        this.checkBeanImplementation();
        this.initDecorators();
        this.checkType();
        this.initProxyClassForDecoratedBean();
    }

    protected void checkType() {
    }

    protected void initDecorators() {
        this.decorators = this.getManager().resolveDecorators(this.getTypes(), this.getQualifiers());
    }

    public boolean hasDecorators() {
        return this.decorators != null && this.decorators.size() > 0;
    }

    protected void initProxyClassForDecoratedBean() {
        if (this.hasDecorators()) {
            Class proxyClass;
            LinkedHashSet<Type> types = new LinkedHashSet<Type>(this.getTypes());
            ProxyFactory proxyFactory = Proxies.getProxyFactory(types);
            this.proxyClassForDecorators = proxyClass = proxyFactory.createClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T applyDecorators(T instance, CreationalContext<T> creationalContext, InjectionPoint originalInjectionPoint) {
        ArrayList<SerializableBeanInstance<DecoratorImpl<Object>, Object>> decoratorInstances = new ArrayList<SerializableBeanInstance<DecoratorImpl<Object>, Object>>();
        WBInjectionPoint<?, ?> ip = originalInjectionPoint;
        boolean outside = this.decoratorStackPosition.get() == 0;
        try {
            int i = this.decoratorStackPosition.get();
            while (i < this.decorators.size()) {
                Decorator<?> decorator = this.decorators.get(i);
                if (decorator instanceof DecoratorImpl) {
                    this.decoratorStackPosition.set(++i);
                    DecoratorImpl decoratorBean = (DecoratorImpl)decorator;
                    Object decoratorInstance = this.getManager().getReference(ip, decorator, creationalContext);
                    decoratorInstances.add(new SerializableBeanInstance<DecoratorImpl, Object>(decoratorBean, decoratorInstance));
                    ip = decoratorBean.getDelegateInjectionPoint();
                    continue;
                }
                throw new IllegalStateException("Cannot operate on non container provided decorator " + decorator);
            }
        }
        finally {
            if (outside) {
                this.decoratorStackPosition.remove();
            }
        }
        try {
            T proxy = this.proxyClassForDecorators.newInstance();
            ((ProxyObject)proxy).setHandler(new DecoratorProxyMethodHandler(decoratorInstances, instance));
            return proxy;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instantiate decorator proxy for " + this.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not access bean correctly when creating decorator proxy for " + this.toString(), e);
        }
    }

    public List<Decorator<?>> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    @Override
    public void dispose(T instance) {
    }

    protected void initType() {
        log.trace("Bean type specified in Java");
        this.type = this.getAnnotatedItem().getJavaClass();
        this.dependencies = new HashSet<String>();
        for (Class clazz = this.type.getSuperclass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            this.dependencies.add(clazz.getName());
        }
    }

    protected void initInjectableFields() {
        this.injectableFields = new HashSet(Beans.getFieldInjectionPoints(this, this.annotatedItem));
        this.addInjectionPoints(this.injectableFields);
    }

    protected void initInitializerMethods() {
        this.initializerMethods = Beans.getInitializerMethods(this, this.getAnnotatedItem());
        this.addInjectionPoints(Beans.getParameterInjectionPoints(this, this.initializerMethods));
    }

    @Override
    protected void initScopeType() {
        for (WBClass<?> clazz = this.getAnnotatedItem(); clazz != null; clazz = clazz.getWBSuperclass()) {
            HashSet<Annotation> scopeTypes = new HashSet<Annotation>();
            scopeTypes.addAll(clazz.getDeclaredMetaAnnotations(Scope.class));
            scopeTypes.addAll(clazz.getDeclaredMetaAnnotations(NormalScope.class));
            if (scopeTypes.size() == 1) {
                if (!this.getAnnotatedItem().isAnnotationPresent(((Annotation)scopeTypes.iterator().next()).annotationType())) break;
                this.scopeType = ((Annotation)scopeTypes.iterator().next()).annotationType();
                log.trace("Scope " + this.scopeType + " specified by annotation");
                break;
            }
            if (scopeTypes.size() <= 1) continue;
            throw new DefinitionException("At most one scope may be specified on " + this.getAnnotatedItem());
        }
        if (this.scopeType == null) {
            this.initScopeTypeFromStereotype();
        }
        if (this.scopeType == null) {
            this.scopeType = Dependent.class;
            log.trace("Using default @Dependent scope");
        }
    }

    protected void checkBeanImplementation() {
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (this.getAnnotatedItem().getWBSuperclass() == null || this.getAnnotatedItem().getWBSuperclass().getJavaClass().equals(Object.class)) {
            throw new DefinitionException("Specializing bean must extend another bean " + this.toString());
        }
    }

    public WBClass<T> getAnnotatedItem() {
        return this.annotatedItem;
    }

    @Override
    protected String getDefaultName() {
        String name = Strings.decapitalize(this.getAnnotatedItem().getSimpleName());
        log.trace("Default name of " + this.type + " is " + name);
        return name;
    }

    public Set<? extends MethodInjectionPoint<?, ?>> getInitializerMethods() {
        return Collections.unmodifiableSet(this.initializerMethods);
    }

    public Set<FieldInjectionPoint<?, ?>> getInjectableFields() {
        return Collections.unmodifiableSet(this.injectableFields);
    }

    public Set<String> getSuperclasses() {
        return this.dependencies;
    }

    @Override
    public String toString() {
        return "AbstractClassBean " + this.getName();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void postConstruct(T instance) {
        WBMethod<?, ?> postConstruct = this.getPostConstruct();
        if (postConstruct != null) {
            try {
                postConstruct.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke " + postConstruct + " on " + instance, e);
            }
        }
    }

    @Override
    public void preDestroy(T instance) {
        WBMethod<?, ?> preDestroy = this.getPreDestroy();
        if (preDestroy != null) {
            try {
                preDestroy.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke " + preDestroy + " on " + instance, e);
            }
        }
    }

    protected void initPostConstruct() {
        this.postConstruct = Beans.getPostConstruct(this.getAnnotatedItem());
    }

    protected void initPreDestroy() {
        this.preDestroy = Beans.getPreDestroy(this.getAnnotatedItem());
    }

    public WBMethod<?, ?> getPostConstruct() {
        return this.postConstruct;
    }

    public WBMethod<?, ?> getPreDestroy() {
        return this.preDestroy;
    }
}

