/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean.builtin.facade;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.metadata.cache.MetaAnnotationStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFacade<T, X>
implements Serializable {
    private static final long serialVersionUID = 8710258788495459128L;
    private static final Annotation[] EMPTY_BINDINGS = new Annotation[0];
    private final Set<? extends Annotation> bindings;
    private final BeanManagerImpl manager;
    private final Type type;

    protected AbstractFacade(Type type, BeanManagerImpl manager, Set<? extends Annotation> bindings) {
        this.manager = manager;
        this.type = type;
        this.bindings = new HashSet<Annotation>(bindings);
    }

    public String toString() {
        return "Abstract facade implmentation";
    }

    protected Annotation[] mergeInBindings(Annotation ... newBindings) {
        HashSet<? extends Annotation> result = new HashSet<Annotation>();
        result.addAll(this.bindings);
        for (Annotation newAnnotation : newBindings) {
            if (!this.getManager().getServices().get(MetaAnnotationStore.class).getBindingTypeModel(newAnnotation.annotationType()).isValid()) {
                throw new IllegalArgumentException(newAnnotation + " is not a binding for " + this);
            }
            if (result.contains(newAnnotation)) {
                throw new IllegalArgumentException(newAnnotation + " is already present in the bindings list for " + this);
            }
            result.add(newAnnotation);
        }
        return result.toArray(EMPTY_BINDINGS);
    }

    protected BeanManagerImpl getManager() {
        return this.manager.getCurrent();
    }

    protected Set<? extends Annotation> getBindings() {
        return Collections.unmodifiableSet(this.bindings);
    }

    protected Type getType() {
        return this.type;
    }
}

