/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context;

import org.jboss.webbeans.Container;
import org.jboss.webbeans.bootstrap.api.Lifecycle;
import org.jboss.webbeans.bootstrap.api.Service;
import org.jboss.webbeans.context.ApplicationContext;
import org.jboss.webbeans.context.ConversationContext;
import org.jboss.webbeans.context.DependentContext;
import org.jboss.webbeans.context.RequestContext;
import org.jboss.webbeans.context.SessionContext;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

public class ContextLifecycle
implements Lifecycle,
Service {
    public static LogProvider log = Logging.getLogProvider(ContextLifecycle.class);
    public final ApplicationContext applicationContext;
    public final SessionContext sessionContext;
    public final ConversationContext conversationContext;
    public final RequestContext requestContext;
    public final DependentContext dependentContext;

    public ContextLifecycle(ApplicationContext applicationContext, SessionContext sessionContext, ConversationContext conversationContext, RequestContext requestContext, DependentContext dependentContext) {
        this.applicationContext = applicationContext;
        this.sessionContext = sessionContext;
        this.conversationContext = conversationContext;
        this.requestContext = requestContext;
        this.dependentContext = dependentContext;
    }

    public void restoreSession(String id, BeanStore sessionBeanStore) {
        log.trace("Restoring session " + id);
        this.sessionContext.setBeanStore(sessionBeanStore);
        this.sessionContext.setActive(true);
    }

    public void endSession(String id, BeanStore sessionBeanStore) {
        log.trace("Ending session " + id);
        this.sessionContext.setActive(true);
        this.sessionContext.destroy();
        this.sessionContext.setBeanStore(null);
        this.sessionContext.setActive(false);
    }

    public void beginRequest(String id, BeanStore requestBeanStore) {
        log.trace("Starting request " + id);
        this.requestContext.setBeanStore(requestBeanStore);
        this.requestContext.setActive(true);
        this.dependentContext.setActive(true);
    }

    public void endRequest(String id, BeanStore requestBeanStore) {
        log.trace("Ending request " + id);
        this.requestContext.setBeanStore(requestBeanStore);
        this.dependentContext.setActive(false);
        this.requestContext.destroy();
        this.requestContext.setActive(false);
        this.requestContext.setBeanStore(null);
    }

    public boolean isRequestActive() {
        return this.requestContext.isActive() && this.dependentContext.isActive();
    }

    public void beginApplication(BeanStore applicationBeanStore) {
        log.trace("Starting application");
        this.applicationContext.setBeanStore(applicationBeanStore);
        this.applicationContext.setActive(true);
    }

    public void endApplication() {
        log.trace("Ending application");
        this.applicationContext.destroy();
        this.applicationContext.setActive(false);
        this.applicationContext.setBeanStore(null);
        Container.instance().cleanup();
    }

    public void cleanup() {
        this.applicationContext.cleanup();
        this.sessionContext.cleanup();
        this.conversationContext.cleanup();
        this.requestContext.cleanup();
        this.dependentContext.cleanup();
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public ConversationContext getConversationContext() {
        return this.conversationContext;
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public DependentContext getDependentContext() {
        return this.dependentContext;
    }
}

