/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.conversation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.enterprise.context.Conversation;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.webbeans.Container;
import org.jboss.webbeans.context.ContextLifecycle;
import org.jboss.webbeans.context.ConversationContext;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.conversation.ConversationConcurrentAccessTimeout;
import org.jboss.webbeans.conversation.ConversationEntry;
import org.jboss.webbeans.conversation.ConversationImpl;
import org.jboss.webbeans.conversation.ConversationManager;
import org.jboss.webbeans.conversation.ConversationTerminator;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConversationManager
implements ConversationManager {
    private static LogProvider log = Logging.getLogProvider(AbstractConversationManager.class);
    @Inject
    private ConversationTerminator conversationTerminator;
    @Inject
    @Any
    private ConversationImpl currentConversation;
    @ConversationConcurrentAccessTimeout
    private long concurrentAccessTimeout;
    private Map<String, ConversationEntry> longRunningConversations;

    public AbstractConversationManager() {
        log.trace("Created " + this.getClass());
        this.longRunningConversations = new ConcurrentHashMap<String, ConversationEntry>();
    }

    @Override
    public void beginOrRestoreConversation(String cid) {
        if (cid == null) {
            log.trace("No conversation id to restore");
            return;
        }
        if (!this.longRunningConversations.containsKey(cid)) {
            log.warn("Could not restore long-running conversation " + cid);
            return;
        }
        ConversationEntry resumedConversationEntry = this.longRunningConversations.get(cid);
        try {
            if (!resumedConversationEntry.lock(this.concurrentAccessTimeout)) {
                return;
            }
        }
        catch (InterruptedException e) {
            log.debug("Interrupted while trying to acquire lock");
            return;
        }
        if (!resumedConversationEntry.cancelTermination()) {
            resumedConversationEntry.unlock();
        } else {
            String oldConversation = this.currentConversation.toString();
            this.currentConversation.switchTo(resumedConversationEntry.getConversation());
            log.trace("Conversation switched from " + oldConversation + " to " + this.currentConversation);
        }
    }

    @Override
    public void cleanupConversation() {
        ConversationEntry longRunningConversation;
        log.trace("Cleaning up conversation for " + this.currentConversation);
        String cid = this.currentConversation.getUnderlyingId();
        if (this.currentConversation.isLongRunning()) {
            Future<?> terminationHandle = this.scheduleForTermination(cid, this.currentConversation.getTimeout());
            longRunningConversation = this.longRunningConversations.get(cid);
            if (longRunningConversation != null) {
                longRunningConversation.unlock();
                longRunningConversation.reScheduleTermination(terminationHandle);
            } else {
                ConversationEntry conversationEntry = ConversationEntry.of(this.getBeanStore(cid), this.currentConversation, terminationHandle);
                this.longRunningConversations.put(cid, conversationEntry);
            }
            log.trace("Scheduled " + this.currentConversation + " for termination, there are now " + this.longRunningConversations.size() + " long-running conversations");
        } else {
            log.trace("Destroying transient conversation " + this.currentConversation);
            ConversationEntry longRunningConversation2 = this.longRunningConversations.remove(cid);
            if (longRunningConversation2 != null) {
                longRunningConversation2.cancelTermination();
                longRunningConversation2.unlock();
            }
            ConversationContext conversationContext = Container.instance().deploymentServices().get(ContextLifecycle.class).getConversationContext();
            conversationContext.destroy();
        }
        String originalCid = this.currentConversation.getOriginalId();
        ConversationEntry conversationEntry = longRunningConversation = originalCid == null ? null : this.longRunningConversations.get(originalCid);
        if (longRunningConversation != null) {
            longRunningConversation.unlock();
            longRunningConversation.reScheduleTermination(this.scheduleForTermination(originalCid, this.currentConversation.getTimeout()));
        }
    }

    private Future<?> scheduleForTermination(String cid, long timeout) {
        TerminationTask terminationTask = new TerminationTask(cid);
        return this.conversationTerminator.scheduleForTermination(terminationTask, timeout);
    }

    @Override
    public void destroyAllConversations() {
        log.debug("Destroying " + this.longRunningConversations.size() + " long-running conversations");
        for (ConversationEntry conversationEntry : this.longRunningConversations.values()) {
            conversationEntry.destroy();
        }
        this.longRunningConversations.clear();
    }

    @Override
    public Set<Conversation> getLongRunningConversations() {
        HashSet<ConversationImpl> conversations = new HashSet<ConversationImpl>();
        for (ConversationEntry conversationEntry : this.longRunningConversations.values()) {
            conversations.add(conversationEntry.getConversation());
        }
        return Collections.unmodifiableSet(conversations);
    }

    public abstract BeanStore getBeanStore(String var1);

    private class TerminationTask
    implements Runnable {
        private String cid;

        public TerminationTask(String cid) {
            this.cid = cid;
        }

        public void run() {
            log.debug("Conversation " + this.cid + " timed out. Destroying it");
            ((ConversationEntry)AbstractConversationManager.this.longRunningConversations.remove(this.cid)).destroy();
            log.trace("There are now " + AbstractConversationManager.this.longRunningConversations.size() + " long-running conversations");
        }
    }
}

