/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.TypeLiteral;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.injection.WBInjectionPoint;
import org.jboss.webbeans.introspector.AnnotationStore;
import org.jboss.webbeans.introspector.WBAnnotated;
import org.jboss.webbeans.introspector.jlr.AbstractWBAnnotated;
import org.jboss.webbeans.metadata.TypeStore;
import org.jboss.webbeans.resolution.Resolvable;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolvableWBClass<T>
extends AbstractWBAnnotated<T, Class<T>>
implements Resolvable {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private static final Set<Annotation> EMPTY_ANNOTATION_SET = Collections.emptySet();
    private final Class<T> rawType;
    private final Set<Type> typeClosure;
    private final Type[] actualTypeArguments;
    private final String _string;
    private final BeanManagerImpl manager;

    public static <T> WBAnnotated<T, Class<T>> of(TypeLiteral<T> typeLiteral, Annotation[] annotations, BeanManagerImpl manager) {
        return new ResolvableWBClass<T>(typeLiteral.getType(), annotations, manager);
    }

    public static <T> WBAnnotated<T, Class<T>> of(Type type, Annotation[] annotations, BeanManagerImpl manager) {
        return new ResolvableWBClass<T>(type, annotations, manager);
    }

    public static <T> WBAnnotated<T, Class<T>> of(InjectionPoint injectionPoint, BeanManagerImpl manager) {
        if (injectionPoint instanceof WBInjectionPoint) {
            WBAnnotated ip = (WBAnnotated)((Object)injectionPoint);
            return ip;
        }
        return new ResolvableWBClass<T>(injectionPoint.getType(), injectionPoint.getAnnotated().getAnnotations(), manager);
    }

    public static <T> WBAnnotated<T, Class<T>> of(Member member, Annotation[] annotations, BeanManagerImpl manager) {
        if (member instanceof Field) {
            return new ResolvableWBClass<T>(((Field)member).getGenericType(), annotations, manager);
        }
        if (member instanceof Method) {
            return new ResolvableWBClass<T>(((Method)member).getGenericReturnType(), annotations, manager);
        }
        throw new IllegalStateException();
    }

    private ResolvableWBClass(Type type, AnnotationStore annotationStore, BeanManagerImpl manager) {
        super(annotationStore);
        this.manager = manager;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (!(parameterizedType.getRawType() instanceof Class)) {
                throw new IllegalArgumentException("Cannot extract rawType from " + type);
            }
            this.rawType = (Class)parameterizedType.getRawType();
            this.actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            this._string = this.rawType.toString() + "<" + Arrays.asList(this.actualTypeArguments).toString() + ">; binding types = " + Names.annotationsToString(annotationStore.getBindings());
        } else if (type instanceof Class) {
            this.rawType = (Class)type;
            this.actualTypeArguments = new Type[0];
            this._string = this.rawType.toString() + "; binding types = " + Names.annotationsToString(annotationStore.getBindings());
        } else {
            throw new IllegalArgumentException("Unable to extract type information from " + type);
        }
        this.typeClosure = new HashSet<Type>();
        this.typeClosure.add(type);
    }

    private ResolvableWBClass(Type type, Annotation[] annotations, BeanManagerImpl manager) {
        this(type, AnnotationStore.of(annotations, EMPTY_ANNOTATION_ARRAY, manager.getServices().get(TypeStore.class)), manager);
    }

    private ResolvableWBClass(Type type, Set<Annotation> annotations, BeanManagerImpl manager) {
        this(type, AnnotationStore.of(annotations, EMPTY_ANNOTATION_SET, manager.getServices().get(TypeStore.class)), manager);
    }

    @Override
    public String toString() {
        return this._string;
    }

    @Override
    public Class<T> getDelegate() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<T> getJavaClass() {
        return this.rawType;
    }

    @Override
    public boolean isFinal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPublic() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPrivate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStatic() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isProxyable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Type> getTypeClosure() {
        return this.typeClosure;
    }

    @Override
    public AbstractClassBean<?> getDeclaringBean() {
        return null;
    }

    @Override
    public Type getBaseType() {
        return this.getJavaClass();
    }

    @Override
    public boolean isAssignableTo(Class<?> clazz) {
        return Reflections.isAssignableFrom(clazz, this.getBaseType());
    }
}

