/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="memory-mon", group="monitoring")
@ManagedObject
@Description(value="JVM Memory Statistics")
public class JVMMemoryStatsProvider {
    private MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
    private MemoryUsage memUsageHeap = this.memBean.getHeapMemoryUsage();
    private MemoryUsage memUsageNonHeap = this.memBean.getNonHeapMemoryUsage();
    private CountStatisticImpl committedHeap = new CountStatisticImpl("CommittedHeapSize", "bytes", "Amount of memory in bytes that is committed for the Java virtual machine to use");
    private CountStatisticImpl initHeap = new CountStatisticImpl("InitialHeapSize", "bytes", "Amount of memory in bytes that the Java virtual machine initially requests from the operating system for memory management");
    private CountStatisticImpl maxHeap = new CountStatisticImpl("MaxHeapSize", "bytes", "Maximum amount of memory in bytes that can be used for memory management");
    private CountStatisticImpl usedHeap = new CountStatisticImpl("UsedHeapSize", "bytes", "Amount of used memory in bytes");
    private CountStatisticImpl committedNonHeap = new CountStatisticImpl("CommittedNonHeapSize", "bytes", "Amount of memory in bytes that is committed for the Java virtual machine to use");
    private CountStatisticImpl initNonHeap = new CountStatisticImpl("InitialNonHeapSize", "bytes", "Amount of memory in bytes that the Java virtual machine initially requests from the operating system for memory management");
    private CountStatisticImpl maxNonHeap = new CountStatisticImpl("MaxNonHeapSize", "bytes", "Maximum amount of memory in bytes that can be used for memory management");
    private CountStatisticImpl usedNonHeap = new CountStatisticImpl("UsedNonHeapSize", "bytes", "Amount of used memory in bytes");
    private CountStatisticImpl objectPendingFinalizationCount = new CountStatisticImpl("ObjectsPendingFinalization", "count", "Approximate number of objects for which finalization is pending");

    @ManagedAttribute(id="committedheapsize-count")
    @Description(value="amount of memory in bytes that is committed for the Java virtual machine to use")
    public CountStatistic getCommittedHeap() {
        this.committedHeap.setCount(this.memUsageHeap.getCommitted());
        this.committedHeap.setLastSampleTime(System.currentTimeMillis());
        return this.committedHeap;
    }

    @ManagedAttribute(id="initheapsize-count")
    @Description(value="amount of memory in bytes that the Java virtual machine initially requests from the operating system for memory management")
    public CountStatistic getInitHeap() {
        this.initHeap.setCount(this.memUsageHeap.getInit());
        this.initHeap.setLastSampleTime(System.currentTimeMillis());
        return this.initHeap;
    }

    @ManagedAttribute(id="maxheapsize-count")
    @Description(value="maximum amount of memory in bytes that can be used for memory management")
    public CountStatistic getMaxHeap() {
        this.maxHeap.setCount(this.memUsageHeap.getMax());
        this.maxHeap.setLastSampleTime(System.currentTimeMillis());
        return this.maxHeap;
    }

    @ManagedAttribute(id="usedheapsize-count")
    @Description(value="amount of used memory in bytes")
    public CountStatistic getUsedHeap() {
        this.usedHeap.setCount(this.memUsageHeap.getUsed());
        this.usedHeap.setLastSampleTime(System.currentTimeMillis());
        return this.usedHeap;
    }

    @ManagedAttribute(id="committednonheapsize-count")
    @Description(value="amount of memory in bytes that is committed for the Java virtual machine to use")
    public CountStatistic getCommittedNonHeap() {
        this.committedNonHeap.setCount(this.memUsageNonHeap.getCommitted());
        this.committedNonHeap.setLastSampleTime(System.currentTimeMillis());
        return this.committedNonHeap;
    }

    @ManagedAttribute(id="initnonheapsize-count")
    @Description(value="amount of memory in bytes that the Java virtual machine initially requests from the operating system for memory management")
    public CountStatistic getInitNonHeap() {
        this.initNonHeap.setCount(this.memUsageNonHeap.getInit());
        this.initNonHeap.setLastSampleTime(System.currentTimeMillis());
        return this.initNonHeap;
    }

    @ManagedAttribute(id="maxnonheapsize-count")
    @Description(value="maximum amount of memory in bytes that can be used for memory management")
    public CountStatistic getMaxNonHeap() {
        this.maxNonHeap.setCount(this.memUsageNonHeap.getMax());
        this.maxNonHeap.setLastSampleTime(System.currentTimeMillis());
        return this.maxNonHeap;
    }

    @ManagedAttribute(id="usednonheapsize-count")
    @Description(value="amount of used memory in bytes")
    public CountStatistic getUsedNonHeap() {
        this.usedNonHeap.setCount(this.memUsageNonHeap.getUsed());
        this.usedNonHeap.setLastSampleTime(System.currentTimeMillis());
        return this.usedNonHeap;
    }

    @ManagedAttribute(id="objectpendingfinalizationcount-count")
    @Description(value="approximate number of objects for which finalization is pending")
    public CountStatistic getObjectPendingFinalizationCount() {
        this.objectPendingFinalizationCount.setCount(this.memBean.getObjectPendingFinalizationCount());
        this.objectPendingFinalizationCount.setLastSampleTime(System.currentTimeMillis());
        return this.objectPendingFinalizationCount;
    }
}

