/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.ValidationProviderResolver;
import javax.validation.ValidatorFactory;
import javax.validation.spi.BootstrapState;
import javax.validation.spi.ConfigurationState;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validation.engine.ConstraintValidatorFactoryImpl;
import org.hibernate.validation.engine.HibernateValidatorConfiguration;
import org.hibernate.validation.engine.ResourceBundleMessageInterpolator;
import org.hibernate.validation.engine.resolver.DefaultTraversableResolver;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.Version;
import org.hibernate.validation.xml.ValidationBootstrapParameters;
import org.hibernate.validation.xml.ValidationXmlParser;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationImpl
implements HibernateValidatorConfiguration,
ConfigurationState {
    private static final Logger log;
    private final MessageInterpolator defaultMessageInterpolator = new ResourceBundleMessageInterpolator();
    private final TraversableResolver defaultTraversableResolver = new DefaultTraversableResolver();
    private final ConstraintValidatorFactory defaultValidatorFactory = new ConstraintValidatorFactoryImpl();
    private final ValidationProviderResolver providerResolver;
    private ValidationBootstrapParameters validationBootstrapParameters;
    private boolean ignoreXmlConfiguration = false;

    public ConfigurationImpl(BootstrapState state) {
        this.providerResolver = state.getValidationProviderResolver() == null ? state.getDefaultValidationProviderResolver() : state.getValidationProviderResolver();
        this.validationBootstrapParameters = new ValidationBootstrapParameters();
    }

    public ConfigurationImpl(ValidationProvider provider) {
        if (provider == null) {
            throw new ValidationException("Assertion error: inconsistent ConfigurationImpl construction");
        }
        this.providerResolver = null;
        this.validationBootstrapParameters = new ValidationBootstrapParameters();
        this.validationBootstrapParameters.provider = provider;
    }

    @Override
    public HibernateValidatorConfiguration ignoreXmlConfiguration() {
        this.ignoreXmlConfiguration = true;
        return this;
    }

    @Override
    public ConfigurationImpl messageInterpolator(MessageInterpolator interpolator) {
        this.validationBootstrapParameters.messageInterpolator = interpolator;
        return this;
    }

    @Override
    public ConfigurationImpl traversableResolver(TraversableResolver resolver) {
        this.validationBootstrapParameters.traversableResolver = resolver;
        return this;
    }

    @Override
    public ConfigurationImpl constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.validationBootstrapParameters.constraintValidatorFactory = constraintValidatorFactory;
        return this;
    }

    @Override
    public HibernateValidatorConfiguration addMapping(InputStream stream) {
        this.validationBootstrapParameters.mappings.add(stream);
        return this;
    }

    @Override
    public HibernateValidatorConfiguration addProperty(String name, String value) {
        if (value != null) {
            this.validationBootstrapParameters.configProperties.put(name, value);
        }
        return this;
    }

    @Override
    public ValidatorFactory buildValidatorFactory() {
        this.parseValidationXml();
        ValidatorFactory factory = null;
        if (this.isSpecificProvider()) {
            factory = this.validationBootstrapParameters.provider.buildValidatorFactory(this);
        } else {
            Class<ValidationProvider<?>> providerClass = this.validationBootstrapParameters.providerClass;
            if (providerClass != null) {
                for (ValidationProvider<?> provider : this.providerResolver.getValidationProviders()) {
                    if (!providerClass.isAssignableFrom(provider.getClass())) continue;
                    factory = provider.buildValidatorFactory(this);
                    break;
                }
                if (factory == null) {
                    throw new ValidationException("Unable to find provider: " + providerClass);
                }
            } else {
                List<ValidationProvider<?>> providers = this.providerResolver.getValidationProviders();
                assert (providers.size() != 0);
                factory = providers.get(0).buildValidatorFactory(this);
            }
        }
        this.validationBootstrapParameters = new ValidationBootstrapParameters();
        return factory;
    }

    @Override
    public boolean isIgnoreXmlConfiguration() {
        return this.ignoreXmlConfiguration;
    }

    @Override
    public MessageInterpolator getMessageInterpolator() {
        return this.validationBootstrapParameters.messageInterpolator;
    }

    @Override
    public Set<InputStream> getMappingStreams() {
        return this.validationBootstrapParameters.mappings;
    }

    @Override
    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.validationBootstrapParameters.constraintValidatorFactory;
    }

    @Override
    public TraversableResolver getTraversableResolver() {
        return this.validationBootstrapParameters.traversableResolver;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.validationBootstrapParameters.configProperties;
    }

    @Override
    public MessageInterpolator getDefaultMessageInterpolator() {
        return this.defaultMessageInterpolator;
    }

    private boolean isSpecificProvider() {
        return this.validationBootstrapParameters.provider != null;
    }

    private void parseValidationXml() {
        if (this.ignoreXmlConfiguration) {
            log.info("Ignoring XML configuration.");
            return;
        }
        ValidationBootstrapParameters xmlParameters = new ValidationXmlParser().parseValidationXml();
        this.applyXmlSettings(xmlParameters);
    }

    private void applyXmlSettings(ValidationBootstrapParameters xmlParameters) {
        this.validationBootstrapParameters.providerClass = xmlParameters.providerClass;
        if (this.validationBootstrapParameters.messageInterpolator == null) {
            this.validationBootstrapParameters.messageInterpolator = xmlParameters.messageInterpolator != null ? xmlParameters.messageInterpolator : this.defaultMessageInterpolator;
        }
        if (this.validationBootstrapParameters.traversableResolver == null) {
            this.validationBootstrapParameters.traversableResolver = xmlParameters.traversableResolver != null ? xmlParameters.traversableResolver : this.defaultTraversableResolver;
        }
        if (this.validationBootstrapParameters.constraintValidatorFactory == null) {
            this.validationBootstrapParameters.constraintValidatorFactory = xmlParameters.constraintValidatorFactory != null ? xmlParameters.constraintValidatorFactory : this.defaultValidatorFactory;
        }
        this.validationBootstrapParameters.mappings.addAll(xmlParameters.mappings);
        for (Map.Entry<String, String> entry : xmlParameters.configProperties.entrySet()) {
            if (this.validationBootstrapParameters.configProperties.get(entry.getKey()) != null) continue;
            this.validationBootstrapParameters.configProperties.put(entry.getKey(), entry.getValue());
        }
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }
}

