/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.modelgen.visitors.ElementVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataMirrorFactory
extends MetadataFactory {
    private ProcessingEnvironment m_processingEnv;
    private HashSet<String> m_roundElements = new HashSet();
    private Map<String, MetadataClass> m_metadataClassesFromElements = new HashMap<String, MetadataClass>();

    protected MetadataMirrorFactory(MetadataLogger logger, ClassLoader loader) {
        super(logger, loader);
    }

    protected MetadataClass buildMetadataClass(Element element) {
        MetadataClass metadataClass = new MetadataClass((MetadataFactory)this, "");
        ElementVisitor visitor = new ElementVisitor(this.m_processingEnv);
        element.accept(visitor, metadataClass);
        this.addMetadataClass(metadataClass);
        this.m_metadataClassesFromElements.put(element.toString(), metadataClass);
        return metadataClass;
    }

    public MetadataClass getMetadataClass(Element element) {
        if (this.m_metadataClassesFromElements.containsKey(element.toString())) {
            return this.m_metadataClassesFromElements.get(element.toString());
        }
        return this.buildMetadataClass(element);
    }

    @Override
    public MetadataClass getMetadataClass(String className) {
        if (!this.metadataClassExists(className)) {
            this.addMetadataClass(new MetadataClass((MetadataFactory)this, className));
        }
        return this.getMetadataClasses().get(className);
    }

    public MetadataClass getMetadataClass(TypeMirror typeMirror) {
        Element element = this.m_processingEnv.getTypeUtils().asElement(typeMirror);
        if (element == null) {
            return this.getMetadataClass(((Object)typeMirror).toString());
        }
        return this.getMetadataClass(element);
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.m_processingEnv;
    }

    public boolean isRoundElement(MetadataClass cls) {
        return this.m_roundElements.contains(cls.getName());
    }

    public void setEnvironments(ProcessingEnvironment processingEnvironment, RoundEnvironment roundEnvironment) {
        this.m_processingEnv = processingEnvironment;
        this.m_roundElements.clear();
        for (Element element : roundEnvironment.getRootElements()) {
            if (element.getSimpleName().toString().endsWith("_")) continue;
            this.m_roundElements.add(this.buildMetadataClass(element).getName());
        }
    }

    @Override
    public void resolveGenericTypes(MetadataClass child, List<String> genericTypes, MetadataClass parent, MetadataDescriptor descriptor) {
    }
}

