/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.monitoring;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.webservices.monitoring.DeployedEndpointData;

@AMXMetadata(type="web-service-mon", group="monitoring")
@ManagedObject
@Description(value="Stats for Web Services deployed")
public class WebServiceStatsProvider {
    private final ConcurrentHashMap<String, DeployedEndpointData> endpoints = new ConcurrentHashMap();

    @ProbeListener(value="glassfish:webservices:109:deploy")
    public void eeDeploy(@ProbeParam(value="app") Application app, @ProbeParam(value="endpoint") WebServiceEndpoint endpoint) {
        String path = endpoint.getEndpointAddressPath();
        if (!this.endpoints.containsKey(path)) {
            DeployedEndpointData data = new DeployedEndpointData(path, app, endpoint);
            this.endpoints.put(path, data);
        }
    }

    @ProbeListener(value="glassfish:webservices:109:undeploy")
    public void eeUndeploy(@ProbeParam(value="path") String path) {
        this.endpoints.remove(path);
    }

    @ProbeListener(value="glassfish:webservices:ri:deploy")
    public void riDeploy(@ProbeParam(value="adapter") ServletAdapter adapter) {
        String path = adapter.getServletContext().getContextPath() + adapter.getValidPath();
        if (!this.endpoints.containsKey(path)) {
            DeployedEndpointData data = new DeployedEndpointData(path, adapter);
            this.endpoints.put(path, data);
        }
    }

    @ProbeListener(value="glassfish:webservices:ri:undeploy")
    public void riUndeploy(@ProbeParam(value="adapter") ServletAdapter adapter) {
        ServletContext ctxt = adapter.getServletContext();
        String name = ctxt.getContextPath() + adapter.getValidPath();
        this.endpoints.remove(name);
    }

    @ManagedAttribute
    @Description(value="Deployed Web Service Endpoints")
    public MyStats getEndpoints() {
        return new MyStats(this.endpoints);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ManagedData
    private static class MyStats
    implements Stats {
        final Map<String, DeployedEndpointData> endpoints = new HashMap<String, DeployedEndpointData>();
        final DeployedEndpointData[] data;

        MyStats(Map<String, DeployedEndpointData> curEndpoints) {
            this.endpoints.putAll(curEndpoints);
            this.data = this.endpoints.values().toArray(new DeployedEndpointData[this.endpoints.size()]);
        }

        public Statistic getStatistic(String s) {
            return (Statistic)this.endpoints.get(s);
        }

        public String[] getStatisticNames() {
            Set<String> names = this.endpoints.keySet();
            return names.toArray(new String[names.size()]);
        }

        @ManagedAttribute
        public DeployedEndpointData[] getStatistics() {
            return this.data;
        }
    }
}

