/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.lang.reflect.Modifier;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.UnmappedContentHandlerWrapper;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.namespaces.StackUnmarshalNamespaceResolver;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceResolver;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.unmapped.UnmappedContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.Locator2;

public class SAXUnmarshallerHandler
implements ContentHandler {
    private static final String EMPTY_STRING = "";
    private XMLReader xmlReader;
    private XMLContext xmlContext;
    private Object object;
    private XMLUnmarshaller unmarshaller;
    private AbstractSession session;
    private Locator2 locator;
    private UnmarshalNamespaceResolver unmarshalNamespaceResolver;

    public SAXUnmarshallerHandler(XMLContext xmlContext) {
        this.xmlContext = xmlContext;
        this.unmarshalNamespaceResolver = new StackUnmarshalNamespaceResolver();
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setDocumentLocator(Locator locator) {
        if (locator instanceof Locator2) {
            this.locator = (Locator2)locator;
        }
    }

    public UnmarshalNamespaceResolver getUnmarshalNamespaceResolver() {
        return this.unmarshalNamespaceResolver;
    }

    public void setUnmarshalNamespaceResolver(UnmarshalNamespaceResolver unmarshalNamespaceResolver) {
        this.unmarshalNamespaceResolver = unmarshalNamespaceResolver;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.unmarshalNamespaceResolver.push(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.unmarshalNamespaceResolver.pop(prefix);
    }

    public void resolveReferences() {
        this.unmarshaller.resolveReferences(this.session);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            UnmarshalRecord unmarshalRecord;
            String name = EMPTY_STRING.equals(localName) || localName == null ? qName : localName;
            QName rootQName = EMPTY_STRING.equals(namespaceURI) || namespaceURI == null ? new QName(name) : new QName(namespaceURI, name);
            XMLDescriptor xmlDescriptor = null;
            String type = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (null != type) {
                XPathFragment typeFragment = new XPathFragment(type);
                if (null != this.unmarshalNamespaceResolver) {
                    typeFragment.setNamespaceURI(this.unmarshalNamespaceResolver.getNamespaceURI(typeFragment.getPrefix()));
                }
                xmlDescriptor = this.xmlContext.getDescriptorByGlobalType(typeFragment);
            }
            if (xmlDescriptor == null) {
                Object obj;
                xmlDescriptor = this.xmlContext.getDescriptor(rootQName);
                if (null == xmlDescriptor && (obj = this.xmlReader.getCurrentObject(this.session, null)) != null) {
                    xmlDescriptor = (XMLDescriptor)this.xmlContext.getSession(obj.getClass()).getDescriptor(obj.getClass());
                }
                if (null == xmlDescriptor) {
                    UnmappedContentHandler unmappedContentHandler;
                    Class unmappedContentHandlerClass = this.unmarshaller.getUnmappedContentHandlerClass();
                    if (null == unmappedContentHandlerClass) {
                        throw XMLMarshalException.noDescriptorWithMatchingRootElement(rootQName.toString());
                    }
                    try {
                        PrivilegedNewInstanceFromClass privilegedNewInstanceFromClass = new PrivilegedNewInstanceFromClass(unmappedContentHandlerClass);
                        unmappedContentHandler = (UnmappedContentHandler)privilegedNewInstanceFromClass.run();
                    }
                    catch (ClassCastException e) {
                        throw XMLMarshalException.unmappedContentHandlerDoesntImplement(e, unmappedContentHandlerClass.getName());
                    }
                    catch (IllegalAccessException e) {
                        throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
                    }
                    catch (InstantiationException e) {
                        throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
                    }
                    UnmappedContentHandlerWrapper unmappedContentHandlerWrapper = new UnmappedContentHandlerWrapper(unmappedContentHandler, this);
                    unmappedContentHandler.setUnmarshalRecord(unmappedContentHandlerWrapper);
                    unmappedContentHandler.startElement(namespaceURI, localName, qName, atts);
                    this.xmlReader.setContentHandler(unmappedContentHandler);
                    this.setObject(unmappedContentHandlerWrapper.getCurrentObject());
                    return;
                }
            }
            this.session = this.xmlContext.getReadSession(xmlDescriptor);
            if (xmlDescriptor.hasInheritance()) {
                QName leafElementType;
                unmarshalRecord = new UnmarshalRecord(null);
                unmarshalRecord.setUnmarshalNamespaceResolver(this.unmarshalNamespaceResolver);
                unmarshalRecord.setAttributes(atts);
                Class classValue = xmlDescriptor.getInheritancePolicy().classFromRow(unmarshalRecord, this.session);
                if (classValue == null && (leafElementType = xmlDescriptor.getDefaultRootElementType()) != null) {
                    Object indicator = xmlDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(leafElementType);
                    if (indicator == null) {
                        throw DescriptorException.missingClassForIndicatorFieldValue(leafElementType, xmlDescriptor.getInheritancePolicy().getDescriptor());
                    }
                    classValue = (Class)indicator;
                }
                if (classValue != null) {
                    xmlDescriptor = (XMLDescriptor)this.session.getDescriptor(classValue);
                } else if (Modifier.isAbstract(xmlDescriptor.getJavaClass().getModifiers())) {
                    throw DescriptorException.missingClassIndicatorField(unmarshalRecord, xmlDescriptor.getInheritancePolicy().getDescriptor());
                }
            }
            unmarshalRecord = (UnmarshalRecord)xmlDescriptor.getObjectBuilder().createRecord(this.session);
            if (this.locator != null) {
                unmarshalRecord.setDocumentLocator(this.locator);
            }
            unmarshalRecord.setUnmarshaller(this.unmarshaller);
            unmarshalRecord.setXMLReader(this.getXMLReader());
            unmarshalRecord.setAttributes(atts);
            if (atts != null && null == atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil")) {
                unmarshalRecord.setUnmarshalNamespaceResolver(this.unmarshalNamespaceResolver);
                unmarshalRecord.startDocument();
                this.xmlReader.setContentHandler(unmarshalRecord);
                unmarshalRecord.startElement(namespaceURI, localName, qName, atts);
                try {
                    unmarshalRecord.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
                }
                catch (SAXNotRecognizedException ex) {
                }
                catch (SAXNotSupportedException ex) {}
            } else {
                unmarshalRecord.setRootElementName(qName);
                unmarshalRecord.setRootElementNamespaceUri(namespaceURI);
            }
            this.object = xmlDescriptor.wrapObjectInXMLRoot(unmarshalRecord, this.unmarshaller.isResultAlwaysXMLRoot());
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setUnmarshaller(XMLUnmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public XMLUnmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }
}

