/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.provider;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbeProviderXMLParser {
    private List<Provider> providers = new ArrayList<Provider>();
    private Document document;
    private static String PROBE_PROVIDER = "probe-provider";
    private static String MODULE_PROVIDER_NAME = "moduleProviderName";
    private static String MODULE_NAME = "moduleName";
    private static String PROBE_PROVIDER_NAME = "probeProviderName";
    private static String PROBE_PROVIDER_CLASS = "class";
    private static String PROBE = "probe";
    private static String PROBE_NAME = "name";
    private static String PROBE_SELF = "self";
    private static String PROBE_HIDDEN = "hidden";
    private static String METHOD = "method";
    private static String PROBE_PARAM = "probe-param";
    private static String PROBE_PARAM_TYPE = "type";
    private static String PROBE_PARAM_NAME = "name";
    private boolean debug = false;

    public ProbeProviderXMLParser(InputStream is) throws Exception {
        this.initProperties(is);
        this.generateProviders();
        if (this.providers.size() == 0) {
            Logger.getLogger(ProbeProviderXMLParser.class.getName()).log(Level.SEVERE, " No providers identified from the xml ");
        }
    }

    private void initProperties(InputStream is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMParser parser = new DOMParser();
            InputSource isource = new InputSource(is);
            parser.parse(isource);
            this.document = parser.getDocument();
            this.printDebug(" ** parsed document ***");
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            throw new Exception(x.getLocalizedMessage());
        }
        catch (ParserConfigurationException pce) {
            throw new Exception(pce.getLocalizedMessage());
        }
        catch (IOException ioe) {
            throw new Exception(ioe.getLocalizedMessage());
        }
    }

    public List<Provider> getProviders() {
        return this.providers;
    }

    private void generateProviders() throws Exception {
        Element probeProvidersElement;
        NodeList probeProviderList;
        if (this.document != null && (probeProviderList = (probeProvidersElement = this.document.getDocumentElement()).getElementsByTagName(PROBE_PROVIDER)) != null && probeProviderList.getLength() > 0) {
            for (int i = 0; i < probeProviderList.getLength(); ++i) {
                Element probeProvider = (Element)probeProviderList.item(i);
                Provider p = this.getProvider(probeProvider);
                this.providers.add(p);
            }
        }
    }

    private Provider getProvider(Element providerEl) throws Exception {
        ArrayList<Probe> probes = new ArrayList<Probe>();
        String moduleProviderName = providerEl.getAttribute(MODULE_PROVIDER_NAME);
        String moduleName = providerEl.getAttribute(MODULE_NAME);
        String probeProviderName = providerEl.getAttribute(PROBE_PROVIDER_NAME);
        String providerClass = providerEl.getAttribute(PROBE_PROVIDER_CLASS);
        NodeList probeList = providerEl.getElementsByTagName(PROBE);
        if (probeList != null && probeList.getLength() > 0) {
            for (int i = 0; i < probeList.getLength(); ++i) {
                Element probeEl = (Element)probeList.item(i);
                Probe p = this.getProbe(probeEl);
                probes.add(p);
            }
        }
        return new Provider(moduleProviderName, moduleName, probeProviderName, providerClass, probes);
    }

    private Probe getProbe(Element probeEl) throws Exception {
        String hidden;
        String name = probeEl.getAttribute(PROBE_NAME);
        String self = probeEl.getAttribute(PROBE_SELF);
        if (self == null) {
            self = "false";
        }
        if ((hidden = probeEl.getAttribute(PROBE_HIDDEN)) == null) {
            hidden = "false";
        }
        String method = probeEl.getElementsByTagName(METHOD).item(0).getFirstChild().getNodeValue();
        ArrayList<ProbeParam> params = new ArrayList<ProbeParam>();
        NodeList probeParamsList = probeEl.getElementsByTagName(PROBE_PARAM);
        if (probeParamsList != null && probeParamsList.getLength() > 0) {
            for (int i = 0; i < probeParamsList.getLength(); ++i) {
                Element probeParamEl = (Element)probeParamsList.item(i);
                ProbeParam probeParam = this.getProbeParam(probeParamEl);
                params.add(probeParam);
            }
        }
        Probe probe = new Probe(name, method, params, Boolean.parseBoolean(self), Boolean.parseBoolean(hidden));
        return probe;
    }

    private ProbeParam getProbeParam(Element paramEl) throws Exception {
        String name = paramEl.getAttribute(PROBE_PARAM_NAME);
        String type = paramEl.getAttribute(PROBE_PARAM_TYPE);
        return new ProbeParam(name, type);
    }

    private void printDebug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Probe {
        String probeName = null;
        String probeMethod = null;
        List<ProbeParam> probeParams = null;
        boolean hasSelf = false;
        boolean isHidden = false;

        public String getProbeName() {
            return this.probeName;
        }

        public String getProbeMethod() {
            return this.probeMethod;
        }

        public List<ProbeParam> getProbeParams() {
            return this.probeParams;
        }

        public boolean hasSelf() {
            return this.hasSelf;
        }

        public boolean isHidden() {
            return this.isHidden;
        }

        public Probe(String probeName, String method, List<ProbeParam> params, boolean hasSelf, boolean isHidden) {
            this.probeName = probeName;
            this.probeMethod = method;
            this.probeParams = params;
            this.hasSelf = hasSelf;
            this.isHidden = isHidden;
        }

        public String toString() {
            String paramsStr = "     \n";
            for (ProbeParam param : this.probeParams) {
                paramsStr = paramsStr + "         , Param " + param.toString();
            }
            return " Probe name = " + this.probeName + " , method = " + this.probeMethod + paramsStr;
        }
    }

    public class ProbeParam {
        String name = null;
        String type = null;

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public ProbeParam(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return " Name=" + this.name + " Type=" + this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Provider {
        private String moduleProviderName = null;
        private String moduleName = null;
        private String probeProviderName = null;
        private String probeProviderClass = null;
        private List<Probe> probes = null;

        public String getModuleName() {
            return this.moduleName;
        }

        public String getModuleProviderName() {
            return this.moduleProviderName;
        }

        public String getProbeProviderName() {
            return this.probeProviderName;
        }

        public String getProbeProviderClass() {
            return this.probeProviderClass;
        }

        public List<Probe> getProbes() {
            return this.probes;
        }

        public Provider(String moduleProviderName, String moduleName, String probeProviderName, String providerClass, List<Probe> probes) {
            this.moduleProviderName = moduleProviderName;
            this.moduleName = moduleName;
            this.probeProviderName = probeProviderName;
            this.probeProviderClass = providerClass;
            this.probes = probes;
        }

        public String toString() {
            String probeStr = "moduelProviderName=" + this.moduleProviderName + " moduleName=" + this.moduleName + " probeProvidername=" + this.probeProviderName + " probeProviderClass=" + this.probeProviderClass;
            for (Probe probe : this.probes) {
                probeStr = probeStr + "\n    " + probe.toString();
            }
            return probeStr;
        }
    }
}

