/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.impl;

import com.sun.jdo.api.persistence.support.ConnectionFactory;
import com.sun.jdo.api.persistence.support.JDODataStoreException;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperTransaction;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.connection.ConnectionImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import org.glassfish.persistence.common.I18NHelper;

public class TransactionImpl
implements Transaction {
    static boolean tracing;
    private static final int TRACE_THREADS = 1;
    private static final int TRACE_RESOURCES = 2;
    private static final int TRACE_SYNCHRONIZATIONS = 4;
    private static final int TRACE_ONE_PHASE = 8;
    static String globalLock;
    private int status = 6;
    private int timeout;
    public static final int TRAN_DEFAULT_TIMEOUT = 0;
    private int queryTimeout = 0;
    private int updateTimeout = 0;
    private int threads;
    public static final int TRAN_MAX_THREADS = 50;
    private boolean startedCommit;
    private boolean onePhase;
    private Synchronization synchronization = null;
    private ArrayList resources;
    private static final int RESOURCE_START = 0;
    private static final int RESOURCE_END = 1;
    private PersistenceManagerFactory pmFactory = null;
    private PersistenceManager persistenceManager = null;
    private Object connectionFactory = null;
    private javax.transaction.Transaction jta = null;
    private boolean isDataSource = false;
    private String username = null;
    private String password = null;
    private Connection _connection = null;
    private int _connectionReferenceCount = 0;
    private boolean retainValues = true;
    private boolean restoreValues = false;
    private boolean optimistic = true;
    private boolean nontransactionalRead = true;
    public static final int NON_MGD = 0;
    public static final int CMT = 1;
    public static final int BMT_UT = 2;
    public static final int BMT_JDO = 3;
    private int txType = -1;
    private static Logger logger;
    private static final ResourceBundle messages;
    private int INTERNAL_ERROR = 1;
    private int INTERNAL_OK = 0;

    public TransactionImpl(PersistenceManager pm, String username, String password, int seconds) {
        this.timeout = seconds;
        this.startedCommit = false;
        this.onePhase = false;
        this.resources = new ArrayList();
        this.persistenceManager = pm;
        this.username = username;
        this.password = password;
        this.pmFactory = (PersistenceManagerFactory)pm.getPersistenceManagerFactory();
        this.connectionFactory = this.pmFactory.getConnectionFactory();
        if (!(this.connectionFactory instanceof ConnectionFactory)) {
            this.isDataSource = true;
        }
        this.optimistic = this.pmFactory.getOptimistic();
        this.retainValues = this.pmFactory.getRetainValues();
        this.nontransactionalRead = this.pmFactory.getNontransactionalRead();
        this.queryTimeout = this.pmFactory.getQueryTimeout();
        this.updateTimeout = this.pmFactory.getUpdateTimeout();
    }

    public void setPersistenceManager(PersistenceManager pm) {
    }

    public com.sun.jdo.api.persistence.support.PersistenceManager getPersistenceManager() {
        return this.persistenceManager.getCurrentWrapper();
    }

    public boolean isActive() {
        return this.status == 0 || this.status == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRetainValues(boolean flag) {
        if (this.isActive() && !this.optimistic && flag) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.setoptimistic.notallowed"));
        }
        this.persistenceManager.acquireExclusiveLock();
        try {
            if (this.isActive() && !this.optimistic && flag) {
                throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.setoptimistic.notallowed"));
            }
            this.retainValues = flag;
            if (flag) {
                this.nontransactionalRead = flag;
                this.persistenceManager.notifyNontransactionalRead(flag);
            }
        }
        finally {
            this.persistenceManager.releaseExclusiveLock();
        }
    }

    public boolean getRetainValues() {
        return this.retainValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRestoreValues(boolean flag) {
        if (this.isActive()) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.setoptimistic.notallowed"));
        }
        this.persistenceManager.acquireExclusiveLock();
        try {
            if (this.isActive()) {
                throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.setoptimistic.notallowed"));
            }
            this.restoreValues = flag;
        }
        finally {
            this.persistenceManager.releaseExclusiveLock();
        }
    }

    public boolean getRestoreValues() {
        return this.restoreValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNontransactionalRead(boolean flag) {
        if (this.isActive() && this.optimistic && !flag) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.setoptimistic.notallowed"));
        }
        this.persistenceManager.acquireExclusiveLock();
        try {
            if (this.isActive() && this.optimistic && !flag) {
                throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.setoptimistic.notallowed"));
            }
            this.nontransactionalRead = flag;
            this.persistenceManager.notifyNontransactionalRead(flag);
            if (!flag) {
                this.retainValues = flag;
                this.optimistic = flag;
                this.persistenceManager.notifyOptimistic(flag);
            }
        }
        finally {
            this.persistenceManager.releaseExclusiveLock();
        }
    }

    public boolean getNontransactionalRead() {
        return this.nontransactionalRead;
    }

    public void setQueryTimeout(int timeout) {
        this.queryTimeout = timeout;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setUpdateTimeout(int timeout) {
        this.updateTimeout = timeout;
    }

    public int getUpdateTimeout() {
        return this.updateTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOptimistic(boolean flag) {
        if (!this.isTerminated()) {
            throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.setoptimistic.notallowed"));
        }
        this.persistenceManager.acquireExclusiveLock();
        try {
            if (this.isTerminated()) {
                this.optimistic = flag;
                if (flag) {
                    this.nontransactionalRead = flag;
                    this.persistenceManager.notifyNontransactionalRead(flag);
                }
            } else {
                throw new JDOUnsupportedOptionException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.setoptimistic.notallowed"));
            }
            this.persistenceManager.notifyOptimistic(flag);
        }
        finally {
            this.persistenceManager.releaseExclusiveLock();
        }
    }

    public boolean getOptimistic() {
        return this.optimistic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronization(Synchronization sync) {
        if (tracing) {
            this.traceCall("setSynchronization");
        }
        this.persistenceManager.acquireExclusiveLock();
        try {
            this.synchronization = sync;
            if (tracing) {
                this.traceCallInfo("setSynchronization", 4, null);
            }
        }
        finally {
            this.persistenceManager.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Synchronization getSynchronization() {
        this.persistenceManager.acquireShareLock();
        try {
            Synchronization synchronization = this.synchronization;
            return synchronization;
        }
        finally {
            this.persistenceManager.releaseShareLock();
        }
    }

    public int getTransactionType() {
        return this.txType;
    }

    public boolean verify(String username, String password) {
        return !(this.username != null && !this.username.equals(username) || this.username == null && username != null || this.password != null && !this.password.equals(password)) && (this.password != null || password == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin() {
        block7: {
            this.persistenceManager.acquireExclusiveLock();
            try {
                this.beginInternal();
                if (EJBHelper.isManaged()) {
                    this.txType = 3;
                    try {
                        TransactionManager tm = EJBHelper.getLocalTransactionManager();
                        tm.begin();
                        this.jta = tm.getTransaction();
                        EJBHelper.registerSynchronization(this.jta, this);
                        this.pmFactory.registerPersistenceManager(this.persistenceManager, this.jta);
                        break block7;
                    }
                    catch (JDOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.begin.failedlocaltx"), e);
                    }
                }
                this.txType = 0;
            }
            finally {
                this.persistenceManager.releaseExclusiveLock();
            }
        }
    }

    private void beginInternal() {
        this.setTrace();
        if (tracing) {
            this.traceCall("begin");
        }
        if (this.isActive()) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.begin.notnew", (String)TransactionImpl.statusString(this.status)));
        }
        this.setStatus(0);
        this.threads = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(javax.transaction.Transaction t) {
        this.persistenceManager.acquireExclusiveLock();
        try {
            this.beginInternal();
            try {
                this.jta = t;
                EJBHelper.registerSynchronization(this.jta, this);
            }
            catch (Exception e) {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.begin.registersynchfailed"), e);
            }
            this.txType = 1;
        }
        finally {
            this.persistenceManager.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        block9: {
            this.persistenceManager.acquireExclusiveLock();
            if (this.txType == 1 || this.txType == 2) {
                throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.mgd", (String)"commit"));
            }
            if (this.txType == 3) {
                try {
                    EJBHelper.getLocalTransactionManager().commit();
                    return;
                }
                catch (Exception e) {
                    throw new JDOException("", e);
                }
            }
            this.setTrace();
            if (tracing) {
                this.traceCall("commit");
            }
            break block9;
            finally {
                this.persistenceManager.releaseExclusiveLock();
            }
        }
        this.commitBefore();
        this.commitPrepare();
        this.commitComplete();
        this.notifyAfterCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        if (this.txType == 0) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.nonmgd", (String)"beforeCompletion"));
        }
        Object o = null;
        try {
            o = EJBHelper.preInvoke(new Object[]{this, this.persistenceManager, this.jta});
            this.commitBefore();
            this.commitPrepare();
            this.commitComplete();
            this.closeConnection();
        }
        catch (Throwable throwable) {
            this.closeConnection();
            EJBHelper.postInvoke(o);
            throw throwable;
        }
        EJBHelper.postInvoke(o);
    }

    public void afterCompletion(int st) {
        if (this.txType == 0) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.nonmgd", (String)"afterCompletion"));
        }
        st = EJBHelper.translateStatus(st);
        if (tracing) {
            this.traceCallInfo("afterCompletion", 4, TransactionImpl.statusString(st));
        }
        if (st == 4) {
            this.setStatus(9);
            this.internalRollback();
        }
        if (st != this.status) {
            if (this.synchronization != null) {
                try {
                    this.synchronization.afterCompletion(st);
                }
                catch (Exception ex) {
                    logger.log(900, I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.syncmanager.aftercompletion", (String)ex.getMessage()));
                }
            }
            this.persistenceManager.forceClose();
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.commitprepare.wrongstatus", (String)"afterCompletion", (String)TransactionImpl.statusString(this.status), (String)TransactionImpl.statusString(st)));
        }
        this.notifyAfterCompletion();
    }

    private void commitBefore() {
        boolean rollbackOnly = false;
        boolean notified = false;
        if (tracing) {
            this.traceCall("commitBefore");
        }
        if (this.status == 9 || this.status == 4) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.rolledback", (String)"commit", (String)TransactionImpl.statusString(this.status)));
        }
        if (this.status == 1) {
            rollbackOnly = true;
        } else if (this.status != 0) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.commit_rollback.notactive", (String)"commit", (String)TransactionImpl.statusString(this.status)));
        }
        if (this.startedCommit) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.commitbefore.incommit", (String)"commit"));
        }
        this.startedCommit = true;
        if (!rollbackOnly) {
            this.notifyBeforeCompletion();
            notified = true;
            if (this.status == 0) {
                this.setStatus(7);
            } else if (this.status == 1) {
                rollbackOnly = true;
            } else {
                throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.commitbefore.rolledback"));
            }
        }
        if (rollbackOnly && this.txType == 0) {
            this.rollback();
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)(notified ? "transaction.transactionimpl.commitbefore.rollbackonly_insync" : "transaction.transactionimpl.commitbefore.rollbackonly")));
        }
    }

    private void commitPrepare() {
        if (tracing) {
            this.traceCall("commitPrepare");
        }
        if (this.status != 7) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.commitprepare.wrongstatus", (String)"commitPrepare", (String)"STATUS_PREPARING", (String)TransactionImpl.statusString(this.status)));
        }
        if (this.resources.size() <= 1) {
            this.onePhase = true;
        }
        this.setStatus(2);
    }

    private void commitComplete() {
        if (tracing) {
            this.traceCallInfo("commitComplete", 8, null);
        }
        if (this.status == 9) {
            this.setStatus(9);
            this.internalRollback();
        } else if (this.status == 2) {
            this.setStatus(8);
            this.internalCommit();
        } else {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.commitprepare.wrongstatus", (String)"commitComplete", (String)"STATUS_PREPARED", (String)TransactionImpl.statusString(this.status)));
        }
    }

    private void internalCommit() {
        if (this.txType == 0) {
            int error = this.commitConnection();
            if (error != this.INTERNAL_OK) {
                this.forceRollback();
                throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.commitcomplete.error", (String)"Connection Error"));
            }
            this.closeConnection();
        }
        this.setStatus(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        block9: {
            this.persistenceManager.acquireExclusiveLock();
            try {
                if (this.txType == 1 || this.txType == 2) {
                    throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.mgd", (String)"rollback"));
                }
                this.setTrace();
                if (tracing) {
                    this.traceCall("rollback");
                }
                if (this.status != 0 && this.status != 1) {
                    throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.commit_rollback.notactive", (String)"rollback", (String)TransactionImpl.statusString(this.status)));
                }
                this.setStatus(9);
                this.internalRollback();
                this.closeConnection();
                if (this.txType == 3) {
                    try {
                        EJBHelper.getLocalTransactionManager().rollback();
                        break block9;
                    }
                    catch (Exception e) {
                        throw new JDOException("", e);
                    }
                }
                this.notifyAfterCompletion();
            }
            finally {
                this.persistenceManager.releaseExclusiveLock();
            }
        }
    }

    private void internalRollback() {
        if (tracing) {
            this.traceCall("internalRollback");
        }
        if (this.status == 4) {
            return;
        }
        if (this.status != 9) {
            throw new JDOUserException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.commitprepare.wrongstatus", (String)"internalRollback", (String)"STATUS_ROLLING_BACK", (String)TransactionImpl.statusString(this.status)));
        }
        if (this.txType == 0) {
            this.rollbackConnection();
        }
        this.setStatus(4);
    }

    int forceRollback() {
        if (tracing) {
            this.traceCall("forceRollback");
        }
        if (this.status == 9 || this.status == 4 || this.status == 3 || this.status == 6) {
            return this.status;
        }
        this.internalRollback();
        this.notifyAfterCompletion();
        return this.status;
    }

    public void setRollbackOnly() {
        if (tracing) {
            this.traceCall("setRollbackOnly");
        }
        if (this.status == 9 || this.status == 4 || this.status == 1) {
            return;
        }
        if (this.txType != 0) {
            try {
                this.jta.setRollbackOnly();
            }
            catch (Exception e) {
                throw new JDOException("", e);
            }
        } else {
            this.setStatus(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        String string = globalLock;
        synchronized (string) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTerminated() {
        String string = globalLock;
        synchronized (string) {
            return this.status == 3 || this.status == 4 || this.status == 6;
        }
    }

    private void notifyBeforeCompletion() {
        if (this.synchronization != null) {
            try {
                this.synchronization.beforeCompletion();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.persistenceManager.beforeCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAfterCompletion() {
        try {
            this.persistenceManager.afterCompletion(this.status);
        }
        finally {
            if (this.synchronization != null) {
                try {
                    this.synchronization.afterCompletion(this.status);
                }
                catch (Exception ex) {
                    logger.log(900, I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.syncmanager.aftercompletion", (String)ex.getMessage()));
                }
            }
        }
        this.forget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(int status) {
        String string = globalLock;
        synchronized (string) {
            if (tracing) {
                Object[] objectArray = new Object[5];
                objectArray[0] = Thread.currentThread();
                objectArray[1] = this.toString();
                objectArray[2] = TransactionImpl.statusString(this.status);
                objectArray[3] = TransactionImpl.statusString(status);
                objectArray[4] = this.persistenceManager;
                Object[] items = objectArray;
                logger.finest("sqlstore.transactionimpl.status", items);
            }
            this.status = status;
            this.persistenceManager.notifyStatusChange(this.isActive());
        }
    }

    private void forget() {
        if (tracing) {
            this.traceCall("forget");
        }
        this.threads = 0;
        this.startedCommit = false;
        if (this._connection != null) {
            try {
                if (!this._connection.isClosed()) {
                    this.closeConnection();
                    throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.forget.connectionnotclosed"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._connection = null;
        }
        this._connectionReferenceCount = 0;
        this.resources.clear();
        if (this.txType != 0) {
            this.persistenceManager.close();
        }
        this.jta = null;
        this.txType = 0;
        this.setTrace();
    }

    static void setTrace() {
        tracing = logger.isLoggable(300);
    }

    private void traceCall(String call) {
        Object[] objectArray = new Object[6];
        objectArray[0] = Thread.currentThread();
        objectArray[1] = this.toString();
        objectArray[2] = call;
        objectArray[3] = TransactionImpl.statusString(this.status);
        objectArray[4] = this.txTypeString();
        objectArray[5] = this.persistenceManager;
        Object[] items = objectArray;
        logger.finest("sqlstore.transactionimpl.call", items);
    }

    private void traceCallInfo(String call, int info, String s) {
        StringBuffer logMessage = new StringBuffer();
        logMessage.append("Thread.currentThread()").append("Tran[").append(this.toString()).append("].").append(call).append(": status = ").append(TransactionImpl.statusString(this.status));
        if ((info & 1) != 0) {
            logMessage.append(", threads = " + this.threads);
        }
        if ((info & 4) != 0) {
            logMessage.append(", sync = " + this.synchronization);
        }
        if ((info & 2) != 0) {
            logMessage.append(", resources = " + this.resources.size());
        }
        if ((info & 8) != 0 && this.onePhase) {
            logMessage.append(", onePhase = true");
        }
        if (s != null) {
            logMessage.append(", " + s + " for " + this.persistenceManager);
        }
        logger.finest("sqlstore.transactionimpl.general", (Object)logMessage.toString());
    }

    private void traceCallString(String call, String info) {
        Object[] items = new Object[]{Thread.currentThread(), this.toString(), call, info, this.persistenceManager};
        logger.finest("sqlstore.transactionimpl.call.info", items);
    }

    private String txTypeString() {
        switch (this.txType) {
            case 0: {
                return "NON_MGD";
            }
            case 1: {
                return "CMT";
            }
            case 2: {
                return "BMT_UT";
            }
            case 3: {
                return "BMT_JDO";
            }
        }
        return "UNKNOWN";
    }

    public static String statusString(int status) {
        switch (status) {
            case 0: {
                return "STATUS_ACTIVE";
            }
            case 1: {
                return "STATUS_MARKED_ROLLBACK";
            }
            case 2: {
                return "STATUS_PREPARED";
            }
            case 3: {
                return "STATUS_COMMITTED";
            }
            case 4: {
                return "STATUS_ROLLEDBACK";
            }
            case 5: {
                return "STATUS_UNKNOWN";
            }
            case 6: {
                return "STATUS_NO_TRANSACTION";
            }
            case 7: {
                return "STATUS_PREPARING";
            }
            case 8: {
                return "STATUS_COMMITTING";
            }
            case 9: {
                return "STATUS_ROLLING_BACK";
            }
        }
        return "STATUS_Invalid[" + status + "]";
    }

    public synchronized Connection getConnection() {
        boolean debug = logger.isLoggable(300);
        if (this._connection == null) {
            if (this.connectionFactory == null) {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"transaction.transactionimpl.getconnection.nullcf"));
            }
            this._connection = this.getConnectionInternal();
        }
        ++this._connectionReferenceCount;
        if (debug) {
            Object[] items = new Object[]{this._connection, this.optimistic, new Integer(this._connectionReferenceCount), this.persistenceManager};
            logger.finest("sqlstore.transactionimpl.getconnection", items);
        }
        if (!EJBHelper.isManaged()) {
            try {
                if (!this.optimistic && this.isActive() || this.startedCommit) {
                    if (this._connection.getAutoCommit()) {
                        this._connection.setAutoCommit(false);
                    }
                } else {
                    this._connection.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                logger.log(900, "sqlstore.exception.log", (Throwable)e);
            }
        }
        return this._connection;
    }

    public void replaceConnection() {
        if (EJBHelper.isManaged()) {
            this.releaseConnection();
            this.closeConnection();
            this.getConnection();
        }
    }

    public synchronized void releaseConnection() {
        boolean debug = logger.isLoggable(300);
        if (this._connectionReferenceCount > 0) {
            --this._connectionReferenceCount;
        }
        if (debug) {
            Object[] items = new Object[]{this.optimistic, this.startedCommit, new Integer(this._connectionReferenceCount), this.persistenceManager};
            logger.finest("sqlstore.transactionimpl.releaseconnection", items);
        }
        if (!EJBHelper.isManaged() && !this.optimistic || this.startedCommit) {
            return;
        }
        if (this._connectionReferenceCount == 0) {
            this.closeConnection();
        }
    }

    private Connection getConnectionInternal() {
        if (this.isDataSource) {
            try {
                if (EJBHelper.isManaged()) {
                    if (this.isActive()) {
                        return EJBHelper.getConnection(this.connectionFactory, this.username, this.password);
                    }
                    return EJBHelper.getNonTransactionalConnection(this.connectionFactory, this.username, this.password);
                }
                if (this.username != null) {
                    return ((DataSource)this.connectionFactory).getConnection(this.username, this.password);
                }
                return ((DataSource)this.connectionFactory).getConnection();
            }
            catch (SQLException e) {
                String sqlState = e.getSQLState();
                int errorCode = e.getErrorCode();
                if (sqlState == null) {
                    throw new JDODataStoreException(I18NHelper.getMessage((ResourceBundle)messages, (String)"connectionefactoryimpl.sqlexception", (String)"null", (String)("" + errorCode)), (Exception)e);
                }
                throw new JDODataStoreException(I18NHelper.getMessage((ResourceBundle)messages, (String)"connectionefactoryimpl.sqlexception", (String)sqlState, (String)("" + errorCode)), (Exception)e);
            }
        }
        return ((ConnectionFactory)this.connectionFactory).getConnection();
    }

    private void closeConnection() {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{this._connection, this.persistenceManager};
            logger.finest("sqlstore.transactionimpl.closeconnection", items);
        }
        try {
            if (this._connection != null) {
                this._connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._connection = null;
    }

    private void rollbackConnection() {
        boolean debug = logger.isLoggable(300);
        if (debug) {
            Object[] items = new Object[]{this._connection, this.persistenceManager};
            logger.finest("sqlstore.transactionimpl.rollbackconnection", items);
        }
        if (this._connection != null) {
            try {
                if (this.isDataSource) {
                    this._connection.rollback();
                } else {
                    ((ConnectionImpl)this._connection).internalRollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private int commitConnection() {
        if (this._connection != null) {
            try {
                if (this.isDataSource) {
                    this._connection.commit();
                } else {
                    ((ConnectionImpl)this._connection).internalCommit();
                }
            }
            catch (Exception e) {
                return this.INTERNAL_ERROR;
            }
        }
        return this.INTERNAL_OK;
    }

    public String toString() {
        String s = "  Transaction: \n   status        = " + TransactionImpl.statusString(this.status) + "\n" + "   Transaction Object       = Transaction@" + this.hashCode() + "\n" + "   threads       = " + this.threads + "\n";
        if (this.timeout != 0) {
            s = s + "   timeout       = " + this.timeout + "\n";
        }
        if (this.startedCommit) {
            s = s + "   startedCommit = true\n";
        }
        if (this.onePhase) {
            s = s + "   onePhase      = true\n";
        }
        if (this.synchronization != null) {
            s = s + "sync:     " + this.synchronization + "\n";
        }
        if (!this.resources.isEmpty()) {
            s = s + "   # resources   = " + this.resources.size() + "\n";
        }
        return s;
    }

    static {
        globalLock = "TranGlobalLock";
        logger = LogHelperTransaction.getLogger();
        messages = I18NHelper.loadBundle(TransactionImpl.class);
    }
}

