/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.ejb.monitoring.stats.EjbMonitoringUtils;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.BoundedRangeStatisticImpl;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="bean-pool-mon", group="monitoring", isSingleton=false)
@ManagedObject
@Description(value="Bean Pool Statistics")
public class EjbPoolStatsProvider {
    private CountStatisticImpl createdStat = new CountStatisticImpl("TotalBeansCreated", "count", "Number of beans created in the associated pool");
    private CountStatisticImpl destroyedStat = new CountStatisticImpl("TotalBeansDestroyed", "count", "Number of beans destroyed from the associated pool");
    private CountStatisticImpl jmsStat = new CountStatisticImpl("JmsMaxMessagesLoad", "count", "Provides the maximum number of messages to load into a JMS session, at a time.");
    private BoundedRangeStatisticImpl beansInPool;
    private BoundedRangeStatisticImpl threadsWaiting;
    private static final Logger _logger = EjbContainerUtilImpl.getInstance().getLogger();
    private String appName = null;
    private String moduleName = null;
    private String beanName = null;
    private boolean registered = false;
    private AbstractPool delegate;

    public EjbPoolStatsProvider(AbstractPool delegate, String appName, String moduleName, String beanName) {
        this.delegate = delegate;
        this.appName = appName;
        this.moduleName = moduleName;
        this.beanName = beanName;
        long now = System.currentTimeMillis();
        this.beansInPool = new BoundedRangeStatisticImpl(0L, 0L, 0L, (long)delegate.getMaxPoolSize(), (long)delegate.getSteadyPoolSize(), "NumBeansInPool", "count", "Number of EJBs in associated pool", now, now);
        this.threadsWaiting = new BoundedRangeStatisticImpl(0L, 0L, 0L, Long.MAX_VALUE, 0L, "NumThreadsWaiting", "count", "Number of threads waiting for free beans", now, now);
    }

    public void register() {
        String node = EjbMonitoringUtils.registerSubComponent(this.appName, this.moduleName, this.beanName, "bean-pool", this);
        if (node != null) {
            this.registered = true;
        }
    }

    public void unregister() {
        if (this.registered) {
            this.registered = false;
            StatsProviderManager.unregister((Object)this);
        }
    }

    @ManagedAttribute(id="numbeansinpool")
    @Description(value="Number of EJBs in associated pool")
    public RangeStatistic getNumBeansInPool() {
        return EjbMonitoringUtils.getRangeStatisticForCurrentValue(this.beansInPool, this.delegate.getNumBeansInPool());
    }

    @ManagedAttribute(id="numthreadswaiting")
    @Description(value="Number of threads waiting for free beans")
    public RangeStatistic getNumThreadsWaiting() {
        return EjbMonitoringUtils.getRangeStatisticForCurrentValue(this.threadsWaiting, this.delegate.getNumThreadsWaiting());
    }

    @ManagedAttribute(id="totalbeanscreated")
    @Description(value="Number of Beans created in associated pool")
    public CountStatistic getTotalBeansCreated() {
        return this.createdStat;
    }

    @ManagedAttribute(id="totalbeansdestroyed")
    @Description(value="Number of Beans destroyed in associated pool")
    public CountStatistic getTotalBeansDestroyed() {
        return this.destroyedStat;
    }

    @ManagedAttribute(id="jmsmaxmessagesload")
    @Description(value="Provides the maximum number of messages to load into a JMS session, at a time")
    public CountStatistic getJmsMaxMessagesLoad() {
        return this.jmsStat;
    }

    @ProbeListener(value="glassfish:ejb:pool:objectAddedEvent")
    public void ejbObjectAddedEvent() {
        this.createdStat.increment();
    }

    @ProbeListener(value="glassfish:ejb:pool:objectAddFailedEvent")
    public void ejbObjectAddFailedEvent() {
        this.createdStat.decrement();
    }

    @ProbeListener(value="glassfish:ejb:pool:objectDestroyedEvent")
    public void ejbObjectDestroyedEvent() {
        this.destroyedStat.increment();
    }
}

