/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-custom-resource")
@Scoped(value=PerLookup.class)
@I18n(value="delete.custom.resource")
public class DeleteCustomResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteCustomResource.class);
    @Param(optional=true, defaultValue="server")
    String target;
    @Param(name="jndi_name", primary=true)
    String jndiName;
    @Inject
    Resources resources;
    @Inject
    CustomResource[] customResources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        if (!this.isResourceExists(this.resources, this.jndiName)) {
            report.setMessage(localStrings.getLocalString("delete.custom.resource.notfound", "A custom resource named {0} does not exist.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    for (CustomResource resource : DeleteCustomResource.this.customResources) {
                        if (!resource.getJndiName().equals(DeleteCustomResource.this.jndiName)) continue;
                        param.getResources().remove(resource);
                        break;
                    }
                    return DeleteCustomResource.this.customResources;
                }
            }, (ConfigBeanProxy)this.resources);
            targetServer.deleteResourceRef(this.jndiName);
            report.setMessage(localStrings.getLocalString("delete.custom.resource.success", "Custom resource {0} deleted", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("delete.custom.resource.fail", "Unable to delete custom resource {0}", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
            return;
        }
    }

    private boolean isResourceExists(Resources resources, String jndiName) {
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof CustomResource) || !((CustomResource)resource).getJndiName().equals(jndiName)) continue;
            return true;
        }
        return false;
    }
}

