/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.Arrays;
import java.util.Vector;

public class NewSSLHandlers {
    static String[] COMMON_CIPHERS = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"};
    static String[] BIT_CIPHERS = new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};

    public static void convertToDifferentCiphersGroup(HandlerContext handlerCtx) {
        Vector ciphersVector = null;
        Object ciphers = handlerCtx.getInputValue("ciphers");
        if (ciphers instanceof String) {
            String[] ary = NewSSLHandlers.getSelectedCiphersList((String)ciphers);
            ciphersVector = NewSSLHandlers.getCiphersVector(ary);
        } else {
            ciphersVector = NewSSLHandlers.getCiphersVector((String[])ciphers);
        }
        handlerCtx.setOutputValue("CommonCiphersList", (Object)NewSSLHandlers.getCommonCiphers(ciphersVector));
        handlerCtx.setOutputValue("EphemeralCiphersList", (Object)NewSSLHandlers.getEphemeralCiphers(ciphersVector));
        handlerCtx.setOutputValue("OtherCiphersList", (Object)NewSSLHandlers.getOtherCiphers(ciphersVector));
        handlerCtx.setOutputValue("EccCiphersList", (Object)NewSSLHandlers.getEccCiphers(ciphersVector));
    }

    public static void convertCiphersItemsToStr(HandlerContext handlerCtx) {
        Object test = handlerCtx.getInputValue("test");
        String[] common = (String[])handlerCtx.getInputValue("common");
        String[] ephemeral = (String[])handlerCtx.getInputValue("ephemeral");
        String[] other = (String[])handlerCtx.getInputValue("other");
        String[] ecc = (String[])handlerCtx.getInputValue("ecc");
        String ciphers = NewSSLHandlers.processSelectedCiphers(common, "");
        ciphers = NewSSLHandlers.processSelectedCiphers(ephemeral, ciphers);
        ciphers = NewSSLHandlers.processSelectedCiphers(other, ciphers);
        ciphers = NewSSLHandlers.processSelectedCiphers(ecc, ciphers);
        handlerCtx.setOutputValue("ciphers", (Object)ciphers);
    }

    private static String[] getSelectedCiphersList(String selectedCiphers) {
        Vector<String> selItems = new Vector<String>();
        if (selectedCiphers != null) {
            String[] sel = selectedCiphers.split(",");
            for (int i = 0; i < sel.length; ++i) {
                String cName = sel[i];
                if (!cName.startsWith("+")) continue;
                cName = cName.substring(1, cName.length());
                selItems.add(cName);
            }
        }
        return selItems.toArray(new String[selItems.size()]);
    }

    private static String processSelectedCiphers(String[] selectedCiphers, String ciphers) {
        if (selectedCiphers != null) {
            if (ciphers == null) {
                ciphers = "";
            }
            for (int i = 0; i < selectedCiphers.length; ++i) {
                if (!ciphers.equals("")) {
                    ciphers = ciphers + ",";
                }
                ciphers = ciphers + "+" + selectedCiphers[i];
            }
        }
        return ciphers;
    }

    private static String processDeletedCiphers(String[] oldCiphers, String ciphers) {
        if (oldCiphers != null) {
            for (int i = 0; i < oldCiphers.length; ++i) {
                String cipVal = oldCiphers[i];
                if (ciphers.indexOf(cipVal) == -1) continue;
                if (!ciphers.equals("")) {
                    ciphers = ciphers + ",";
                }
                ciphers = ciphers + "-" + cipVal;
            }
        }
        return ciphers;
    }

    private static Vector getCiphersVector(String[] allCiphers) {
        Vector<String> ciphers = new Vector<String>();
        if (allCiphers != null) {
            for (int i = 0; i < allCiphers.length; ++i) {
                ciphers.add(allCiphers[i]);
            }
        }
        return ciphers;
    }

    private static String[] getCommonCiphers(Vector ciphers) {
        Vector commonCiphers = NewSSLHandlers.filterCiphers(ciphers, COMMON_CIPHERS);
        String[] ciphersList = commonCiphers.toArray(new String[commonCiphers.size()]);
        return ciphersList;
    }

    private static String[] getEccCiphers(Vector ciphers) {
        Vector eccCiphers = NewSSLHandlers.breakUpCiphers(new Vector(), ciphers, "ECDH");
        eccCiphers = NewSSLHandlers.breakUpCiphers(eccCiphers, ciphers, "ECDHE");
        String[] ciphersList = eccCiphers.toArray(new String[eccCiphers.size()]);
        return ciphersList;
    }

    private static String[] getEphemeralCiphers(Vector ciphers) {
        Vector ephmCiphers = NewSSLHandlers.breakUpCiphers(new Vector(), ciphers, "DHE_RSA");
        ephmCiphers = NewSSLHandlers.breakUpCiphers(ephmCiphers, ciphers, "DHE_DSS");
        String[] ciphersList = ephmCiphers.toArray(new String[ephmCiphers.size()]);
        return ciphersList;
    }

    private static String[] getOtherCiphers(Vector ciphers) {
        Vector bitCiphers = NewSSLHandlers.filterCiphers(ciphers, BIT_CIPHERS);
        String[] ciphersList = bitCiphers.toArray(new String[bitCiphers.size()]);
        return ciphersList;
    }

    private static Vector filterCiphers(Vector ciphers, String[] filterList) {
        Vector listCiphers = new Vector();
        if (ciphers != null) {
            for (int i = 0; i < ciphers.size(); ++i) {
                String cipherName = ciphers.get(i).toString();
                if (!Arrays.asList(filterList).contains(cipherName)) continue;
                listCiphers.add(ciphers.get(i));
            }
        }
        return listCiphers;
    }

    private static Vector breakUpCiphers(Vector cipherSubset, Vector allCiphers, String type) {
        if (allCiphers != null) {
            for (int i = 0; i < allCiphers.size(); ++i) {
                String cipherName = allCiphers.get(i).toString();
                if (cipherName.indexOf(type) == -1 || Arrays.asList(BIT_CIPHERS).contains(cipherName)) continue;
                cipherSubset.add(cipherName);
            }
        }
        return cipherSubset;
    }
}

