/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.component.PreDestroy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentContextImpl
implements ExtendedDeploymentContext,
PreDestroy {
    ReadableArchive source;
    ReadableArchive originalSource;
    final OpsParams parameters;
    final Logger logger;
    final ActionReport actionReport;
    final ServerEnvironment env;
    ClassLoader cloader;
    ArchiveHandler archiveHandler;
    Properties props;
    Map<String, Object> modulesMetaData = new HashMap<String, Object>();
    List<ClassFileTransformer> transformers = new ArrayList<ClassFileTransformer>();
    ExtendedDeploymentContext.Phase phase = ExtendedDeploymentContext.Phase.UNKNOWN;
    boolean finalClassLoaderAccessedDuringPrepare = false;
    boolean tempClassLoaderInvalidated = false;
    ClassLoader sharableTemp = null;
    Map<String, Properties> modulePropsMap = new HashMap<String, Properties>();
    Map<String, Object> transientAppMetaData = new HashMap<String, Object>();
    Map<String, ArchiveHandler> moduleArchiveHandlers = new HashMap<String, ArchiveHandler>();
    Map<String, ExtendedDeploymentContext> moduleDeploymentContexts = new HashMap<String, ExtendedDeploymentContext>();

    public DeploymentContextImpl(ActionReport actionReport, Logger logger, ReadableArchive source, OpsParams params, ServerEnvironment env) {
        this.originalSource = source;
        this.source = source;
        this.logger = logger;
        this.actionReport = actionReport;
        this.parameters = params;
        this.env = env;
    }

    public ExtendedDeploymentContext.Phase getPhase() {
        return this.phase;
    }

    public void setPhase(ExtendedDeploymentContext.Phase newPhase) {
        this.phase = newPhase;
    }

    public ReadableArchive getSource() {
        return this.source;
    }

    public void setSource(ReadableArchive source) {
        this.source = source;
    }

    public <U extends OpsParams> U getCommandParameters(Class<U> commandParametersType) {
        try {
            return (U)((OpsParams)commandParametersType.cast(this.parameters));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void preDestroy() {
        try {
            ((PreDestroy)PreDestroy.class.cast(this.sharableTemp)).preDestroy();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ((PreDestroy)PreDestroy.class.cast(this.cloader)).preDestroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ClassLoader getFinalClassLoader() {
        return this.cloader;
    }

    public ClassLoader getClassLoader() {
        return this.getClassLoader(true);
    }

    public void createDeploymentClassLoader(ClassLoaderHierarchy clh, ArchiveHandler handler) throws URISyntaxException, MalformedURLException {
        this.addTransientAppMetaData("isTempClassLoader", Boolean.TRUE);
        this.sharableTemp = this.createClassLoader(clh, handler, null);
    }

    public void createApplicationClassLoader(ClassLoaderHierarchy clh, ArchiveHandler handler) throws URISyntaxException, MalformedURLException {
        this.addTransientAppMetaData("isTempClassLoader", Boolean.FALSE);
        this.cloader = this.createClassLoader(clh, handler, this.parameters.name());
    }

    private ClassLoader createClassLoader(ClassLoaderHierarchy clh, ArchiveHandler handler, String appName) throws URISyntaxException, MalformedURLException {
        ClassLoader applibCL = clh.getAppLibClassLoader(appName, this.getAppLibs());
        ClassLoader parentCL = clh.createApplicationParentCL(applibCL, (DeploymentContext)this);
        return handler.getClassLoader(parentCL, (DeploymentContext)this);
    }

    public synchronized ClassLoader getClassLoader(boolean sharable) {
        if (this.phase == ExtendedDeploymentContext.Phase.PREPARE) {
            if (sharable) {
                return this.sharableTemp;
            }
            InstrumentableClassLoader cl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(this.sharableTemp);
            return cl.copy();
        }
        if (this.sharableTemp != null) {
            try {
                ((PreDestroy)PreDestroy.class.cast(this.sharableTemp)).preDestroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sharableTemp = null;
        }
        return this.cloader;
    }

    public File getScratchDir(String subDirName) {
        File rootScratchDir = this.env.getApplicationStubPath();
        if (subDirName != null) {
            rootScratchDir = new File(rootScratchDir, subDirName);
        }
        return new File(rootScratchDir, this.parameters.name());
    }

    public File getSourceDir() {
        return new File(this.getSource().getURI());
    }

    public void addModuleMetaData(Object metaData) {
        if (metaData != null) {
            this.modulesMetaData.put(metaData.getClass().getName(), metaData);
        }
    }

    public <T> T getModuleMetaData(Class<T> metadataType) {
        Object moduleMetaData = this.modulesMetaData.get(metadataType.getName());
        if (moduleMetaData != null) {
            return metadataType.cast(moduleMetaData);
        }
        for (Object metadata : this.modulesMetaData.values()) {
            try {
                return metadataType.cast(metadata);
            }
            catch (ClassCastException e) {
            }
        }
        return null;
    }

    public Collection<Object> getModuleMetadata() {
        ArrayList<Object> copy = new ArrayList<Object>();
        copy.addAll(this.modulesMetaData.values());
        return copy;
    }

    public Map<String, Object> getTransientAppMetadata() {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        copy.putAll(this.transientAppMetaData);
        return copy;
    }

    public void addTransientAppMetaData(String metaDataKey, Object metaData) {
        if (metaData != null) {
            this.transientAppMetaData.put(metaDataKey, metaData);
        }
    }

    public <T> T getTransientAppMetaData(String key, Class<T> metadataType) {
        Object metaData = this.transientAppMetaData.get(key);
        if (metaData != null) {
            return metadataType.cast(metaData);
        }
        return null;
    }

    public Properties getAppProps() {
        if (this.props == null) {
            this.props = new Properties();
        }
        return this.props;
    }

    public Properties getModuleProps() {
        return this.props;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.transformers.add(transformer);
    }

    public List<ClassFileTransformer> getTransformers() {
        return this.transformers;
    }

    private List<URI> getAppLibs() throws URISyntaxException {
        ArrayList<URI> libURIs = new ArrayList<URI>();
        if (this.parameters.libraries() != null) {
            URL[] urls;
            for (URL url : urls = ASClassLoaderUtil.getDeployParamLibrariesAsURLs(this.parameters.libraries(), this.env)) {
                libURIs.add(url.toURI());
            }
        }
        return libURIs;
    }

    public void clean() {
        File generatedXmlRoot = this.getScratchDir("xml");
        FileUtils.whack((File)generatedXmlRoot);
        File generatedEjbRoot = this.getScratchDir("ejb");
        FileUtils.whack((File)generatedEjbRoot);
        File generatedJspRoot = this.getScratchDir("jsp");
        FileUtils.whack((File)generatedJspRoot);
    }

    public ArchiveHandler getArchiveHandler() {
        return this.archiveHandler;
    }

    public void setArchiveHandler(ArchiveHandler archiveHandler) {
        this.archiveHandler = archiveHandler;
    }

    public ReadableArchive getOriginalSource() {
        return this.originalSource;
    }

    public Map<String, Properties> getModulePropsMap() {
        return this.modulePropsMap;
    }

    public void setModulePropsMap(Map<String, Properties> modulePropsMap) {
        this.modulePropsMap = modulePropsMap;
    }

    public Map<String, ArchiveHandler> getModuleArchiveHandlers() {
        return this.moduleArchiveHandlers;
    }

    public Map<String, ExtendedDeploymentContext> getModuleDeploymentContexts() {
        return this.moduleDeploymentContexts;
    }

    public ActionReport getActionReport() {
        return this.actionReport;
    }
}

