/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLILogger;
import com.sun.enterprise.admin.cli.CLIManFileFinder;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.admin.cli.util.CLIUtil;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Contract
@Scoped(value=PerLookup.class)
public abstract class CLICommand
implements PostConstruct {
    public static final int ERROR = 1;
    public static final int CONNECTION_ERROR = 2;
    public static final int INVALID_COMMAND_ERROR = 3;
    public static final int SUCCESS = 0;
    private static final Set<String> unsupported;
    private static final String UNSUPPORTED_CMD_FILE_NAME = "unsupported-legacy-command-names";
    private static final LocalStringsImpl strings;
    private static final Map<String, String> systemProps;
    protected static final CLILogger logger;
    protected String name;
    @Inject
    protected ProgramOptions programOpts;
    @Inject
    protected Environment env;
    protected String[] argv;
    protected Set<ValidOption> commandOpts;
    protected StringBuilder metadataErrors;
    protected String operandName = "";
    protected String operandType;
    protected int operandMin;
    protected int operandMax;
    protected boolean unknownOptionsAreOperands = false;
    protected Map<String, String> options;
    protected List<String> operands;
    protected Map<String, String> passwords;

    public static CLICommand getCommand(Habitat habitat, String name) throws CommandException {
        CLICommand.checkUnsupportedLegacyCommand(name);
        CLICommand cmd = (CLICommand)habitat.getComponent(CLICommand.class, name);
        if (cmd != null) {
            return cmd;
        }
        logger.printDebugMessage("Assuming it's a remote command: " + name);
        return new RemoteCommand(name, (ProgramOptions)habitat.getComponent(ProgramOptions.class), (Environment)habitat.getComponent(Environment.class));
    }

    protected CLICommand() {
        Service service = this.getClass().getAnnotation(Service.class);
        this.name = service == null ? "unknown-command" : service.name();
    }

    public void postConstruct() {
        this.initializeLogger();
    }

    protected CLICommand(String name, ProgramOptions programOpts, Environment env) {
        this.name = name;
        this.programOpts = programOpts;
        this.env = env;
        this.initializeLogger();
    }

    protected static ValidOption addOption(Set<ValidOption> opts, String name, char sname, String type, boolean req, String def) {
        ValidOption opt = new ValidOption(name, type, req ? 1 : 2, def);
        if (sname != '\u0000') {
            String abbr = Character.toString(sname);
            opt.setShortName(abbr);
        }
        opts.add(opt);
        return opt;
    }

    public int execute(String ... argv) throws CommandException, CommandValidationException {
        this.argv = argv;
        this.initializePasswords();
        this.prepare();
        this.parse();
        if (this.checkHelp()) {
            return 0;
        }
        this.validate();
        if (this.programOpts.isEcho()) {
            logger.printMessage(this.toString());
            this.programOpts.setEcho(false);
        } else if (logger.isDebug()) {
            logger.printDebugMessage(this.toString());
        }
        return this.executeCommand();
    }

    public String getName() {
        return this.name;
    }

    public Reader getManPage() {
        return CLIManFileFinder.getCommandManFile(this);
    }

    public String getUsage() {
        StringBuilder usageText = new StringBuilder();
        usageText.append(strings.get("Usage", new Object[]{strings.get("Usage.asadmin")}));
        usageText.append(" ");
        usageText.append(this.getName());
        usageText.append(" ");
        this.addOptionUsage(this.usageOptions(), usageText);
        String opname = this.operandName;
        if (!CLICommand.ok(opname)) {
            opname = "operand";
        }
        if (this.operandMax > 0) {
            if (this.operandMin == 0) {
                usageText.append("[").append(opname);
                if (this.operandMax > 1) {
                    usageText.append(" ...");
                }
                usageText.append("] ");
            } else {
                usageText.append(opname);
                if (this.operandMax > 1) {
                    usageText.append(" ...");
                }
                usageText.append(" ");
            }
        }
        return usageText.toString();
    }

    protected Set<ValidOption> usageOptions() {
        return this.commandOpts;
    }

    private void addOptionUsage(Set<ValidOption> options, StringBuilder usageText) {
        for (ValidOption opt : options) {
            String optName = opt.getName();
            if (opt.getType().equals("PASSWORD")) continue;
            boolean optional = opt.isValueRequired() != 1;
            String defValue = opt.getDefaultValue();
            if (optional) {
                usageText.append("[");
            }
            if (opt.hasShortName()) {
                Vector<String> sn = opt.getShortNames();
                usageText.append('-').append(sn.get(0)).append('|');
            }
            usageText.append("--").append(optName);
            if (opt.getType().equals("BOOLEAN")) {
                if (CLICommand.ok(defValue) && Boolean.parseBoolean(defValue)) {
                    usageText.append("=").append("true");
                } else {
                    usageText.append("=").append("false");
                }
            } else if (CLICommand.ok(defValue)) {
                usageText.append(" ").append(defValue);
            } else {
                usageText.append(" <").append(optName).append('>');
            }
            if (optional) {
                usageText.append("] ");
                continue;
            }
            usageText.append(" ");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("asadmin ");
        sb.append(this.programOpts.toString()).append(' ');
        sb.append(this.name).append(' ');
        if (this.options != null && this.operands != null) {
            for (ValidOption opt : this.commandOpts) {
                if (opt.getType().equals("PASSWORD")) continue;
                String value = this.getOption(opt.getName());
                if (value == null) {
                    value = opt.getDefaultValue();
                }
                if (value == null) continue;
                sb.append("--").append(opt.getName());
                if (opt.getType().equals("BOOLEAN")) {
                    if (Boolean.parseBoolean(value)) {
                        sb.append("=").append("true");
                    } else {
                        sb.append("=").append("false");
                    }
                } else {
                    sb.append(" ").append(value);
                }
                sb.append(' ');
            }
            for (String o : this.operands) {
                sb.append((Object)o).append(' ');
            }
        } else if (this.argv != null) {
            for (String arg : this.argv) {
                sb.append(arg).append(' ');
            }
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    protected void processProgramOptions() throws CommandException, CommandValidationException {
        if (!this.programOpts.isOptionsSet()) {
            logger.printDebugMessage("Parsing program options");
            Parser rcp = new Parser(this.argv, 0, ProgramOptions.getValidOptions(), true);
            Map<String, String> params = rcp.getOptions();
            List<String> operands = rcp.getOperands();
            this.argv = operands.toArray(new String[operands.size()]);
            if (params.size() > 0) {
                logger.printDebugMessage("Update program options");
                this.programOpts.updateOptions(params);
                this.initializeLogger();
                this.initializePasswords();
                if (!(this.programOpts.isTerse() || params.size() == 1 && params.get("help") != null)) {
                    Set<ValidOption> programOptions = ProgramOptions.getValidOptions();
                    StringBuilder sb = new StringBuilder();
                    sb.append("asadmin");
                    for (Map.Entry<String, String> p : params.entrySet()) {
                        ValidOption opt = null;
                        for (ValidOption vo : programOptions) {
                            if (!vo.getName().equals(p.getKey())) continue;
                            opt = vo;
                            break;
                        }
                        if (opt == null) continue;
                        sb.append(" --").append(p.getKey());
                        if (opt.getType().equals("BOOLEAN")) {
                            if (p.getValue().equalsIgnoreCase("true")) continue;
                            sb.append("=false");
                            continue;
                        }
                        if (!CLICommand.ok(p.getValue())) continue;
                        sb.append(" ").append(p.getValue());
                    }
                    sb.append(" ").append(this.name).append(" [options] ...");
                    logger.printMessage(strings.get("DeprecatedSyntax"));
                    logger.printMessage(sb.toString());
                }
            }
        }
    }

    protected void initializeLogger() {
        if (this.programOpts.isTerse()) {
            logger.setOutputLevel(Level.INFO);
        } else {
            logger.setOutputLevel(Level.FINE);
        }
    }

    protected void initializePasswords() throws CommandException {
        this.passwords = new HashMap<String, String>();
        String pwfile = this.programOpts.getPasswordFile();
        if (CLICommand.ok(pwfile)) {
            this.passwords = CLIUtil.readPasswordFileOptions(pwfile, true);
            logger.printDebugMessage("Passwords from password file " + this.passwords);
            String password = this.passwords.get("AS_ADMIN_PASSWORD");
            if (password != null && this.programOpts.getPassword() == null) {
                this.programOpts.setPassword(password, ProgramOptions.PasswordLocation.PASSWORD_FILE);
            }
        }
    }

    protected abstract void prepare() throws CommandException, CommandValidationException;

    protected void parse() throws CommandException, CommandValidationException {
        if (this.programOpts.isHelp()) {
            this.options = new HashMap<String, String>();
            this.options.put("help", "true");
            this.operands = Collections.emptyList();
        } else {
            Parser rcp = new Parser(this.argv, 1, this.commandOpts, this.unknownOptionsAreOperands);
            this.options = rcp.getOptions();
            this.operands = rcp.getOperands();
            if (this.unknownOptionsAreOperands && this.operands.size() > 0 && this.operands.get(0).equals("--")) {
                this.operands.remove(0);
            }
        }
        logger.printDebugMessage("params: " + this.options);
        logger.printDebugMessage("operands: " + this.operands);
    }

    protected void validate() throws CommandException, CommandValidationException {
        Console cons = this.programOpts.isInteractive() ? System.console() : null;
        boolean missingOption = false;
        for (ValidOption opt : this.commandOpts) {
            if (opt.getType().equals("PASSWORD") || opt.isValueRequired() != 1) continue;
            if (this.getOption(opt.getName()) == null && cons != null && !missingOption) {
                cons.printf("%s", strings.get("optionPrompt", new Object[]{opt.getName()}));
                String val = cons.readLine();
                if (CLICommand.ok(val)) {
                    this.options.put(opt.getName(), val);
                }
            }
            if (this.getOption(opt.getName()) != null) continue;
            missingOption = true;
            logger.printMessage(strings.get("missingOption", new Object[]{"--" + opt.getName()}));
        }
        if (missingOption) {
            throw new CommandValidationException(strings.get("missingOptions", new Object[]{this.name}));
        }
        if (this.operands.size() < this.operandMin && cons != null) {
            cons.printf("%s", strings.get("operandPrompt", new Object[]{this.operandName}));
            String val = cons.readLine();
            if (CLICommand.ok(val)) {
                this.operands = new ArrayList<String>();
                this.operands.add(val);
            }
        }
        if (this.operands.size() < this.operandMin) {
            throw new CommandValidationException(strings.get("notEnoughOperands", new Object[]{this.name, this.operandType}));
        }
        if (this.operands.size() > this.operandMax) {
            if (this.operandMax == 0) {
                throw new CommandValidationException(strings.get("noOperandsAllowed", new Object[]{this.name}));
            }
            if (this.operandMax == 1) {
                throw new CommandValidationException(strings.get("tooManyOperands1", new Object[]{this.name}));
            }
            throw new CommandValidationException(strings.get("tooManyOperands", new Object[]{this.name, this.operandMax}));
        }
        this.initializeCommandPassword();
    }

    protected boolean checkHelp() throws CommandException, CommandValidationException {
        if (this.programOpts.isHelp() || this.getBooleanOption("help")) {
            Reader r = this.getManPage();
            if (r == null) {
                throw new CommandException(strings.get("ManpageMissing", new Object[]{this.name}));
            }
            BufferedReader br = new BufferedReader(r);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException ioex) {
                throw new CommandException(strings.get("ManpageMissing", new Object[]{this.name}), ioex);
            }
            return true;
        }
        return false;
    }

    protected abstract int executeCommand() throws CommandException, CommandValidationException;

    private void initializeCommandPassword() throws CommandException, CommandValidationException {
        for (ValidOption opt : this.commandOpts) {
            if (!opt.getType().equals("PASSWORD")) continue;
            String pwdname = opt.getName();
            String pwd = this.getPassword(opt, null, true);
            String description = opt.getDefaultValue();
            if (!CLICommand.ok(description)) {
                description = pwdname;
            }
            if (pwd == null) {
                if (opt.isValueRequired() != 1) continue;
                throw new CommandValidationException(strings.get("missingPassword", new Object[]{this.name, description}));
            }
            this.options.put(pwdname, pwd);
        }
    }

    protected String getPassword(ValidOption opt, String defaultPassword, boolean create) throws CommandValidationException {
        String passwordName = opt.getName();
        String password = this.passwords.get(passwordName);
        if (password != null) {
            return password;
        }
        if (opt.isValueRequired() != 1) {
            return null;
        }
        if (!this.programOpts.isInteractive()) {
            return null;
        }
        String description = opt.getDefaultValue();
        String newprompt = CLICommand.ok(description) ? (defaultPassword != null ? (defaultPassword.length() == 0 ? strings.get("NewPasswordDescriptionDefaultEmptyPrompt", new Object[]{description}) : strings.get("NewPasswordDescriptionDefaultPrompt", new Object[]{description, defaultPassword})) : strings.get("NewPasswordDescriptionPrompt", new Object[]{description})) : (defaultPassword != null ? (defaultPassword.length() == 0 ? strings.get("NewPasswordDefaultEmptyPrompt", new Object[]{passwordName}) : strings.get("NewPasswordDefaultPrompt", new Object[]{passwordName, defaultPassword})) : strings.get("NewPasswordPrompt", new Object[]{passwordName}));
        String newpassword = this.readPassword(newprompt);
        if (defaultPassword != null) {
            if (newpassword == null) {
                newpassword = "";
            }
            if (newpassword.length() == 0) {
                newpassword = defaultPassword;
                this.passwords.put(passwordName, newpassword);
                return newpassword;
            }
        }
        if (!create) {
            this.passwords.put(passwordName, newpassword);
            return newpassword;
        }
        String confirmationPrompt = CLICommand.ok(description) ? strings.get("NewPasswordDescriptionConfirmationPrompt", new Object[]{description}) : strings.get("NewPasswordConfirmationPrompt", new Object[]{passwordName});
        String newpasswordAgain = this.readPassword(confirmationPrompt);
        if (!newpassword.equals(newpasswordAgain)) {
            throw new CommandValidationException(strings.get("OptionsDoNotMatch", new Object[]{CLICommand.ok(description) ? description : passwordName}));
        }
        this.passwords.put(passwordName, newpassword);
        return newpassword;
    }

    protected String readPassword(String prompt) {
        String password = null;
        Console cons = System.console();
        if (cons != null) {
            char[] pc = cons.readPassword("%s", prompt);
            password = new String(pc);
        }
        return password;
    }

    protected String getOption(String name) {
        String val = this.options.get(name);
        if (val == null) {
            val = this.env.getStringOption(name);
        }
        if (val == null) {
            for (ValidOption opt : this.commandOpts) {
                if (opt.getType().equals("PASSWORD") || !opt.getName().equals(name) || opt.getDefaultValue() == null) continue;
                val = opt.getDefaultValue();
                break;
            }
        }
        return val;
    }

    protected boolean getBooleanOption(String name) {
        String val = this.getOption(name);
        return val != null && Boolean.parseBoolean(val);
    }

    protected String getSystemProperty(String name) {
        return systemProps.get(name);
    }

    private static void checkUnsupportedLegacyCommand(String cmd) throws CommandException {
        for (String c : unsupported) {
            if (!c.equals(cmd)) continue;
            throw new CommandException(strings.get("UnsupportedLegacyCommand", new Object[]{cmd}));
        }
    }

    protected static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void file2Set(String file, Set<String> set) {
        BufferedReader reader = null;
        try {
            String line;
            InputStream is = CLICommand.class.getClassLoader().getResourceAsStream(file);
            if (is == null) {
                return;
            }
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                StringTokenizer tok = new StringTokenizer(line, " ");
                String cmd = tok.nextToken();
                set.add(cmd);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        strings = new LocalStringsImpl(CLICommand.class);
        systemProps = Collections.unmodifiableMap(new ASenvPropertyReader().getProps());
        logger = CLILogger.getInstance();
        HashSet<String> unsup = new HashSet<String>();
        CLICommand.file2Set(UNSUPPORTED_CMD_FILE_NAME, unsup);
        unsupported = Collections.unmodifiableSet(unsup);
    }
}

