/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.ArgumentTokenizer;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CommandException;
import com.sun.enterprise.admin.cli.CommandValidationException;
import com.sun.enterprise.admin.cli.InvalidCommandException;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.ValidOption;
import com.sun.enterprise.admin.cli.util.CLIUtil;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="multimode")
@Scoped(value=PerLookup.class)
public class MultimodeCommand
extends CLICommand {
    @Inject
    private Habitat habitat;
    private boolean printPrompt;
    private String encoding;
    private File file;
    private static final LocalStringsImpl strings = new LocalStringsImpl(MultimodeCommand.class);

    protected void prepare() throws CommandException {
        LinkedHashSet<ValidOption> opts = new LinkedHashSet<ValidOption>();
        MultimodeCommand.addOption(opts, "file", 'f', "FILE", false, null);
        MultimodeCommand.addOption(opts, "printprompt", '\u0000', "BOOLEAN", false, "true");
        MultimodeCommand.addOption(opts, "encoding", '\u0000', "STRING", false, null);
        MultimodeCommand.addOption(opts, "help", '?', "BOOLEAN", false, "false");
        this.commandOpts = Collections.unmodifiableSet(opts);
        this.operandType = "STRING";
        this.operandMin = 0;
        this.operandMax = 0;
    }

    protected void validate() throws CommandException, CommandValidationException {
        super.validate();
        String pp = this.getOption("printprompt");
        this.printPrompt = pp != null ? Boolean.parseBoolean(pp) : this.programOpts.isInteractive();
        this.encoding = this.getOption("encoding");
        String fname = this.getOption("file");
        if (fname != null) {
            this.file = new File(fname);
        }
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        BufferedReader reader = null;
        try {
            if (this.file == null) {
                System.out.println(strings.get("multimodeIntro"));
                if (this.encoding != null) {
                    reader = new BufferedReader(new InputStreamReader(System.in, this.encoding));
                }
                reader = new BufferedReader(new InputStreamReader(System.in));
            } else {
                this.printPrompt = false;
                if (!this.file.canRead()) {
                    throw new CommandException("File: " + this.file + " can not be read");
                }
                reader = this.encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding)) : new BufferedReader(new FileReader(this.file));
            }
            int n = this.executeCommands(reader);
            return n;
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
        finally {
            try {
                if (this.file != null && reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCommands(BufferedReader reader) throws CommandException, CommandValidationException, IOException {
        String line = null;
        int rc = 0;
        this.programOpts.toEnvironment(this.env);
        while (true) {
            String command;
            if (this.printPrompt) {
                System.out.print("asadmin> ");
                System.out.flush();
            }
            if ((line = reader.readLine()) == null) {
                if (!this.printPrompt) break;
                System.out.println();
                break;
            }
            if (line.trim().startsWith("#")) continue;
            String[] args = null;
            try {
                args = this.getArgs(line);
            }
            catch (ArgumentTokenizer.ArgumentException ex) {
                logger.printMessage(ex.getMessage());
                continue;
            }
            if (args.length == 0 || (command = args[0]).length() == 0) continue;
            if (command.equals("exit") || command.equals("quit")) break;
            CLICommand cmd = null;
            ProgramOptions po = null;
            try {
                po = new ProgramOptions(this.env);
                po.setProgramArguments(this.programOpts.getProgramArguments());
                po.setClassPath(this.programOpts.getClassPath());
                po.setClassName(this.programOpts.getClassName());
                this.habitat.remove(this.habitat.getInhabitantByType(ProgramOptions.class));
                this.habitat.addComponent("program-options", (Object)po);
                cmd = CLICommand.getCommand(this.habitat, command);
                rc = cmd.execute(args);
            }
            catch (CommandValidationException cve) {
                logger.printError(cve.getMessage());
                logger.printError(cmd.getUsage());
                rc = 1;
            }
            catch (CommandException ce) {
                if (ce.getCause() instanceof InvalidCommandException) {
                    logger.printError(ce.getMessage());
                    try {
                        CLIUtil.displayClosestMatch(command, CLIUtil.getAllCommands(this.habitat, po, this.env), strings.get("ClosestMatchedLocalAndRemoteCommands"));
                    }
                    catch (InvalidCommandException e) {}
                } else if (ce.getCause() instanceof ConnectException) {
                    logger.printError(ce.getMessage());
                    try {
                        CLIUtil.displayClosestMatch(command, CLIUtil.getLocalCommands(this.habitat), strings.get("ClosestMatchedLocalCommands"));
                    }
                    catch (InvalidCommandException e) {
                        logger.printMessage(strings.get("InvalidRemoteCommand", new Object[]{command}));
                    }
                } else {
                    logger.printError(ce.getMessage());
                }
                rc = 1;
            }
            finally {
                this.habitat.remove(this.habitat.getInhabitantByType(ProgramOptions.class));
                this.habitat.addComponent("program-options", (Object)this.programOpts);
            }
            switch (rc) {
                case 0: {
                    if (this.programOpts.isTerse()) break;
                    logger.printDetailMessage(strings.get("CommandSuccessful", new Object[]{command}));
                    break;
                }
                case 1: {
                    logger.printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
                    break;
                }
                case 3: {
                    logger.printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
                    break;
                }
                case 2: {
                    logger.printDetailMessage(strings.get("CommandUnSuccessful", new Object[]{command}));
                }
            }
            CLIUtil.writeCommandToDebugLog(args, rc);
        }
        return rc;
    }

    private String[] getArgs(String line) throws ArgumentTokenizer.ArgumentException {
        ArrayList<String> args = new ArrayList<String>();
        ArgumentTokenizer t = new ArgumentTokenizer(line);
        while (t.hasMoreTokens()) {
            args.add(t.nextToken());
        }
        return args.toArray(new String[args.size()]);
    }
}

