/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CascadeTypes;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.JoinTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipAccessor
extends MappingAccessor {
    private Boolean m_orphanRemoval;
    private boolean m_privateOwned;
    private CascadeTypes m_cascadeTypes;
    protected MetadataClass m_referenceClass;
    private MetadataClass m_targetEntity;
    private String m_fetch;
    private String m_joinFetch;
    private JoinTableMetadata m_joinTable;
    private List<JoinColumnMetadata> m_joinColumns = new ArrayList<JoinColumnMetadata>();
    private String m_targetEntityName;

    protected RelationshipAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected RelationshipAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        MetadataAnnotation joinColumn;
        this.m_fetch = annotation == null ? this.getDefaultFetchType() : (String)annotation.getAttribute("fetch");
        this.m_targetEntity = this.getMetadataClass(annotation == null ? "void" : (String)annotation.getAttributeString("targetEntity"));
        this.m_cascadeTypes = annotation == null ? null : new CascadeTypes((Object[])annotation.getAttributeArray("cascade"), accessibleObject);
        MetadataAnnotation joinFetch = this.getAnnotation(JoinFetch.class);
        if (joinFetch != null) {
            this.m_joinFetch = (String)joinFetch.getAttribute("value");
            if (this.m_joinFetch == null) {
                this.m_joinFetch = "";
            }
        }
        this.m_privateOwned = this.isAnnotationPresent(PrivateOwned.class);
        MetadataAnnotation joinColumns = this.getAnnotation(JoinColumns.class);
        if (joinColumns != null) {
            for (Object jColumn : (Object[])joinColumns.getAttributeArray("value")) {
                this.m_joinColumns.add(new JoinColumnMetadata((MetadataAnnotation)jColumn, accessibleObject));
            }
        }
        if ((joinColumn = this.getAnnotation(JoinColumn.class)) != null) {
            this.m_joinColumns.add(new JoinColumnMetadata(joinColumn, accessibleObject));
        }
        if (this.isAnnotationPresent(JoinTable.class)) {
            this.m_joinTable = new JoinTableMetadata(this.getAnnotation(JoinTable.class), accessibleObject);
        }
    }

    protected void addManyToManyRelationKeyFields(List<JoinColumnMetadata> joinColumns, ManyToManyMapping mapping, String defaultFieldName, MetadataDescriptor descriptor, boolean isSource) {
        String FK_CTX;
        String PK_CTX;
        if (isSource) {
            PK_CTX = "metadata_default_source_pk_column";
            FK_CTX = "metadata_default_source_fk_column";
        } else {
            PK_CTX = "metadata_default_target_pk_column";
            FK_CTX = "metadata_default_target_fk_column";
        }
        for (JoinColumnMetadata joinColumn : joinColumns) {
            String defaultPKFieldName = descriptor.getPrimaryKeyFieldName();
            DatabaseField pkField = joinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, defaultPKFieldName, PK_CTX), Helper.getDefaultStartDatabaseDelimiter(), Helper.getDefaultEndDatabaseDelimiter());
            if (this.useDelimitedIdentifier()) {
                pkField.setUseDelimiters(this.useDelimitedIdentifier());
            }
            pkField.setTable(descriptor.getPrimaryKeyTable());
            DatabaseField fkField = joinColumn.getForeignKeyField();
            String defaultFKFieldName = defaultFieldName + "_" + defaultPKFieldName;
            fkField.setName(this.getName(fkField, defaultFKFieldName, FK_CTX));
            fkField.setUseDelimiters(this.useDelimitedIdentifier());
            fkField.setTable(mapping.getRelationTable());
            if (isSource) {
                mapping.addSourceRelationKeyField(fkField, pkField);
                continue;
            }
            mapping.addTargetRelationKeyField(fkField, pkField);
        }
    }

    public CascadeTypes getCascadeTypes() {
        return this.m_cascadeTypes;
    }

    @Override
    public abstract String getDefaultFetchType();

    @Override
    protected DatabaseTable getDefaultTableForEntityMapKey() {
        if (this.getJoinTable() != null) {
            return this.getJoinTable().getDatabaseTable();
        }
        return super.getDefaultTableForEntityMapKey();
    }

    public String getFetch() {
        return this.m_fetch;
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    public String getJoinFetch() {
        return this.m_joinFetch;
    }

    public JoinTableMetadata getJoinTable() {
        return this.m_joinTable;
    }

    protected JoinTableMetadata getJoinTableMetadata() {
        if (this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName())) {
            if (this.m_joinTable != null) {
                // empty if block
            }
            this.m_joinTable = this.getDescriptor().getAssociationOverrideFor(this.getAttributeName()).getJoinTable();
        } else if (this.m_joinTable == null) {
            this.m_joinTable = new JoinTableMetadata(null, this.getAccessibleObject());
        }
        return this.m_joinTable;
    }

    protected abstract String getLoggingContext();

    public Boolean getOrphanRemoval() {
        return this.m_orphanRemoval;
    }

    protected DatabaseMapping getOwningMapping(String mappedBy) {
        MetadataDescriptor ownerDescriptor = this.getReferenceDescriptor();
        DatabaseMapping mapping = ownerDescriptor.getMappingForAttributeName(mappedBy, this);
        if (mapping == null) {
            throw ValidationException.noMappedByAttributeFound((Object)ownerDescriptor.getJavaClass(), (String)mappedBy, (Object)this.getJavaClass(), (String)this.getAttributeName());
        }
        return mapping;
    }

    public String getPrivateOwned() {
        return null;
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        MetadataDescriptor descriptor;
        try {
            descriptor = super.getReferenceDescriptor();
        }
        catch (Exception exception) {
            descriptor = null;
        }
        if (descriptor == null || descriptor.isEmbeddable() || descriptor.isEmbeddableCollection()) {
            throw ValidationException.nonEntityTargetInRelationship((Object)this.getJavaClass(), (Object)this.getReferenceClass(), (Object)this.getAnnotatedElement());
        }
        return descriptor;
    }

    public MetadataClass getTargetEntity() {
        return this.m_targetEntity;
    }

    public String getTargetEntityName() {
        return this.m_targetEntityName;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_joinColumns, accessibleObject);
        this.initXMLObject(this.m_joinTable, accessibleObject);
        this.initXMLObject(this.m_cascadeTypes, accessibleObject);
        this.m_targetEntity = this.initXMLClassName(this.m_targetEntityName);
    }

    public boolean isLazy() {
        String fetchType = this.getFetch();
        if (fetchType == null) {
            fetchType = this.getDefaultFetchType();
        }
        return fetchType.equals(FetchType.LAZY.name());
    }

    protected boolean isOrphanRemoval() {
        return this.m_orphanRemoval != null && this.m_orphanRemoval != false;
    }

    public boolean isPrivateOwned() {
        return this.m_privateOwned;
    }

    public boolean isValueHolderInterface() {
        return this.getTargetEntity().getName().equals(ValueHolderInterface.class.getName()) || this.getTargetEntity().getName().equals(Void.TYPE.getName()) && this.getReferenceClass().getName().equals(ValueHolderInterface.class.getName());
    }

    protected void processCascadeTypes(ForeignReferenceMapping mapping) {
        if (this.m_cascadeTypes != null) {
            for (String cascadeType : this.m_cascadeTypes.getTypes()) {
                this.setCascadeType(cascadeType, mapping);
            }
        }
        if (this.getDescriptor().isCascadePersist() && !mapping.isCascadePersist()) {
            this.setCascadeType(CascadeType.PERSIST.name(), mapping);
        }
    }

    protected void processOrphanRemoval(ForeignReferenceMapping mapping) {
        if (this.isOrphanRemoval()) {
            mapping.setIsPrivateOwned(true);
            mapping.setCascadeRemove(true);
        } else {
            mapping.setIsPrivateOwned(this.isPrivateOwned());
        }
    }

    public void processRelationship() {
        if (!this.isProcessed()) {
            if (this.hasColumn()) {
                throw ValidationException.invalidColumnAnnotationOnRelationship((Object)this.getJavaClass(), (String)this.getAttributeName());
            }
            if (this.hasConvert(false)) {
                throw ValidationException.invalidMappingForConverter((Object)this.getJavaClass(), (Object)this.getAttributeName());
            }
            this.process();
        }
    }

    @Override
    protected void setAccessorMethods(DatabaseMapping mapping) {
        super.setAccessorMethods(mapping);
        ((ForeignReferenceMapping)mapping).setRequiresTransientWeavedFields(this.usesPropertyAccess(this.getDescriptor()) && !this.getClassAccessor().usesPropertyAccess());
    }

    protected void setCascadeType(String type, ForeignReferenceMapping mapping) {
        if (type.equals(CascadeType.ALL.name())) {
            mapping.setCascadeAll(true);
        } else if (type.equals(CascadeType.MERGE.name())) {
            mapping.setCascadeMerge(true);
        } else if (type.equals(CascadeType.PERSIST.name())) {
            mapping.setCascadePersist(true);
        } else if (type.equals(CascadeType.REFRESH.name())) {
            mapping.setCascadeRefresh(true);
        } else if (type.equals(CascadeType.REMOVE.name())) {
            mapping.setCascadeRemove(true);
        }
    }

    public void setCascadeTypes(CascadeTypes cascadeTypes) {
        this.m_cascadeTypes = cascadeTypes;
    }

    public void setFetch(String fetch) {
        this.m_fetch = fetch;
    }

    public void setJoinColumns(List<JoinColumnMetadata> joinColumns) {
        this.m_joinColumns = joinColumns;
    }

    public void setJoinFetch(String joinFetch) {
        this.m_joinFetch = joinFetch;
    }

    public void setJoinTable(JoinTableMetadata joinTable) {
        this.m_joinTable = joinTable;
    }

    public void setOrphanRemoval(Boolean orphanRemoval) {
        this.m_orphanRemoval = orphanRemoval;
    }

    public void setPrivateOwned(String ignore) {
        this.m_privateOwned = true;
    }

    public void setTargetEntity(MetadataClass targetEntity) {
        this.m_targetEntity = targetEntity;
    }

    public void setTargetEntityName(String targetEntityName) {
        this.m_targetEntityName = targetEntityName;
    }

    @Override
    protected boolean usesIndirection() {
        if (this.getProject().weaveEager()) {
            return true;
        }
        return this.isLazy();
    }
}

