/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metamodel.BasicTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EmbeddableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EntityTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.IdentifiableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MappedSuperclassTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.sessions.DatabaseSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelImpl
implements Metamodel {
    protected DatabaseSession session;
    protected Map<Class, EntityTypeImpl<?>> entities;
    protected Map<Class, EmbeddableTypeImpl<?>> embeddables;
    protected Map<Class, ManagedTypeImpl<?>> managedTypes;
    private Map<Class, TypeImpl<?>> types;
    private Set<MappedSuperclassTypeImpl<?>> mappedSuperclasses;
    public static final Class DEFAULT_ELEMENT_TYPE_FOR_UNSUPPORTED_MAPPINGS = Object.class;

    public MetamodelImpl(DatabaseSession session) {
        this.session = session;
        this.initialize();
    }

    public MetamodelImpl(EntityManager em) {
        this((DatabaseSession)JpaHelper.getEntityManager(em).getServerSession());
    }

    public MetamodelImpl(EntityManagerFactory emf) {
        this((DatabaseSession)JpaHelper.getServerSession(emf));
    }

    public <X> EmbeddableType<X> embeddable(Class<X> clazz) {
        EmbeddableTypeImpl<?> aType = this.embeddables.get(clazz);
        if (aType instanceof EmbeddableType) {
            return aType;
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_class_incorrect_type_instance", (Object[])new Object[]{clazz, "EmbeddableType", aType}));
    }

    public <X> EntityType<X> entity(Class<X> clazz) {
        EntityTypeImpl<?> aType = this.entities.get(clazz);
        if (aType instanceof EntityType) {
            return aType;
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_class_incorrect_type_instance", (Object[])new Object[]{clazz, "EntityType", aType}));
    }

    public List<Attribute> getAllManagedTypeAttributes() {
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        for (ManagedTypeImpl<?> managedType : this.managedTypes.values()) {
            attributeList.addAll(managedType.getAttributes());
        }
        return attributeList;
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return new LinkedHashSet(this.embeddables.values());
    }

    public Set<EntityType<?>> getEntities() {
        return new LinkedHashSet(this.entities.values());
    }

    public Set<ManagedType<?>> getManagedTypes() {
        return new LinkedHashSet(this.managedTypes.values());
    }

    public Set<MappedSuperclassTypeImpl<?>> getMappedSuperclasses() {
        return new LinkedHashSet(this.mappedSuperclasses);
    }

    public DatabaseSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> TypeImpl<X> getType(Class<X> javaClass) {
        TypeImpl<?> type = this.types.get(javaClass);
        if (null == type) {
            Map<Class, TypeImpl<?>> map = this.types;
            synchronized (map) {
                type = this.types.get(javaClass);
                if (null == type) {
                    type = new BasicTypeImpl(javaClass);
                    this.types.put(javaClass, type);
                }
            }
        }
        return type;
    }

    public Map<Class, TypeImpl<?>> getTypes() {
        return this.types;
    }

    public boolean hasMappedSuperclass(String qualifiedClassNameKeyString) {
        Set keySet = this.getSession().getProject().getMappedSuperclassDescriptors().keySet();
        for (Object key : keySet) {
            if (!((MetadataClass)key).getName().equals(qualifiedClassNameKeyString)) continue;
            return true;
        }
        return false;
    }

    private void initialize() {
        this.types = new LinkedHashMap();
        this.entities = new LinkedHashMap();
        this.embeddables = new LinkedHashMap();
        this.managedTypes = new LinkedHashMap();
        this.mappedSuperclasses = new LinkedHashSet();
        for (Object v : this.getSession().getDescriptors().values()) {
            ManagedTypeImpl<?> managedType = ManagedTypeImpl.create(this, (RelationalDescriptor)v);
            this.types.put(managedType.getJavaType(), managedType);
            this.managedTypes.put(managedType.getJavaType(), managedType);
            if (managedType.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
                this.entities.put(managedType.getJavaType(), (EntityTypeImpl)managedType);
            }
            if (!managedType.getPersistenceType().equals((Object)Type.PersistenceType.EMBEDDABLE)) continue;
            this.embeddables.put(managedType.getJavaType(), (EmbeddableTypeImpl)managedType);
        }
        for (RelationalDescriptor relationalDescriptor : this.getSession().getProject().getMappedSuperclassDescriptors().values()) {
            MappedSuperclassTypeImpl mappedSuperclassType = (MappedSuperclassTypeImpl)ManagedTypeImpl.create(this, relationalDescriptor);
            this.mappedSuperclasses.add(mappedSuperclassType);
            this.types.put(mappedSuperclassType.getJavaType(), mappedSuperclassType);
            this.managedTypes.put(mappedSuperclassType.getJavaType(), mappedSuperclassType);
        }
        for (ManagedTypeImpl managedTypeImpl : this.managedTypes.values()) {
            Class aClass = managedTypeImpl.getJavaType();
            Class superclass = aClass.getSuperclass();
            IdentifiableType identifiableTypeSuperclass = null;
            if (!managedTypeImpl.isIdentifiableType() || superclass == ClassConstants.OBJECT) continue;
            identifiableTypeSuperclass = (IdentifiableType)this.managedTypes.get(superclass);
            ((IdentifiableTypeImpl)managedTypeImpl).setSupertype(identifiableTypeSuperclass);
            if (null != identifiableTypeSuperclass && ((IdentifiableTypeImpl)identifiableTypeSuperclass).isMappedSuperclass()) {
                ((MappedSuperclassTypeImpl)identifiableTypeSuperclass).addInheritingType((IdentifiableTypeImpl)managedTypeImpl);
            }
            ((IdentifiableTypeImpl)managedTypeImpl).setSupertype(identifiableTypeSuperclass);
        }
        for (ManagedTypeImpl managedTypeImpl : new ArrayList(this.managedTypes.values())) {
            managedTypeImpl.initialize();
        }
    }

    public <X> ManagedType<X> type(Class<X> clazz) {
        ManagedTypeImpl<?> aType = this.managedTypes.get(clazz);
        if (null == aType) {
            return null;
        }
        if (aType instanceof ManagedType) {
            return aType;
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_class_incorrect_type_instance", (Object[])new Object[]{clazz, "ManagedType", aType}));
    }

    public String toString() {
        StringBuffer aBuffer = new StringBuffer();
        aBuffer.append(this.getClass().getSimpleName());
        aBuffer.append("@");
        aBuffer.append(this.hashCode());
        aBuffer.append(" [");
        if (null != this.types) {
            aBuffer.append(" ");
            aBuffer.append(this.types.size());
            aBuffer.append(" Types: ");
        } else {
            aBuffer.append(" Types unitialized");
        }
        if (null != this.managedTypes) {
            aBuffer.append(", ");
            aBuffer.append(this.managedTypes.size());
            aBuffer.append(" ManagedTypes: ");
        } else {
            aBuffer.append(", ManagedTypes unitialized");
        }
        if (null != this.entities) {
            aBuffer.append(", ");
            aBuffer.append(this.entities.size());
            aBuffer.append(" EntityTypes: ");
        } else {
            aBuffer.append(", EntityTypes unitialized");
        }
        if (null != this.mappedSuperclasses) {
            aBuffer.append(", ");
            aBuffer.append(this.mappedSuperclasses.size());
            aBuffer.append(" MappedSuperclassTypes: ");
        } else {
            aBuffer.append(", MappedSuperclassTypes unitialized");
        }
        if (null != this.embeddables) {
            aBuffer.append(", ");
            aBuffer.append(this.embeddables.size());
            aBuffer.append(" EmbeddableTypes: ");
        } else {
            aBuffer.append(", EmbeddableTypes unitialized");
        }
        aBuffer.append("]");
        return aBuffer.toString();
    }
}

