/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Tuple;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.QueryBuilder;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.FunctionExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.OrderImpl;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.PredicateImpl;
import org.eclipse.persistence.internal.jpa.querydef.SubQueryImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilderImpl
implements QueryBuilder {
    protected Metamodel metamodel;

    public QueryBuilderImpl(Metamodel metamodel) {
        this.metamodel = metamodel;
    }

    public CriteriaQuery<Object> createQuery() {
        return new CriteriaQueryImpl<Object>(this.metamodel, AbstractQueryImpl.ResultType.OTHER, ClassConstants.OBJECT, this);
    }

    public <T> CriteriaQuery<T> createQuery(Class<T> resultClass) {
        if (resultClass.equals(Tuple.class)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.TUPLE, resultClass, this);
        }
        if (resultClass.equals(ClassConstants.AOBJECT)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OBJECT_ARRAY, resultClass, this);
        }
        if (resultClass.isArray()) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OBJECT_ARRAY, resultClass, this);
        }
        ManagedType type = this.metamodel.type(resultClass);
        if (type != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.ENTITY, resultClass, this);
        }
        return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OTHER, resultClass, this);
    }

    public CriteriaQuery<Tuple> createTupleQuery() {
        return new CriteriaQueryImpl<Tuple>(this.metamodel, AbstractQueryImpl.ResultType.TUPLE, Tuple.class, this);
    }

    public <Y> CompoundSelection<Y> construct(Class<Y> result, Selection<?> ... selections) {
        return new CompoundSelectionImpl(result, selections);
    }

    public CompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        return this.construct(Tuple.class, selections);
    }

    public CompoundSelection<Object[]> array(Selection<?> ... selections) {
        return this.construct(ClassConstants.AOBJECT, selections);
    }

    public Order asc(javax.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new OrderImpl(x);
    }

    public Order desc(javax.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        OrderImpl order = new OrderImpl(x, false);
        return order;
    }

    public <N extends Number> javax.persistence.criteria.Expression<Double> avg(javax.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ((InternalSelection)x).getCurrentNode().average(), this.buildList(x), "AVG");
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> sum(javax.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)x).getCurrentNode().sum(), this.buildList(x), "SUM");
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> max(javax.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)x).getCurrentNode().maximum(), this.buildList(x), "MAX");
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> min(javax.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)x).getCurrentNode().minimum(), this.buildList(x), "MIN");
    }

    public <X extends Comparable<X>> javax.persistence.criteria.Expression<X> greatest(javax.persistence.criteria.Expression<X> x) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new ExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)x).getCurrentNode().maximum());
    }

    public <X extends Comparable<X>> javax.persistence.criteria.Expression<X> least(javax.persistence.criteria.Expression<X> x) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new ExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)x).getCurrentNode().minimum());
    }

    public javax.persistence.criteria.Expression<Long> count(javax.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)x).getCurrentNode().count(), this.buildList(x), "COUNT");
    }

    public javax.persistence.criteria.Expression<Long> countDistinct(javax.persistence.criteria.Expression<?> x) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)x).getCurrentNode().distinct().count(), this.buildList(x), "COUNT");
    }

    public Predicate exists(Subquery<?> subquery) {
        return new CompoundExpressionImpl(this.metamodel, new ExpressionBuilder().exists(((SubQueryImpl)subquery).subQuery), this.buildList(new javax.persistence.criteria.Expression[]{subquery}), "exists");
    }

    public <Y> javax.persistence.criteria.Expression<Y> all(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().all(((InternalSelection)subquery).getCurrentNode()), this.buildList(new javax.persistence.criteria.Expression[]{subquery}), "all");
    }

    public <Y> javax.persistence.criteria.Expression<Y> some(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().some(((InternalSelection)subquery).getCurrentNode()), this.buildList(new javax.persistence.criteria.Expression[]{subquery}), "some");
    }

    public <Y> javax.persistence.criteria.Expression<Y> any(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().any(((InternalSelection)subquery).getCurrentNode()), this.buildList(new javax.persistence.criteria.Expression[]{subquery}), "any");
    }

    public Predicate and(javax.persistence.criteria.Expression<Boolean> x, javax.persistence.criteria.Expression<Boolean> y) {
        CompoundExpressionImpl xp = null;
        CompoundExpressionImpl yp = null;
        xp = ((InternalExpression)x).isExpression() ? (CompoundExpressionImpl)this.isTrue(x) : (CompoundExpressionImpl)x;
        yp = ((InternalExpression)y).isExpression() ? (CompoundExpressionImpl)this.isTrue(y) : (CompoundExpressionImpl)y;
        if (yp.isPredicate() && yp.expressions.isEmpty()) {
            if (yp.isNegated()) {
                return yp;
            }
            return xp;
        }
        if (xp.isPredicate() && xp.expressions.isEmpty()) {
            if (xp.isNegated()) {
                return xp;
            }
            return yp;
        }
        return new PredicateImpl(this.metamodel, xp.getCurrentNode().and(yp.getCurrentNode()), this.buildList(xp, yp), Predicate.BooleanOperator.AND);
    }

    public Predicate or(javax.persistence.criteria.Expression<Boolean> x, javax.persistence.criteria.Expression<Boolean> y) {
        CompoundExpressionImpl xp = null;
        CompoundExpressionImpl yp = null;
        xp = ((InternalExpression)x).isExpression() ? (CompoundExpressionImpl)this.isTrue(x) : (CompoundExpressionImpl)x;
        yp = ((InternalExpression)y).isExpression() ? (CompoundExpressionImpl)this.isTrue(y) : (CompoundExpressionImpl)y;
        if (yp.isPredicate() && yp.expressions.isEmpty() && yp.isNegated()) {
            return xp;
        }
        if (xp.isPredicate() && xp.expressions.isEmpty() && xp.isNegated()) {
            return yp;
        }
        return new PredicateImpl(this.metamodel, xp.getCurrentNode().or(yp.getCurrentNode()), this.buildList(xp, yp), Predicate.BooleanOperator.OR);
    }

    public Predicate and(Predicate ... restrictions) {
        int max = restrictions.length;
        if (max == 0) {
            return this.conjunction();
        }
        Predicate a = restrictions[0];
        for (int i = 1; i < max; ++i) {
            a = this.and((javax.persistence.criteria.Expression<Boolean>)a, (javax.persistence.criteria.Expression<Boolean>)restrictions[i]);
        }
        return a;
    }

    public Predicate or(Predicate ... restrictions) {
        int max = restrictions.length;
        if (max == 0) {
            return this.disjunction();
        }
        Predicate a = restrictions[0];
        for (int i = 1; i < max; ++i) {
            a = this.or((javax.persistence.criteria.Expression<Boolean>)a, (javax.persistence.criteria.Expression<Boolean>)restrictions[i]);
        }
        return a;
    }

    public Predicate not(javax.persistence.criteria.Expression<Boolean> restriction) {
        if (((InternalExpression)restriction).isPredicate()) {
            return ((PredicateImpl)restriction).negate();
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)restriction).getCurrentNode().not(), this.buildList(restriction), "not");
    }

    public Predicate conjunction() {
        return new PredicateImpl(this.metamodel, null, null, Predicate.BooleanOperator.AND);
    }

    public Predicate disjunction() {
        return new PredicateImpl(this.metamodel, null, null, Predicate.BooleanOperator.OR);
    }

    public Predicate isTrue(javax.persistence.criteria.Expression<Boolean> x) {
        if (((InternalExpression)x).isPredicate()) {
            if (((InternalSelection)x).getCurrentNode() == null) {
                return (Predicate)x;
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"PREDICATE_PASSED_TO_EVALUATION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().equal(true), list, "equals");
    }

    public Predicate isFalse(javax.persistence.criteria.Expression<Boolean> x) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().equal(false), this.buildList(x), "equals");
    }

    public Predicate isNull(javax.persistence.criteria.Expression<?> x) {
        return new PredicateImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().isNull(), new ArrayList(), Predicate.BooleanOperator.AND);
    }

    public Predicate isNotNull(javax.persistence.criteria.Expression<?> x) {
        return new PredicateImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().notNull(), new ArrayList(), Predicate.BooleanOperator.AND);
    }

    public Predicate equal(javax.persistence.criteria.Expression<?> x, javax.persistence.criteria.Expression<?> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().equal(((InternalSelection)y).getCurrentNode()), list, "equals");
    }

    public Predicate notEqual(javax.persistence.criteria.Expression<?> x, javax.persistence.criteria.Expression<?> y) {
        if (((InternalSelection)x).getCurrentNode() == null || ((InternalSelection)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().notEqual(((InternalSelection)y).getCurrentNode()), list, "not equal");
    }

    public Predicate equal(javax.persistence.criteria.Expression<?> x, Object y) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        if (y instanceof ParameterExpression) {
            return this.equal(x, (javax.persistence.criteria.Expression<?>)((ParameterExpression)y));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().equal(y), list, "equal");
    }

    public Predicate notEqual(javax.persistence.criteria.Expression<?> x, Object y) {
        if (((InternalSelection)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        if (y instanceof ParameterExpression) {
            return this.notEqual(x, (javax.persistence.criteria.Expression<?>)((ParameterExpression)y));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().notEqual(y), list, "not equal");
    }

    public <Y extends Comparable<Y>> Predicate greaterThan(javax.persistence.criteria.Expression<? extends Y> x, javax.persistence.criteria.Expression<? extends Y> y) {
        if (((InternalSelection)x).getCurrentNode() == null || ((InternalSelection)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().greaterThan(((InternalSelection)y).getCurrentNode()), list, "greaterThan");
    }

    public <Y extends Comparable<Y>> Predicate lessThan(javax.persistence.criteria.Expression<? extends Y> x, javax.persistence.criteria.Expression<? extends Y> y) {
        if (((InternalSelection)x).getCurrentNode() == null || ((InternalSelection)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().lessThan(((InternalSelection)y).getCurrentNode()), list, "lessThan");
    }

    public <Y extends Comparable<Y>> Predicate greaterThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> x, javax.persistence.criteria.Expression<? extends Y> y) {
        if (((ExpressionImpl)x).getCurrentNode() == null || ((ExpressionImpl)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThanEqual(((ExpressionImpl)y).getCurrentNode()), list, "greaterThanEqual");
    }

    public <Y extends Comparable<Y>> Predicate lessThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> x, javax.persistence.criteria.Expression<? extends Y> y) {
        if (((ExpressionImpl)x).getCurrentNode() == null || ((ExpressionImpl)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThanEqual(((ExpressionImpl)y).getCurrentNode()), list, "lessThanEqual");
    }

    public <Y extends Comparable<Y>> Predicate between(javax.persistence.criteria.Expression<? extends Y> v, javax.persistence.criteria.Expression<? extends Y> x, javax.persistence.criteria.Expression<? extends Y> y) {
        ArrayList list = new ArrayList();
        list.add(v);
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)v).getCurrentNode().between(((ExpressionImpl)x).getCurrentNode(), ((ExpressionImpl)y).getCurrentNode()), list, "between");
    }

    public <Y extends Comparable<Y>> Predicate greaterThan(javax.persistence.criteria.Expression<? extends Y> x, Y y) {
        javax.persistence.criteria.Expression<Y> expressionY = this.literal(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThan(((ExpressionImpl)expressionY).getCurrentNode()), list, "greaterThan");
    }

    public <Y extends Comparable<Y>> Predicate lessThan(javax.persistence.criteria.Expression<? extends Y> x, Y y) {
        javax.persistence.criteria.Expression<Y> expressionY = this.literal(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThan(((ExpressionImpl)expressionY).getCurrentNode()), list, "lessThan");
    }

    public <Y extends Comparable<Y>> Predicate greaterThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> x, Y y) {
        javax.persistence.criteria.Expression<Y> expressionY = this.literal(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThanEqual(((ExpressionImpl)expressionY).getCurrentNode()), list, "greaterThanEqual");
    }

    public <Y extends Comparable<Y>> Predicate lessThanOrEqualTo(javax.persistence.criteria.Expression<? extends Y> x, Y y) {
        javax.persistence.criteria.Expression<Y> expressionY = this.literal(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThanEqual(((ExpressionImpl)expressionY).getCurrentNode()), list, "lessThanEqual");
    }

    public <Y extends Comparable<Y>> Predicate between(javax.persistence.criteria.Expression<? extends Y> v, Y x, Y y) {
        ArrayList list = new ArrayList();
        list.add(v);
        list.add(this.literal(x));
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)v).getCurrentNode().between(x, y), list, "between");
    }

    protected List<javax.persistence.criteria.Expression<?>> buildList(javax.persistence.criteria.Expression<?> ... expressions) {
        ArrayList list = new ArrayList();
        for (javax.persistence.criteria.Expression<?> exp : expressions) {
            list.add(exp);
        }
        return list;
    }

    public Predicate gt(javax.persistence.criteria.Expression<? extends Number> x, javax.persistence.criteria.Expression<? extends Number> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().greaterThan(((InternalSelection)y).getCurrentNode()), list, "gt");
    }

    public Predicate lt(javax.persistence.criteria.Expression<? extends Number> x, javax.persistence.criteria.Expression<? extends Number> y) {
        return null;
    }

    public Predicate ge(javax.persistence.criteria.Expression<? extends Number> x, javax.persistence.criteria.Expression<? extends Number> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().greaterThanEqual(((InternalSelection)y).getCurrentNode()), list, "ge");
    }

    public Predicate le(javax.persistence.criteria.Expression<? extends Number> x, javax.persistence.criteria.Expression<? extends Number> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().lessThanEqual(((InternalSelection)y).getCurrentNode()), list, "le");
    }

    public Predicate gt(javax.persistence.criteria.Expression<? extends Number> x, Number y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().greaterThan((Object)y), list, "gt");
    }

    public Predicate lt(javax.persistence.criteria.Expression<? extends Number> x, Number y) {
        return null;
    }

    public Predicate ge(javax.persistence.criteria.Expression<? extends Number> x, Number y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)x).getCurrentNode().greaterThanEqual((Object)y), list, "ge");
    }

    public Predicate le(javax.persistence.criteria.Expression<? extends Number> x, Number y) {
        return null;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> neg(javax.persistence.criteria.Expression<N> x) {
        return null;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> abs(javax.persistence.criteria.Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.abs((Expression)((InternalSelection)x).getCurrentNode()), this.buildList(x), "ABS");
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> sum(javax.persistence.criteria.Expression<? extends N> x, javax.persistence.criteria.Expression<? extends N> y) {
        return null;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> prod(javax.persistence.criteria.Expression<? extends N> x, javax.persistence.criteria.Expression<? extends N> y) {
        return null;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> diff(javax.persistence.criteria.Expression<? extends N> x, javax.persistence.criteria.Expression<? extends N> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new FunctionExpressionImpl<String>(this.metamodel, String.class, ExpressionMath.subtract((Expression)((InternalSelection)x).getCurrentNode(), (Object)((InternalSelection)y).getCurrentNode()), list, "diff");
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> sum(javax.persistence.criteria.Expression<? extends N> x, N y) {
        return null;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> prod(javax.persistence.criteria.Expression<? extends N> x, N y) {
        return null;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> diff(javax.persistence.criteria.Expression<? extends N> x, N y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new FunctionExpressionImpl<String>(this.metamodel, String.class, ExpressionMath.subtract((Expression)((InternalSelection)x).getCurrentNode(), y), list, "diff");
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> sum(N x, javax.persistence.criteria.Expression<? extends N> y) {
        return null;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> prod(N x, javax.persistence.criteria.Expression<? extends N> y) {
        return null;
    }

    public <N extends Number> javax.persistence.criteria.Expression<N> diff(N x, javax.persistence.criteria.Expression<? extends N> y) {
        ArrayList list = new ArrayList();
        ExpressionImpl literal = (ExpressionImpl)this.literal(x);
        list.add(literal);
        list.add(y);
        return new FunctionExpressionImpl<String>(this.metamodel, String.class, ExpressionMath.subtract((Expression)((InternalSelection)((Object)x)).getCurrentNode(), (Object)((InternalSelection)y).getCurrentNode()), list, "diff");
    }

    public javax.persistence.criteria.Expression<Number> quot(javax.persistence.criteria.Expression<? extends Number> x, javax.persistence.criteria.Expression<? extends Number> y) {
        return null;
    }

    public javax.persistence.criteria.Expression<Number> quot(javax.persistence.criteria.Expression<? extends Number> x, Number y) {
        return null;
    }

    public javax.persistence.criteria.Expression<Number> quot(Number x, javax.persistence.criteria.Expression<? extends Number> y) {
        return null;
    }

    public javax.persistence.criteria.Expression<Integer> mod(javax.persistence.criteria.Expression<Integer> x, javax.persistence.criteria.Expression<Integer> y) {
        return null;
    }

    public javax.persistence.criteria.Expression<Integer> mod(javax.persistence.criteria.Expression<Integer> x, Integer y) {
        return null;
    }

    public javax.persistence.criteria.Expression<Integer> mod(Integer x, javax.persistence.criteria.Expression<Integer> y) {
        return null;
    }

    public javax.persistence.criteria.Expression<Double> sqrt(javax.persistence.criteria.Expression<? extends Number> x) {
        return null;
    }

    public javax.persistence.criteria.Expression<Long> toLong(javax.persistence.criteria.Expression<? extends Number> number) {
        return null;
    }

    public javax.persistence.criteria.Expression<Integer> toInteger(javax.persistence.criteria.Expression<? extends Number> number) {
        return null;
    }

    public javax.persistence.criteria.Expression<Float> toFloat(javax.persistence.criteria.Expression<? extends Number> number) {
        return null;
    }

    public javax.persistence.criteria.Expression<Double> toDouble(javax.persistence.criteria.Expression<? extends Number> number) {
        return null;
    }

    public javax.persistence.criteria.Expression<BigDecimal> toBigDecimal(javax.persistence.criteria.Expression<? extends Number> number) {
        return null;
    }

    public javax.persistence.criteria.Expression<BigInteger> toBigInteger(javax.persistence.criteria.Expression<? extends Number> number) {
        return null;
    }

    public javax.persistence.criteria.Expression<String> toString(javax.persistence.criteria.Expression<Character> character) {
        return null;
    }

    public <T> javax.persistence.criteria.Expression<T> literal(T value) {
        return new ExpressionImpl(this.metamodel, value.getClass(), (Expression)new ConstantExpression(value, (Expression)new ExpressionBuilder()), value);
    }

    public <T> javax.persistence.criteria.Expression<T> nullLiteral(Class<T> resultClass) {
        return null;
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass) {
        return new ParameterExpressionImpl<T>(this.metamodel, paramClass);
    }

    public <T> ParameterExpression<T> parameter(Class<T> paramClass, String name) {
        return new ParameterExpressionImpl<T>(this.metamodel, paramClass, name);
    }

    public <C extends Collection<?>> Predicate isEmpty(javax.persistence.criteria.Expression<C> collection) {
        if (((InternalExpression)collection).isLiteral()) {
            if (((Collection)((ConstantExpression)((InternalSelection)collection).getCurrentNode()).getValue()).isEmpty()) {
                return this.conjunction();
            }
            return this.disjunction();
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)collection).getCurrentNode().size(ClassConstants.INTEGER).equal(0), this.buildList(collection), "isEmpty");
    }

    public <C extends Collection<?>> Predicate isNotEmpty(javax.persistence.criteria.Expression<C> collection) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)collection).getCurrentNode().size(ClassConstants.INTEGER).equal(0).not(), this.buildList(collection), "isNotEmpty");
    }

    public <C extends Collection<?>> javax.persistence.criteria.Expression<Integer> size(C collection) {
        return this.literal(collection.size());
    }

    public <C extends Collection<?>> javax.persistence.criteria.Expression<Integer> size(javax.persistence.criteria.Expression<C> collection) {
        return null;
    }

    public <E, C extends Collection<E>> Predicate isMember(E elem, javax.persistence.criteria.Expression<C> collection) {
        return null;
    }

    public <E, C extends Collection<E>> Predicate isNotMember(E elem, javax.persistence.criteria.Expression<C> collection) {
        return null;
    }

    public <E, C extends Collection<E>> Predicate isMember(javax.persistence.criteria.Expression<E> elem, javax.persistence.criteria.Expression<C> collection) {
        return null;
    }

    public <E, C extends Collection<E>> Predicate isNotMember(javax.persistence.criteria.Expression<E> elem, javax.persistence.criteria.Expression<C> collection) {
        return null;
    }

    public <V, M extends Map<?, V>> javax.persistence.criteria.Expression<Collection<V>> values(M map) {
        return null;
    }

    public <K, M extends Map<K, ?>> javax.persistence.criteria.Expression<Set<K>> keys(M map) {
        return null;
    }

    public Predicate like(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern) {
        return null;
    }

    public Predicate like(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern, javax.persistence.criteria.Expression<Character> escapeChar) {
        return null;
    }

    public Predicate like(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern, char escapeChar) {
        return null;
    }

    public Predicate like(javax.persistence.criteria.Expression<String> x, String pattern) {
        return null;
    }

    public Predicate like(javax.persistence.criteria.Expression<String> x, String pattern, javax.persistence.criteria.Expression<Character> escapeChar) {
        return null;
    }

    public Predicate like(javax.persistence.criteria.Expression<String> x, String pattern, char escapeChar) {
        return null;
    }

    public Predicate notLike(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern) {
        return null;
    }

    public Predicate notLike(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern, javax.persistence.criteria.Expression<Character> escapeChar) {
        return null;
    }

    public Predicate notLike(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern, char escapeChar) {
        return null;
    }

    public Predicate notLike(javax.persistence.criteria.Expression<String> x, String pattern) {
        return null;
    }

    public Predicate notLike(javax.persistence.criteria.Expression<String> x, String pattern, javax.persistence.criteria.Expression<Character> escapeChar) {
        return null;
    }

    public Predicate notLike(javax.persistence.criteria.Expression<String> x, String pattern, char escapeChar) {
        return null;
    }

    public javax.persistence.criteria.Expression<String> concat(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new FunctionExpressionImpl<String>(this.metamodel, String.class, ((InternalSelection)x).getCurrentNode().concat((Object)((InternalSelection)y).getCurrentNode()), list, "concat");
    }

    public javax.persistence.criteria.Expression<String> concat(javax.persistence.criteria.Expression<String> x, String y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(this.literal(y));
        return new FunctionExpressionImpl<String>(this.metamodel, String.class, ((InternalSelection)x).getCurrentNode().concat((Object)y), list, "concat");
    }

    public javax.persistence.criteria.Expression<String> concat(String x, javax.persistence.criteria.Expression<String> y) {
        ArrayList list = new ArrayList();
        ExpressionImpl literal = (ExpressionImpl)this.literal(x);
        list.add(literal);
        list.add(y);
        return new FunctionExpressionImpl<String>(this.metamodel, String.class, literal.getCurrentNode().concat((Object)((InternalSelection)y).getCurrentNode()), list, "concat");
    }

    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<Integer> from) {
        return null;
    }

    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> x, int from) {
        return null;
    }

    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<Integer> from, javax.persistence.criteria.Expression<Integer> len) {
        return null;
    }

    public javax.persistence.criteria.Expression<String> substring(javax.persistence.criteria.Expression<String> x, int from, int len) {
        return null;
    }

    public javax.persistence.criteria.Expression<String> trim(javax.persistence.criteria.Expression<String> x) {
        return null;
    }

    public javax.persistence.criteria.Expression<String> trim(QueryBuilder.Trimspec ts, javax.persistence.criteria.Expression<String> x) {
        return null;
    }

    public javax.persistence.criteria.Expression<String> trim(javax.persistence.criteria.Expression<Character> t, javax.persistence.criteria.Expression<String> x) {
        return null;
    }

    public javax.persistence.criteria.Expression<String> trim(QueryBuilder.Trimspec ts, javax.persistence.criteria.Expression<Character> t, javax.persistence.criteria.Expression<String> x) {
        return null;
    }

    public javax.persistence.criteria.Expression<String> trim(char t, javax.persistence.criteria.Expression<String> x) {
        return null;
    }

    public javax.persistence.criteria.Expression<String> trim(QueryBuilder.Trimspec ts, char t, javax.persistence.criteria.Expression<String> x) {
        return null;
    }

    public javax.persistence.criteria.Expression<String> lower(javax.persistence.criteria.Expression<String> x) {
        return null;
    }

    public javax.persistence.criteria.Expression<String> upper(javax.persistence.criteria.Expression<String> x) {
        return null;
    }

    public javax.persistence.criteria.Expression<Integer> length(javax.persistence.criteria.Expression<String> x) {
        return null;
    }

    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern) {
        return null;
    }

    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern, javax.persistence.criteria.Expression<Integer> from) {
        return null;
    }

    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> x, String pattern) {
        return null;
    }

    public javax.persistence.criteria.Expression<Integer> locate(javax.persistence.criteria.Expression<String> x, String pattern, int from) {
        return null;
    }

    public javax.persistence.criteria.Expression<Date> currentDate() {
        return new ExpressionImpl<Date>(this.metamodel, ClassConstants.SQLDATE, new ExpressionBuilder().currentDate());
    }

    public javax.persistence.criteria.Expression<Timestamp> currentTimestamp() {
        return new ExpressionImpl<Timestamp>(this.metamodel, ClassConstants.TIMESTAMP, new ExpressionBuilder().currentTimeStamp());
    }

    public javax.persistence.criteria.Expression<Time> currentTime() {
        return new ExpressionImpl<Time>(this.metamodel, ClassConstants.TIME, new ExpressionBuilder().currentTime());
    }

    public <T> QueryBuilder.In<T> in(javax.persistence.criteria.Expression<? extends T> expression) {
        return null;
    }

    public <Y> javax.persistence.criteria.Expression<Y> coalesce(javax.persistence.criteria.Expression<? extends Y> x, javax.persistence.criteria.Expression<? extends Y> y) {
        return null;
    }

    public <Y> javax.persistence.criteria.Expression<Y> coalesce(javax.persistence.criteria.Expression<? extends Y> x, Y y) {
        return null;
    }

    public <Y> javax.persistence.criteria.Expression<Y> nullif(javax.persistence.criteria.Expression<Y> x, javax.persistence.criteria.Expression<?> y) {
        return null;
    }

    public <Y> javax.persistence.criteria.Expression<Y> nullif(javax.persistence.criteria.Expression<Y> x, Y y) {
        return null;
    }

    public <T> QueryBuilder.Coalesce<T> coalesce() {
        return null;
    }

    public <C, R> QueryBuilder.SimpleCase<C, R> selectCase(javax.persistence.criteria.Expression<? extends C> expression) {
        return null;
    }

    public <R> QueryBuilder.Case<R> selectCase() {
        return null;
    }

    public <T> javax.persistence.criteria.Expression<T> function(String name, Class<T> type, javax.persistence.criteria.Expression<?> ... args) {
        if (args != null && args.length > 0) {
            Vector<Expression> params = new Vector<Expression>();
            for (int index = 1; index < args.length; ++index) {
                params.add(((InternalSelection)args[index]).getCurrentNode());
            }
            return new FunctionExpressionImpl<T>(this.metamodel, type, ((InternalSelection)args[0]).getCurrentNode().getFunctionWithArguments(name, params), this.buildList(args), name);
        }
        return new FunctionExpressionImpl<T>(this.metamodel, type, new ExpressionBuilder().getFunction(name), new ArrayList(0), name);
    }
}

