/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.iiop.AlternateIIOPAddressComponent;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.transport.IORToSocketInfo;
import com.sun.corba.ee.spi.transport.SocketInfo;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;

public class IORToSocketInfoImpl
implements IORToSocketInfo {
    private static Logger _logger = null;
    private final String baseMsg = IORToSocketInfoImpl.class.getName();
    private Map primaryToAddresses = new HashMap();
    private Map primaryToRandomizedAddresses = new HashMap();
    private SecurityMechanismSelector selector;

    public IORToSocketInfoImpl() {
        Habitat habitat = SecurityServicesUtil.getInstance().getHabitat();
        this.selector = habitat.getComponent(SecurityMechanismSelector.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public List getSocketInfo(IOR ior, List previous) {
        List existing;
        SocketInfo primarySocketInfo;
        List<SocketInfo> result;
        block26: {
            block25: {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo->:");
                }
                result = new ArrayList<SocketInfo>();
                IIOPProfileTemplate iiopProfileTemplate = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
                IIOPAddress primary = iiopProfileTemplate.getPrimaryAddress();
                String host = primary.getHost().toLowerCase();
                String type = null;
                int port = 0;
                ConnectionContext ctx = new ConnectionContext();
                SocketInfo socketInfo = this.selector.getSSLPort(ior, ctx);
                this.selector.setClientConnectionContext(ctx);
                if (socketInfo == null) {
                    type = "IIOP_CLEAR_TEXT";
                    port = primary.getPort();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo: did not find SSL SocketInfo");
                    }
                } else {
                    type = socketInfo.getType();
                    port = socketInfo.getPort();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo: found SSL socketInfo");
                    }
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo: Connection Context:" + ctx);
                    _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo: ENDPOINT INFO:type=" + type + ",host=" + host + ", port=" + port);
                }
                if (socketInfo != null) {
                    result.add(socketInfo);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo: returning SSL socketInfo:" + " " + socketInfo.getType() + " " + socketInfo.getHost() + " " + socketInfo.getPort());
                    }
                    ArrayList<SocketInfo> arrayList = result;
                    if (!_logger.isLoggable(Level.FINE)) return arrayList;
                    _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo<-:");
                    return arrayList;
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo: returning non SSL socketInfo");
                }
                if (!previous.isEmpty()) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo: returning previous socketInfo: " + previous);
                    }
                    List list = previous;
                    if (!_logger.isLoggable(Level.FINE)) return list;
                    _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo<-:");
                    return list;
                }
                primarySocketInfo = IORToSocketInfoImpl.createSocketInfo("primary", type, host, port);
                result.add(primarySocketInfo);
                Iterator iterator = iiopProfileTemplate.iteratorById(3);
                while (iterator.hasNext()) {
                    AlternateIIOPAddressComponent alternate = (AlternateIIOPAddressComponent)iterator.next();
                    host = alternate.getAddress().getHost().toLowerCase();
                    port = alternate.getAddress().getPort();
                    result.add(IORToSocketInfoImpl.createSocketInfo("AlternateIIOPAddressComponent", "IIOP_CLEAR_TEXT", host, port));
                }
                IORToSocketInfoImpl iORToSocketInfoImpl = this;
                // MONITORENTER : iORToSocketInfoImpl
                existing = (List)this.primaryToAddresses.get(primarySocketInfo);
                if (existing != null) break block25;
                this.primaryToAddresses.put(primarySocketInfo, result);
                result.remove(0);
                Collections.shuffle(result);
                result.add(0, primarySocketInfo);
                this.primaryToRandomizedAddresses.put(primarySocketInfo, result);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo: initial randomized result: " + result);
                }
                List<SocketInfo> list = result;
                // MONITOREXIT : iORToSocketInfoImpl
                if (!_logger.isLoggable(Level.FINE)) return list;
                _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo<-:");
                return list;
            }
            if (!((Object)result).equals(existing)) break block26;
            result = (List)this.primaryToRandomizedAddresses.get(primarySocketInfo);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo: existing randomized result: " + result);
            }
            List<SocketInfo> list = result;
            // MONITOREXIT : iORToSocketInfoImpl
            if (!_logger.isLoggable(Level.FINE)) return list;
            _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo<-:");
            return list;
            {
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "Exception getting SocketInfo", ex);
                    RuntimeException rte = new RuntimeException(ex.getMessage());
                    rte.initCause(ex);
                    throw rte;
                }
            }
        }
        _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo:" + " Address lists do not match: primary: " + primarySocketInfo + "; returning current: " + result + "; existing is: " + existing);
        List<SocketInfo> list = result;
        // MONITOREXIT : iORToSocketInfoImpl
        if (!_logger.isLoggable(Level.FINE)) return list;
        _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo<-:");
        return list;
        catch (Throwable throwable) {
            if (!_logger.isLoggable(Level.FINE)) throw throwable;
            _logger.log(Level.FINE, this.baseMsg + ".getSocketInfo<-:");
            throw throwable;
        }
    }

    public static SocketInfo createSocketInfo(String msg, final String type, final String host, final int port) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Address from: " + msg + "; type/address/port: " + type + "/" + host + "/" + port);
        }
        return new SocketInfo(){

            public String getType() {
                return type;
            }

            public String getHost() {
                return host;
            }

            public int getPort() {
                return port;
            }

            public boolean equals(Object o) {
                if (o == null) {
                    return false;
                }
                if (!(o instanceof SocketInfo)) {
                    return false;
                }
                SocketInfo other = (SocketInfo)o;
                if (other.getPort() != port) {
                    return false;
                }
                if (!other.getHost().equals(host)) {
                    return false;
                }
                return other.getType().equals(type);
            }

            public int hashCode() {
                return type.hashCode() ^ host.hashCode() ^ port;
            }

            public String toString() {
                return "SocketInfo[" + type + " " + host + " " + port + "]";
            }
        };
    }

    static {
        _logger = LogDomains.getLogger(IORToSocketInfoImpl.class, (String)"javax.enterprise.resource.corba");
    }
}

