/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.bean.AbstractClassBean;
import org.jboss.webbeans.bean.DecoratorImpl;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.injection.ConstructorInjectionPoint;
import org.jboss.webbeans.injection.InjectionContextImpl;
import org.jboss.webbeans.injection.WBInjectionPoint;
import org.jboss.webbeans.introspector.WBClass;
import org.jboss.webbeans.introspector.WBConstructor;
import org.jboss.webbeans.introspector.WBField;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.metadata.cache.MetaAnnotationStore;
import org.jboss.webbeans.util.Beans;
import org.jboss.webbeans.util.Names;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBean<T>
extends AbstractClassBean<T> {
    private static LogProvider log = Logging.getLogProvider(ManagedBean.class);
    private ConstructorInjectionPoint<T> constructor;
    private Set<WBInjectionPoint<?, ?>> ejbInjectionPoints;
    private Set<WBInjectionPoint<?, ?>> persistenceContextInjectionPoints;
    private Set<WBInjectionPoint<?, ?>> persistenceUnitInjectionPoints;
    private Set<WBInjectionPoint<?, ?>> resourceInjectionPoints;
    private ManagedBean<?> specializedBean;

    public static <T> ManagedBean<T> of(WBClass<T> clazz, BeanManagerImpl manager) {
        return new ManagedBean<T>(clazz, manager);
    }

    protected ManagedBean(WBClass<T> type, BeanManagerImpl manager) {
        super(type, manager);
        this.initType();
        this.initTypes();
        this.initBindings();
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        InjectionPoint originalInjectionPoint = null;
        if (this.hasDecorators()) {
            originalInjectionPoint = this.attachCorrectInjectionPoint();
        }
        T instance = this.produce(creationalContext);
        this.inject(instance, creationalContext);
        this.postConstruct(instance);
        if (this.hasDecorators()) {
            instance = this.applyDecorators(instance, creationalContext, originalInjectionPoint);
        }
        return instance;
    }

    @Override
    public T produce(CreationalContext<T> ctx) {
        T instance = this.constructor.newInstance(this.manager, ctx);
        if (!this.hasDecorators()) {
            ctx.push(instance);
        }
        return instance;
    }

    @Override
    public void inject(final T instance, final CreationalContext<T> ctx) {
        new InjectionContextImpl<T>(this.getManager(), this, instance){

            @Override
            public void proceed() {
                Beans.injectEEFields(instance, ManagedBean.this.getManager(), ManagedBean.this.ejbInjectionPoints, ManagedBean.this.persistenceContextInjectionPoints, ManagedBean.this.persistenceUnitInjectionPoints, ManagedBean.this.resourceInjectionPoints);
                Beans.injectBoundFields(instance, ctx, ManagedBean.this.getManager(), ManagedBean.this.getInjectableFields());
                Beans.callInitializers(instance, ctx, ManagedBean.this.getManager(), ManagedBean.this.getInitializerMethods());
            }
        }.run();
    }

    protected InjectionPoint attachCorrectInjectionPoint() {
        Decorator<?> decorator = this.getDecorators().get(this.getDecorators().size() - 1);
        if (decorator instanceof DecoratorImpl) {
            DecoratorImpl decoratorBean = (DecoratorImpl)decorator;
            WBInjectionPoint<?, ?> outerDelegateInjectionPoint = decoratorBean.getDelegateInjectionPoint();
            return this.getManager().replaceOrPushCurrentInjectionPoint(outerDelegateInjectionPoint);
        }
        throw new IllegalStateException("Cannot operate on user defined decorator");
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            this.preDestroy(instance);
            creationalContext.release();
        }
        catch (Exception e) {
            log.error("Error destroying " + this.toString(), e);
        }
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            this.initConstructor();
            this.checkConstructor();
            super.initialize(environment);
            this.initPostConstruct();
            this.initPreDestroy();
            this.initEEInjectionPoints();
        }
    }

    private void initEEInjectionPoints() {
        this.ejbInjectionPoints = Beans.getEjbInjectionPoints(this, this.getAnnotatedItem(), this.getManager());
        this.persistenceContextInjectionPoints = Beans.getPersistenceContextInjectionPoints(this, this.getAnnotatedItem(), this.getManager());
        this.persistenceUnitInjectionPoints = Beans.getPersistenceUnitInjectionPoints(this, this.getAnnotatedItem(), this.getManager());
        this.resourceInjectionPoints = Beans.getResourceInjectionPoints(this, this.getAnnotatedItem(), this.manager);
    }

    @Override
    protected void checkType() {
        if (this.getAnnotatedItem().isNonStaticMemberClass()) {
            throw new DefinitionException("Simple bean " + this.type + " cannot be a non-static inner class");
        }
        if (!this.isDependent() && this.getAnnotatedItem().isParameterizedType()) {
            throw new DefinitionException("Managed bean " + this.type + " must be @Dependent");
        }
        boolean passivating = this.manager.getServices().get(MetaAnnotationStore.class).getScopeModel(this.scopeType).isPassivating();
        if (passivating && !Reflections.isSerializable(this.getBeanClass())) {
            throw new DefinitionException("Simple bean declaring a passivating scope must have a serializable implementation class " + this.toString());
        }
        if (this.hasDecorators()) {
            if (this.getAnnotatedItem().isFinal()) {
                throw new DefinitionException("Bean class which has decorators cannot be declared final " + this);
            }
            for (Decorator<?> decorator : this.getDecorators()) {
                if (decorator instanceof DecoratorImpl) {
                    DecoratorImpl decoratorBean = (DecoratorImpl)decorator;
                    for (WBMethod<?, ?> decoratorMethod : decoratorBean.getAnnotatedItem().getWBMethods()) {
                        WBMethod method = this.getAnnotatedItem().getWBMethod(decoratorMethod.getSignature());
                        if (method == null || method.isStatic() || method.isPrivate() || !method.isFinal()) continue;
                        throw new DefinitionException("Decorated bean method " + method + " (decorated by " + decoratorMethod + ") cannot be declarted final");
                    }
                    continue;
                }
                throw new IllegalStateException("Can only operate on container provided decorators " + decorator);
            }
        }
    }

    @Override
    protected void checkBeanImplementation() {
        super.checkBeanImplementation();
        if (!this.isDependent()) {
            for (WBField<?, ?> field : this.getAnnotatedItem().getWBFields()) {
                if (!field.isPublic() || field.isStatic()) continue;
                throw new DefinitionException("Normal scoped Web Bean implementation class has a public field " + this.getAnnotatedItem());
            }
        }
    }

    protected void checkConstructor() {
        if (!this.constructor.getAnnotatedWBParameters(Disposes.class).isEmpty()) {
            throw new DefinitionException("Managed bean constructor must not have a parameter annotated @Disposes " + this.constructor);
        }
        if (!this.constructor.getAnnotatedWBParameters(Observes.class).isEmpty()) {
            throw new DefinitionException("Managed bean constructor must not have a parameter annotated @Observes " + this.constructor);
        }
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (environment.getEjbDescriptors().contains(this.getAnnotatedItem().getWBSuperclass().getJavaClass())) {
            throw new DefinitionException("Simple bean must specialize a simple bean");
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        if (environment.getClassBean(this.getAnnotatedItem().getWBSuperclass()) == null) {
            throw new DefinitionException(this.toString() + " does not specialize a bean");
        }
        AbstractClassBean<?> specializedBean = environment.getClassBean(this.getAnnotatedItem().getWBSuperclass());
        if (!(specializedBean instanceof ManagedBean)) {
            throw new DefinitionException(this.toString() + " doesn't have a simple bean as a superclass " + specializedBean);
        }
        this.specializedBean = (ManagedBean)specializedBean;
    }

    protected void initConstructor() {
        this.constructor = Beans.getBeanConstructor(this, this.getAnnotatedItem());
        this.addInjectionPoints(Beans.getParameterInjectionPoints(this, this.constructor));
    }

    public WBConstructor<T> getConstructor() {
        return this.constructor;
    }

    @Override
    public String toString() {
        return this.toString("simple bean");
    }

    protected String toString(String beanType) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Names.scopeTypeToString(this.getScope()));
        if (this.getName() == null) {
            buffer.append("unnamed ").append(beanType);
        } else {
            buffer.append(beanType).append(" '" + this.getName() + "'");
        }
        buffer.append(" ").append(this.getType().getName()).append(", ");
        buffer.append(" API types = ").append(Names.typesToString(this.getTypes())).append(", binding types = " + Names.annotationsToString(this.getQualifiers()));
        return buffer.toString();
    }

    @Override
    public ManagedBean<?> getSpecializedBean() {
        return this.specializedBean;
    }
}

