/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.decorator.Decorates;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import org.jboss.webbeans.BeanManagerImpl;
import org.jboss.webbeans.injection.Exceptions;
import org.jboss.webbeans.injection.ParameterInjectionPoint;
import org.jboss.webbeans.injection.WBInjectionPoint;
import org.jboss.webbeans.introspector.ForwardingWBMethod;
import org.jboss.webbeans.introspector.WBMethod;
import org.jboss.webbeans.introspector.WBParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInjectionPoint<T, X>
extends ForwardingWBMethod<T, X>
implements WBInjectionPoint<T, Method> {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final Bean<?> declaringBean;
    private final WBMethod<T, X> method;
    private final boolean delegate;

    public static <T, X> MethodInjectionPoint<T, X> of(Bean<?> declaringBean, WBMethod<T, X> method) {
        return new MethodInjectionPoint<T, X>(declaringBean, method);
    }

    protected MethodInjectionPoint(Bean<?> declaringBean, WBMethod<T, X> method) {
        this.declaringBean = declaringBean;
        this.method = method;
        this.delegate = this.isAnnotationPresent(Decorates.class) && declaringBean instanceof Decorator;
    }

    @Override
    protected WBMethod<T, X> delegate() {
        return this.method;
    }

    @Override
    public Bean<?> getBean() {
        return this.declaringBean;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.delegate().getQualifiers();
    }

    public T invoke(Object declaringInstance, BeanManagerImpl manager, CreationalContext<?> creationalContext, Class<? extends RuntimeException> exceptionTypeToThrow) {
        try {
            return this.delegate().invoke(declaringInstance, this.getParameterValues(this.getWBParameters(), null, null, manager, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        return null;
    }

    public T invokeWithSpecialValue(Object declaringInstance, Class<? extends Annotation> annotatedParameter, Object parameter, BeanManagerImpl manager, CreationalContext<?> creationalContext, Class<? extends RuntimeException> exceptionTypeToThrow) {
        try {
            return this.invoke(declaringInstance, this.getParameterValues(this.getWBParameters(), annotatedParameter, parameter, manager, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        return null;
    }

    public T invokeOnInstance(Object declaringInstance, BeanManagerImpl manager, CreationalContext<?> creationalContext, Class<? extends RuntimeException> exceptionTypeToThrow) {
        try {
            return this.delegate().invokeOnInstance(declaringInstance, this.getParameterValues(this.getWBParameters(), null, null, manager, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e);
        }
        catch (SecurityException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (NoSuchMethodException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        return null;
    }

    public T invokeOnInstanceWithSpecialValue(Object declaringInstance, Class<? extends Annotation> annotatedParameter, Object parameter, BeanManagerImpl manager, CreationalContext<?> creationalContext, Class<? extends RuntimeException> exceptionTypeToThrow) {
        try {
            return this.invokeOnInstance(declaringInstance, this.getParameterValues(this.getWBParameters(), annotatedParameter, parameter, manager, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (SecurityException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        catch (NoSuchMethodException e) {
            Exceptions.rethrowException(e, exceptionTypeToThrow);
        }
        return null;
    }

    @Override
    public List<ParameterInjectionPoint<?, ?>> getWBParameters() {
        final List<WBParameter<?, ?>> delegate = super.getWBParameters();
        return new ForwardingParameterInjectionPointList(){

            @Override
            protected Bean<?> declaringBean() {
                return MethodInjectionPoint.this.declaringBean;
            }

            @Override
            protected List<? extends WBParameter<?, ?>> delegate() {
                return delegate;
            }
        };
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        try {
            this.delegate().invoke(declaringInstance, value);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e);
        }
    }

    protected Object[] getParameterValues(List<ParameterInjectionPoint<?, ?>> parameters, Class<? extends Annotation> specialParam, Object specialVal, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
        Object[] parameterValues = new Object[parameters.size()];
        Iterator<ParameterInjectionPoint<?, ?>> iterator = parameters.iterator();
        for (int i = 0; i < parameterValues.length; ++i) {
            ParameterInjectionPoint<?, ?> param = iterator.next();
            parameterValues[i] = specialParam != null && param.isAnnotationPresent(specialParam) ? specialVal : param.getValueToInject(manager, creationalContext);
        }
        return parameterValues;
    }

    @Override
    public Annotated getAnnotated() {
        return this.delegate();
    }

    @Override
    public boolean isDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public Type getType() {
        return this.getBaseType();
    }

    @Override
    public Member getMember() {
        return this.getJavaMember();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ForwardingParameterInjectionPointList
    extends AbstractList<ParameterInjectionPoint<?, ?>> {
        private ForwardingParameterInjectionPointList() {
        }

        protected abstract List<? extends WBParameter<?, ?>> delegate();

        protected abstract Bean<?> declaringBean();

        @Override
        public ParameterInjectionPoint<?, ?> get(int index) {
            return ParameterInjectionPoint.of(MethodInjectionPoint.this.declaringBean, this.delegate().get(index));
        }

        @Override
        public int size() {
            return this.delegate().size();
        }
    }
}

