/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.metadata.cache;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;
import org.jboss.webbeans.DefinitionException;
import org.jboss.webbeans.introspector.WBAnnotation;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.resources.ClassTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationModel<T extends Annotation> {
    private static final Log log = Logging.getLog(AnnotationModel.class);
    private WBAnnotation<T> annotatedAnnotation;
    protected boolean valid;

    public AnnotationModel(Class<T> type, ClassTransformer transformer) {
        this.annotatedAnnotation = transformer.loadAnnotation(type);
        this.init();
    }

    protected void init() {
        this.initType();
        this.initValid();
    }

    protected void initType() {
        if (!Annotation.class.isAssignableFrom(this.getRawType())) {
            throw new DefinitionException(this.getMetaAnnotationTypes().toString() + " can only be applied to an annotation, it was applied to " + this.getRawType());
        }
    }

    protected void initValid() {
        this.valid = false;
        for (Class<Annotation> annotationType : this.getMetaAnnotationTypes()) {
            if (!this.annotatedAnnotation.isAnnotationPresent(annotationType)) continue;
            this.valid = true;
        }
        if (this.annotatedAnnotation.isAnnotationPresent(Retention.class) && !this.annotatedAnnotation.getAnnotation(Retention.class).value().equals((Object)RetentionPolicy.RUNTIME)) {
            this.valid = false;
            log.debug((Object)"#0 is missing @Retention(RUNTIME)", this.annotatedAnnotation);
        }
    }

    public Class<T> getRawType() {
        return this.annotatedAnnotation.getJavaClass();
    }

    protected abstract Set<Class<? extends Annotation>> getMetaAnnotationTypes();

    public boolean isValid() {
        return this.valid;
    }

    protected WBAnnotation<T> getAnnotatedAnnotation() {
        return this.annotatedAnnotation;
    }

    public String toString() {
        return (this.isValid() ? "Valid" : "Invalid") + " annotation model for " + this.getRawType();
    }
}

