/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.data.LocalTransaction;
import com.sun.messaging.jmq.jmsserver.data.ToTxnLogConverter;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TxnConverter;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;

class LocalTxnConverter
extends TxnConverter {
    LocalTxnConverter(TransactionList transactionList, Store store) {
        super(transactionList, store);
    }

    String getPrefix() {
        return Thread.currentThread() + " ToTxnLogConverter.LocalTxnConverter.";
    }

    void convert(TransactionInformation transactionInformation) throws BrokerException {
        Object object;
        int n;
        if (ToTxnLogConverter.DEBUG) {
            logger.log(4, this.getPrefix() + " convertLocalToTxnLogFormat " + transactionInformation);
        }
        if ((n = transactionInformation.getState().getState()) != 5) {
            object = this.getPrefix() + " convertLocalToTxnLogFormat: unknown state  " + n + " for " + transactionInformation;
            logger.log(32, (String)object);
        }
        object = new TransactionWork();
        this.getSentMessages(transactionInformation, (TransactionWork)object);
        this.getConsumedMessages(transactionInformation, (TransactionWork)object);
        TransactionUID transactionUID = transactionInformation.getTID();
        JMQXid jMQXid = transactionInformation.getState().getXid();
        LocalTransaction localTransaction = new LocalTransaction(transactionUID, n, jMQXid, (TransactionWork)object);
        TransactionState transactionState = new TransactionState(transactionInformation.getState());
        localTransaction.setTransactionState(transactionState);
        this.store.logTxn(localTransaction);
        this.deleteSentMessagesFromStore((TransactionWork)object);
    }
}

