/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.ClusterTxnConverter;
import com.sun.messaging.jmq.jmsserver.data.LocalTxnConverter;
import com.sun.messaging.jmq.jmsserver.data.RemoteTxnConverter;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Collection;
import java.util.Map;

public class ToTxnLogConverter {
    static Logger logger = Globals.getLogger();
    public static boolean DEBUG = false;

    public static void convertToTxnLogFormat(TransactionList transactionList, FileStore fileStore) throws BrokerException {
        Map map = transactionList.getTransactionListMap();
        ToTxnLogConverter.convertTxnList(map.values(), transactionList, fileStore);
        Map map2 = transactionList.getRemoteTransactionListMap();
        ToTxnLogConverter.convertTxnList(map2.values(), transactionList, fileStore);
    }

    static void convertTxnList(Collection collection, TransactionList transactionList, FileStore fileStore) throws BrokerException {
        if (DEBUG) {
            logger.log(4, ToTxnLogConverter.getPrefix() + " convertTxnList  " + collection.size());
        }
        block5: for (TransactionInformation transactionInformation : collection) {
            int n = transactionInformation.getType();
            LocalTxnConverter localTxnConverter = new LocalTxnConverter(transactionList, fileStore);
            ClusterTxnConverter clusterTxnConverter = new ClusterTxnConverter(transactionList, fileStore);
            RemoteTxnConverter remoteTxnConverter = new RemoteTxnConverter(transactionList, fileStore);
            switch (n) {
                case 1: {
                    localTxnConverter.convert(transactionInformation);
                    continue block5;
                }
                case 2: {
                    clusterTxnConverter.convert(transactionInformation);
                    continue block5;
                }
                case 3: {
                    remoteTxnConverter.convert(transactionInformation);
                    continue block5;
                }
            }
            String string = ToTxnLogConverter.getPrefix() + "convertToTxnLogFormat: unknown transaction type " + n + " for " + transactionInformation;
            logger.log(32, string);
        }
    }

    private static String getPrefix() {
        return Thread.currentThread() + " ToTxnLogConverter.";
    }

    static {
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
    }
}

