/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.Protocol;
import com.sun.grizzly.config.dom.Protocols;
import java.beans.PropertyVetoException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-protocol")
@Scoped(value=PerLookup.class)
@I18n(value="create.protocol")
public class CreateProtocol
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateProtocol.class);
    @Param(name="protocolname", primary=true)
    String protocolName;
    @Param(name="securityenabled", optional=true)
    String securityEnabled;
    @Inject
    Configs configs;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        NetworkConfig networkConfig = config.getNetworkConfig();
        Protocols protocols = networkConfig.getProtocols();
        for (Protocol protocol : protocols.getProtocol()) {
            if (this.protocolName == null || !this.protocolName.equalsIgnoreCase(protocol.getName())) continue;
            report.setMessage(localStrings.getLocalString("create.protocol.fail.duplicate", "{0} protocol already exists. Cannot add duplicate protocol"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<Protocols>(){

                @Override
                public Object run(Protocols param) throws PropertyVetoException, TransactionFailure {
                    boolean docrootAdded = false;
                    boolean accessLogAdded = false;
                    Protocol newProtocol = (Protocol)param.createChild(Protocol.class);
                    newProtocol.setName(CreateProtocol.this.protocolName);
                    newProtocol.setSecurityEnabled(CreateProtocol.this.securityEnabled);
                    param.getProtocol().add(newProtocol);
                    return newProtocol;
                }
            }, protocols);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.protocol.fail", "Failed to create protocol {0} ", new Object[]{this.protocolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

