/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.grizzly.config.dom.NetworkConfig;
import com.sun.grizzly.config.dom.NetworkListener;
import java.beans.PropertyChangeEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.web.admin.monitor.JspStatsProvider;
import org.glassfish.web.admin.monitor.RequestStatsProvider;
import org.glassfish.web.admin.monitor.ServletStatsProvider;
import org.glassfish.web.admin.monitor.SessionStatsProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="web")
@Scoped(value=Singleton.class)
public class WebStatsProviderBootstrap
implements PostConstruct,
ConfigListener {
    private static final String NODE_SEPARATOR = "/";
    @Inject
    private Logger logger;
    @Inject
    private static Domain domain;
    private static HttpService httpService;
    private static NetworkConfig networkConfig;
    private Server server;
    private Map<String, List> statsProviderToAppMap = new HashMap<String, List>();
    private ArrayList webContainerStatsProviderList = new ArrayList();
    private Map<String, Set<String>> moduleNamesMap = new HashMap<String, Set<String>>();

    public void postConstruct() {
        Level dbgLevel = Level.FINEST;
        Level defaultLevel = this.logger.getLevel();
        if (defaultLevel == null || dbgLevel.intValue() < defaultLevel.intValue()) {
            // empty if block
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("[Monitor]In the WebStatsProviderBootstrap.postConstruct ************");
        }
        List lc = domain.getConfigs().getConfig();
        Config config = null;
        for (Config cf : lc) {
            if (!cf.getName().equals("server-config")) continue;
            config = cf;
            break;
        }
        httpService = config.getHttpService();
        networkConfig = config.getNetworkConfig();
        this.server = null;
        List ls = domain.getServers().getServer();
        for (Server sr : ls) {
            if (!"server".equals(sr.getName())) continue;
            this.server = sr;
            break;
        }
        this.registerWebStatsProviders();
        this.registerApplicationStatsProviders();
    }

    private void registerWebStatsProviders() {
        JspStatsProvider jsp = new JspStatsProvider(null, null, this.logger);
        RequestStatsProvider wsp = new RequestStatsProvider(null, null, this.logger);
        ServletStatsProvider svsp = new ServletStatsProvider(null, null, this.logger);
        SessionStatsProvider sssp = new SessionStatsProvider(null, null, this.logger);
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.SERVER, (String)"web/jsp", (Object)jsp);
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.SERVER, (String)"web/request", (Object)wsp);
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.SERVER, (String)"web/servlet", (Object)svsp);
        StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.SERVER, (String)"web/session", (Object)sssp);
        this.webContainerStatsProviderList.add(jsp);
        this.webContainerStatsProviderList.add(wsp);
        this.webContainerStatsProviderList.add(svsp);
        this.webContainerStatsProviderList.add(sssp);
    }

    public void registerApplicationStatsProviders() {
        List webApps = domain.getApplications().getApplicationsWithSnifferType("web");
        for (Application webApp : webApps) {
            String appName = webApp.getName();
            HashSet<String> moduleNames = this.getModulesNames(appName);
            for (String moduleName : moduleNames) {
                this.addStatsForVirtualServers(appName, moduleName);
            }
        }
    }

    private void addStatsForVirtualServers(String appName, String moduleName) {
        for (ApplicationRef ar : this.server.getApplicationRef()) {
            if (!appName.equals(ar.getRef())) continue;
            String vsL = ar.getVirtualServers();
            if (vsL != null) {
                for (String host : vsL.split(",")) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(moduleName).append(NODE_SEPARATOR).append(host);
                    String node = sb.toString();
                    ArrayList<Object> statspList = this.statsProviderToAppMap.get(moduleName);
                    if (statspList == null) {
                        statspList = new ArrayList<Object>();
                    }
                    JspStatsProvider jspStatsProvider = new JspStatsProvider(moduleName, host, this.logger);
                    StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.APPLICATIONS, (String)node, (Object)jspStatsProvider);
                    statspList.add(jspStatsProvider);
                    ServletStatsProvider servletStatsProvider = new ServletStatsProvider(moduleName, host, this.logger);
                    StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.APPLICATIONS, (String)node, (Object)servletStatsProvider);
                    statspList.add(servletStatsProvider);
                    SessionStatsProvider sessionStatsProvider = new SessionStatsProvider(moduleName, host, this.logger);
                    StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.APPLICATIONS, (String)node, (Object)sessionStatsProvider);
                    statspList.add(sessionStatsProvider);
                    RequestStatsProvider websp = new RequestStatsProvider(moduleName, host, this.logger);
                    StatsProviderManager.register((String)"web-container", (PluginPoint)PluginPoint.APPLICATIONS, (String)node, (Object)websp);
                    statspList.add(websp);
                    this.statsProviderToAppMap.put(moduleName, statspList);
                }
            }
            return;
        }
    }

    public static String getVirtualServerName(String hostName, String listenerPort) {
        try {
            if (hostName == null) {
                return null;
            }
            if (hostName.equals("localhost")) {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            NetworkListener listener = null;
            for (NetworkListener hl : networkConfig.getNetworkListeners().getNetworkListener()) {
                if (!hl.getPort().equals(listenerPort)) continue;
                listener = hl;
                break;
            }
            VirtualServer virtualServer = null;
            for (VirtualServer vs : httpService.getVirtualServer()) {
                if (!vs.getHosts().contains(hostName) || !vs.getNetworkListeners().contains(listener.getName())) continue;
                virtualServer = vs;
                break;
            }
            return virtualServer.getId();
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(WebStatsProviderBootstrap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        for (PropertyChangeEvent event : events) {
            if (!event.getPropertyName().equals("application-ref")) continue;
            String propName = event.getPropertyName();
            Set<String> moduleNames = null;
            String appName = null;
            if (event.getNewValue() != null) {
                if (this.webContainerStatsProviderList.isEmpty()) {
                    this.registerWebStatsProviders();
                }
                appName = ((ApplicationRef)event.getNewValue()).getRef();
                moduleNames = this.getModulesNames(appName);
                for (String moduleName : moduleNames) {
                    this.addStatsForVirtualServers(appName, moduleName);
                }
                this.moduleNamesMap.put(appName, moduleNames);
            } else if (event.getOldValue() != null) {
                appName = ((ApplicationRef)event.getOldValue()).getRef();
                moduleNames = this.moduleNamesMap.remove(appName);
                for (String moduleName : moduleNames) {
                    List statsProviders = this.statsProviderToAppMap.remove(moduleName);
                    for (Object statsProvider : statsProviders) {
                        StatsProviderManager.unregister(statsProvider);
                    }
                }
                if (this.statsProviderToAppMap.isEmpty()) {
                    for (Object statsProvider : this.webContainerStatsProviderList) {
                        StatsProviderManager.unregister((Object)statsProvider);
                    }
                    this.webContainerStatsProviderList.clear();
                }
            }
            if (!this.logger.isLoggable(Level.FINEST)) continue;
            this.logger.finest("[Monitor] (Un)Deploy event received - name = " + propName + " : Value = " + appName);
        }
        return null;
    }

    private HashSet<String> getModulesNames(String appName) {
        HashSet<String> moduleNames = new HashSet<String>();
        List webApps = domain.getApplications().getApplicationsWithSnifferType("web");
        block0: for (Application webApp : webApps) {
            if (!appName.equals(webApp.getName())) continue;
            List modules = webApp.getModule();
            for (Module module : modules) {
                if (module.getEngine("web") == null) continue;
                if (webApp.isStandaloneModule()) {
                    moduleNames.add(module.getName());
                    continue block0;
                }
                moduleNames.add(this.getNestedModuleName(appName, module.getName()));
            }
        }
        return moduleNames;
    }

    private String getNestedModuleName(String appName, String moduleName) {
        StringBuilder sb = new StringBuilder();
        sb.append(appName).append(NODE_SEPARATOR).append(moduleName);
        return sb.toString().replaceAll("\\.", "\\\\.").replaceAll("_war", "\\\\.war");
    }

    static {
        httpService = null;
        networkConfig = null;
    }
}

