/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.CollectionExpression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.LiteralExpression;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.expressions.TableAliasLookup;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.ReportQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression
implements Serializable,
Cloneable {
    static final long serialVersionUID = -5979150600092006081L;
    protected transient DatabaseTable lastTable;
    protected transient DatabaseTable currentAlias;
    protected boolean selectIfOrderedBy = true;
    protected int hashCode = 0;

    public Expression addDate(String datePart, int numberToAdd) {
        return this.addDate(datePart, new Integer(numberToAdd));
    }

    public Expression addDate(String datePart, Object numberToAdd) {
        ExpressionOperator anOperator = this.getOperator(90);
        FunctionExpression expression = new FunctionExpression();
        expression.setBaseExpression(this);
        expression.addChild(this);
        expression.addChild(Expression.fromLiteral(datePart, this));
        expression.addChild(Expression.from(numberToAdd, this));
        expression.setOperator(anOperator);
        return expression;
    }

    public Expression addMonths(int months) {
        return this.addMonths(new Integer(months));
    }

    public Expression addMonths(Object months) {
        ExpressionOperator anOperator = this.getOperator(47);
        return anOperator.expressionFor(this, months);
    }

    public DatabaseTable aliasForTable(DatabaseTable table) {
        return null;
    }

    public Expression allOf(String attributeName, Expression criteria) {
        ReportQuery subQuery = new ReportQuery();
        subQuery.setShouldRetrieveFirstPrimaryKey(true);
        ExpressionBuilder builder = criteria.getBuilder();
        criteria = builder.equal(this.anyOf(attributeName)).and(criteria.not());
        subQuery.setSelectionCriteria(criteria);
        return this.notExists(subQuery);
    }

    public Expression and(Expression theExpression) {
        if (theExpression == null) {
            return this;
        }
        ExpressionBuilder base = this.getBuilder();
        Expression expressionToUse = theExpression;
        if (theExpression.getBuilder() != base && (base == this || theExpression.getBuilder().getQueryClass() == null)) {
            expressionToUse = theExpression.rebuildOn(base);
        }
        if (base == this) {
            return expressionToUse;
        }
        ExpressionOperator anOperator = this.getOperator(1);
        return anOperator.expressionFor(this, expressionToUse);
    }

    public Expression anyOf(String attributeName) {
        QueryKeyExpression queryKey = (QueryKeyExpression)this.get(attributeName);
        queryKey.doQueryToManyRelationship();
        return queryKey;
    }

    public Expression anyOfAllowingNone(String attributeName) {
        QueryKeyExpression queryKey = (QueryKeyExpression)this.getAllowingNull(attributeName);
        queryKey.doQueryToManyRelationship();
        return queryKey;
    }

    public Expression ascending() {
        return this.getFunction(26);
    }

    public Expression asciiValue() {
        ExpressionOperator anOperator = this.getOperator(45);
        return anOperator.expressionFor(this);
    }

    public Expression asOf(AsOfClause pastTime) {
        return this;
    }

    protected void assignAlias(String name, DatabaseTable tableOrExpression) {
    }

    public int assignTableAliasesStartingAt(int initialValue) {
        if (this.hasBeenAliased()) {
            return initialValue;
        }
        int counter = initialValue;
        Vector ownedTables = this.getOwnedTables();
        if (ownedTables != null) {
            Enumeration e = ownedTables.elements();
            while (e.hasMoreElements()) {
                this.assignAlias("t" + counter, (DatabaseTable)e.nextElement());
                ++counter;
            }
        }
        return counter;
    }

    public Expression average() {
        return this.getFunction(21);
    }

    public Expression between(byte leftValue, byte rightValue) {
        return this.between(new Byte(leftValue), new Byte(rightValue));
    }

    public Expression between(char leftChar, char rightChar) {
        return this.between(new Character(leftChar), new Character(rightChar));
    }

    public Expression between(double leftValue, double rightValue) {
        return this.between(new Double(leftValue), new Double(rightValue));
    }

    public Expression between(float leftValue, float rightValue) {
        return this.between(new Float(leftValue), new Float(rightValue));
    }

    public Expression between(int leftValue, int rightValue) {
        return this.between(new Integer(leftValue), new Integer(rightValue));
    }

    public Expression between(long leftValue, long rightValue) {
        return this.between(new Long(leftValue), new Long(rightValue));
    }

    public Expression between(Object leftValue, Object rightValue) {
        ExpressionOperator anOperator = this.getOperator(15);
        NonSynchronizedVector args = NonSynchronizedVector.newInstance();
        ((Vector)args).addElement(leftValue);
        ((Vector)args).addElement(rightValue);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression between(Expression leftExpression, Expression rightExpression) {
        return this.between((Object)leftExpression, (Object)rightExpression);
    }

    public Expression between(short leftValue, short rightValue) {
        return this.between(new Short(leftValue), new Short(rightValue));
    }

    public Expression caseStatement(Map caseItems, Object defaultItem) {
        ExpressionOperator anOperator = new ExpressionOperator();
        anOperator.setSelector(117);
        anOperator.setNodeClass(FunctionExpression.class);
        anOperator.setType(5);
        anOperator.bePrefix();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(caseItems.size() * 2 + 3);
        ((Vector)v).addElement("CASE ");
        FunctionExpression expression = new FunctionExpression();
        expression.setBaseExpression(this);
        expression.addChild(this);
        for (Object key : caseItems.keySet()) {
            expression.addChild(Expression.from(key, this));
            expression.addChild(Expression.from(caseItems.get(key), this));
            ((Vector)v).addElement(" WHEN ");
            ((Vector)v).addElement(" THEN ");
        }
        ((Vector)v).addElement(" ELSE ");
        expression.addChild(Expression.from(defaultItem, this));
        ((Vector)v).addElement(" END");
        anOperator.printsAs(v);
        expression.setOperator(anOperator);
        return expression;
    }

    public Expression caseConditionStatement(Map<Expression, Object> caseConditions, Object defaultItem) {
        ExpressionOperator anOperator = new ExpressionOperator();
        anOperator.setSelector(117);
        anOperator.setNodeClass(FunctionExpression.class);
        anOperator.setType(5);
        anOperator.bePrefix();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(caseConditions.size() * 2 + 2);
        FunctionExpression expression = new FunctionExpression();
        expression.setBaseExpression(this);
        Iterator<Expression> iterator = caseConditions.keySet().iterator();
        if (iterator.hasNext()) {
            ((Vector)v).addElement("CASE WHEN ");
            Expression key = iterator.next();
            expression.addChild(key);
            expression.setBaseExpression(key);
            ((Vector)v).addElement(" THEN ");
            expression.addChild(Expression.from(caseConditions.get(key), this));
            while (iterator.hasNext()) {
                ((Vector)v).addElement(" WHEN ");
                key = iterator.next();
                expression.addChild(key);
                ((Vector)v).addElement(" THEN ");
                expression.addChild(Expression.from(caseConditions.get(key), this));
            }
        }
        ((Vector)v).addElement(" ELSE ");
        expression.addChild(Expression.from(defaultItem, this));
        ((Vector)v).addElement(" END");
        anOperator.printsAs(v);
        expression.setOperator(anOperator);
        return expression;
    }

    public Expression nullIf(Object object) {
        ExpressionOperator anOperator = this.getOperator(131);
        NonSynchronizedVector args = NonSynchronizedVector.newInstance(1);
        ((Vector)args).addElement(Expression.from(object, this));
        return anOperator.expressionForArguments(this, args);
    }

    public Expression coalesce(Collection expressions) {
        ExpressionOperator anOperator = new ExpressionOperator();
        anOperator.setSelector(132);
        anOperator.setNodeClass(FunctionExpression.class);
        anOperator.setType(5);
        anOperator.bePrefix();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(expressions.size() + 1);
        ((Vector)v).addElement("COALESCE(");
        FunctionExpression expression = new FunctionExpression();
        expression.setBaseExpression(this);
        Iterator iterator = expressions.iterator();
        if (iterator.hasNext()) {
            Expression base = Expression.from(iterator.next(), this);
            expression.addChild(base);
            expression.setBaseExpression(base);
            while (iterator.hasNext()) {
                ((Vector)v).addElement(", ");
                expression.addChild(Expression.from(iterator.next(), this));
            }
        }
        ((Vector)v).addElement(" )");
        anOperator.printsAs(v);
        expression.setOperator(anOperator);
        return expression;
    }

    public Object clone() {
        IdentityHashMap alreadyDone = new IdentityHashMap();
        return this.copiedVersionFrom(alreadyDone);
    }

    public Expression cloneUsing(Expression newBase) {
        IdentityHashMap alreadyDone = new IdentityHashMap();
        alreadyDone.put(alreadyDone, newBase);
        return this.copiedVersionFrom(alreadyDone);
    }

    public Expression concat(Object left) {
        ExpressionOperator anOperator = this.getOperator(31);
        return anOperator.expressionFor(this, left);
    }

    public Expression containsAllKeyWords(String spaceSeparatedKeyWords) {
        StringTokenizer tokenizer = new StringTokenizer(spaceSeparatedKeyWords);
        Expression expression = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (expression == null) {
                expression = this.containsSubstringIgnoringCase(token);
                continue;
            }
            expression = expression.and(this.containsSubstringIgnoringCase(token));
        }
        if (expression == null) {
            return this.like("%");
        }
        return expression;
    }

    public Expression containsAnyKeyWords(String spaceSeparatedKeyWords) {
        StringTokenizer tokenizer = new StringTokenizer(spaceSeparatedKeyWords);
        Expression expression = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (expression == null) {
                expression = this.containsSubstringIgnoringCase(token);
                continue;
            }
            expression = expression.or(this.containsSubstringIgnoringCase(token));
        }
        if (expression == null) {
            return this.like("%");
        }
        return expression;
    }

    public Expression containsSubstring(String theValue) {
        return this.like("%" + theValue + "%");
    }

    public Expression containsSubstring(Expression expression) {
        return this.like(this.value("%").concat(expression).concat("%"));
    }

    public Expression containsSubstringIgnoringCase(String theValue) {
        return this.toUpperCase().containsSubstring(theValue.toUpperCase());
    }

    public Expression containsSubstringIgnoringCase(Expression expression) {
        return this.toUpperCase().containsSubstring(expression.toUpperCase());
    }

    protected void convertNodeToUseOuterJoin() {
    }

    public Expression convertToUseOuterJoin() {
        ExpressionIterator iterator = new ExpressionIterator(){

            public void iterate(Expression each) {
                each.convertNodeToUseOuterJoin();
            }
        };
        iterator.iterateOn(this);
        return this;
    }

    public Expression copiedVersionFrom(Map alreadyDone) {
        if (alreadyDone == null) {
            return this;
        }
        Expression existing = (Expression)alreadyDone.get(this);
        if (existing == null) {
            return this.registerIn(alreadyDone);
        }
        return existing;
    }

    public Expression count() {
        return this.getFunction(19);
    }

    public Expression create(Expression base, Object singleArgument, ExpressionOperator anOperator) {
        return this;
    }

    public Expression createWithBaseLast(Expression base, Object singleArgument, ExpressionOperator anOperator) {
        return this;
    }

    public Expression create(Expression base, Vector arguments, ExpressionOperator anOperator) {
        return this;
    }

    public Expression currentTimeStamp() {
        return this.currentDate();
    }

    public Expression currentDate() {
        return this.getFunction(54);
    }

    public Expression currentDateDate() {
        return this.getFunction(123);
    }

    public Expression currentTime() {
        return this.getFunction(128);
    }

    public Expression dateDifference(String datePart, Date date) {
        ExpressionOperator anOperator = this.getOperator(94);
        FunctionExpression expression = new FunctionExpression();
        expression.setBaseExpression(this);
        expression.addChild(Expression.fromLiteral(datePart, this));
        expression.addChild(Expression.from(date, this));
        expression.addChild(this);
        expression.setOperator(anOperator);
        return expression;
    }

    public Expression dateDifference(String datePart, Expression comparisonExpression) {
        ExpressionOperator anOperator = this.getOperator(94);
        FunctionExpression expression = new FunctionExpression();
        expression.setBaseExpression(this);
        expression.addChild(Expression.fromLiteral(datePart, this));
        expression.addChild(comparisonExpression);
        expression.addChild(this);
        expression.setOperator(anOperator);
        return expression;
    }

    public Expression dateName(String datePart) {
        ExpressionOperator anOperator = this.getOperator(92);
        FunctionExpression expression = new FunctionExpression();
        expression.setBaseExpression(this);
        expression.addChild(Expression.fromLiteral(datePart, this));
        expression.addChild(this);
        expression.setOperator(anOperator);
        return expression;
    }

    public Expression datePart(String datePart) {
        ExpressionOperator anOperator = this.getOperator(93);
        FunctionExpression expression = new FunctionExpression();
        expression.setBaseExpression(this);
        expression.addChild(Expression.fromLiteral(datePart, this));
        expression.addChild(this);
        expression.setOperator(anOperator);
        return expression;
    }

    public Expression dateToString() {
        ExpressionOperator anOperator = this.getOperator(48);
        return anOperator.expressionFor(this);
    }

    public Expression decode(Map decodeableItems, String defaultItem) {
        ExpressionOperator anOperator = new ExpressionOperator();
        anOperator.setSelector(105);
        anOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        anOperator.setType(5);
        anOperator.bePrefix();
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(decodeableItems.size() + 1);
        ((Vector)v).addElement("DECODE(");
        for (int i = 0; i < decodeableItems.size() * 2 + 1; ++i) {
            ((Vector)v).addElement(", ");
        }
        ((Vector)v).addElement(")");
        anOperator.printsAs(v);
        FunctionExpression expression = new FunctionExpression();
        expression.setBaseExpression(this);
        expression.addChild(this);
        for (Object key : decodeableItems.keySet()) {
            expression.addChild(Expression.from(key, this));
            expression.addChild(Expression.from(decodeableItems.get(key), this));
        }
        expression.addChild(Expression.from(defaultItem, this));
        expression.setOperator(anOperator);
        return expression;
    }

    public Expression descending() {
        return this.getFunction(27);
    }

    public String descriptionOfNodeType() {
        return "Expression";
    }

    public boolean detectExpression(Vector theObjects) {
        boolean foundExpression = false;
        int size = theObjects.size();
        for (int i = 0; i < size; ++i) {
            Object element = theObjects.get(i);
            if (!(element instanceof Expression)) continue;
            foundExpression = true;
            break;
        }
        return foundExpression;
    }

    public Expression difference(String expression) {
        ExpressionOperator anOperator = this.getOperator(98);
        return anOperator.expressionFor(this, expression);
    }

    public Expression distinct() {
        return this.getFunction(87);
    }

    public boolean doesConform(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy) throws QueryException {
        return this.doesConform(object, session, translationRow, valueHolderPolicy, false);
    }

    public boolean doesConform(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean objectIsUnregistered) throws QueryException {
        throw QueryException.cannotConformExpression();
    }

    public boolean equals(Object expression) {
        return this == expression || expression != null && this.getClass().equals(expression.getClass()) && this.hashCode() == expression.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
        }
        return this.hashCode;
    }

    public int computeHashCode() {
        return 32;
    }

    public Expression equal(byte theValue) {
        return this.equal(new Byte(theValue));
    }

    public Expression equal(char theChar) {
        return this.equal(new Character(theChar));
    }

    public Expression equal(double theValue) {
        return this.equal(new Double(theValue));
    }

    public Expression equal(float theValue) {
        return this.equal(new Float(theValue));
    }

    public Expression equal(int theValue) {
        return this.equal(new Integer(theValue));
    }

    public Expression equal(long theValue) {
        return this.equal(new Long(theValue));
    }

    public Expression equal(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(4);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression equal(Expression theValue) {
        ExpressionOperator anOperator = this.getOperator(4);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression equal(short theValue) {
        return this.equal(new Short(theValue));
    }

    public Expression equal(boolean theBoolean) {
        return this.equal((Object)theBoolean);
    }

    public Expression equalOuterJoin(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(6);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression equalOuterJoin(Expression theValue) {
        ExpressionOperator anOperator = this.getOperator(6);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression equalsIgnoreCase(String theValue) {
        return this.toUpperCase().equal(theValue.toUpperCase());
    }

    public Expression equalsIgnoreCase(Expression theValue) {
        return this.toUpperCase().equal(theValue.toUpperCase());
    }

    public Expression exists(ReportQuery subQuery) {
        ExpressionOperator anOperator = this.getOperator(86);
        return anOperator.expressionFor(this.subQuery(subQuery));
    }

    public boolean extractPrimaryKeyValues(boolean requireExactMatch, ClassDescriptor descriptor, AbstractRecord primaryKeyRow, AbstractRecord translationRow) {
        return false;
    }

    public static Expression from(Object value, Expression base) {
        if (value instanceof Expression) {
            Expression exp = (Expression)value;
            if (exp.isValueExpression()) {
                exp.setLocalBase(base);
            } else {
                base.setLocalBase(exp);
            }
            return exp;
        }
        if (value instanceof ReportQuery) {
            Expression exp = base.subQuery((ReportQuery)value);
            exp.setLocalBase(base);
            base.setLocalBase(exp);
            return exp;
        }
        return Expression.fromConstant(value, base);
    }

    public static Expression fromConstant(Object value, Expression base) {
        return new ConstantExpression(value, base);
    }

    public static Expression fromLiteral(String value, Expression base) {
        return new LiteralExpression(value, base);
    }

    public Expression get(String attributeName) {
        return this.get(attributeName, null);
    }

    public Expression get(String attributeName, Vector arguments) {
        return null;
    }

    public Expression getAllowingNull(String attributeName) {
        return this.getAllowingNull(attributeName, null);
    }

    public Expression getAllowingNull(String attributeName, Vector arguments) {
        return this.get(attributeName, arguments);
    }

    public AsOfClause getAsOfClause() {
        return null;
    }

    public AsOfClause getAsOfClauseRecursively() {
        return null;
    }

    public abstract ExpressionBuilder getBuilder();

    public DatabaseField getClonedField() {
        return null;
    }

    public Expression getField(String fieldName) {
        throw QueryException.illegalUseOfGetField(fieldName);
    }

    public Expression getField(DatabaseField field) {
        throw QueryException.illegalUseOfGetField(field);
    }

    public Vector getFields() {
        return NonSynchronizedVector.newInstance(1);
    }

    public Object getFieldValue(Object objectValue, AbstractSession session) {
        return objectValue;
    }

    public Expression getFunction(int selector) {
        ExpressionOperator anOperator = this.getOperator(selector);
        return anOperator.expressionFor(this);
    }

    public Expression getFunction(int selector, Vector arguments) {
        ExpressionOperator anOperator = this.getOperator(selector);
        return anOperator.expressionForArguments(this, arguments);
    }

    public Expression getFunction(String functionName) {
        ExpressionOperator anOperator = ExpressionOperator.simpleFunction(0, functionName);
        return anOperator.expressionFor(this);
    }

    public Expression getFunction(String functionName, Object argument) {
        ExpressionOperator anOperator = ExpressionOperator.simpleTwoArgumentFunction(0, functionName);
        return anOperator.expressionFor(this, argument);
    }

    public Expression getFunctionWithArguments(String functionName, Vector arguments) {
        ExpressionOperator anOperator = new ExpressionOperator();
        anOperator.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(arguments.size());
        ((Vector)v).addElement(functionName + "(");
        for (int index = 0; index < arguments.size(); ++index) {
            ((Vector)v).addElement(", ");
        }
        ((Vector)v).addElement(")");
        anOperator.printsAs(v);
        anOperator.bePrefix();
        anOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return anOperator.expressionForArguments(this, arguments);
    }

    public Expression type() {
        return null;
    }

    public String getName() {
        return "";
    }

    public ExpressionOperator getOperator() {
        return null;
    }

    public ExpressionOperator getOperator(int selector) {
        ExpressionOperator result = ExpressionOperator.getOperator(new Integer(selector));
        if (result != null) {
            return result;
        }
        result = new ExpressionOperator();
        result.setSelector(selector);
        result.setNodeClass(ClassConstants.FunctionExpression_Class);
        return result;
    }

    public Vector getOwnedTables() {
        return null;
    }

    public Expression getParameter(String parameterName, Object type) {
        return new ParameterExpression(parameterName, this, type);
    }

    public Expression getParameter(String parameterName) {
        return new ParameterExpression(parameterName, this, null);
    }

    public Expression getParameter(DatabaseField field) {
        return new ParameterExpression(field, this);
    }

    public AbstractSession getSession() {
        return this.getBuilder().getSession();
    }

    public Expression getTable(String tableName) {
        DatabaseTable table = new DatabaseTable(tableName);
        return this.getTable(table);
    }

    public Expression getTable(DatabaseTable table) {
        throw QueryException.illegalUseOfGetTable(table);
    }

    public TableAliasLookup getTableAliases() {
        return null;
    }

    public Expression greaterThan(byte theValue) {
        return this.greaterThan(new Byte(theValue));
    }

    public Expression greaterThan(char theChar) {
        return this.greaterThan(new Character(theChar));
    }

    public Expression greaterThan(double theValue) {
        return this.greaterThan(new Double(theValue));
    }

    public Expression greaterThan(float theValue) {
        return this.greaterThan(new Float(theValue));
    }

    public Expression greaterThan(int theValue) {
        return this.greaterThan(new Integer(theValue));
    }

    public Expression greaterThan(long theValue) {
        return this.greaterThan(new Long(theValue));
    }

    public Expression greaterThan(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(9);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression greaterThan(Expression theValue) {
        ExpressionOperator anOperator = this.getOperator(9);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression greaterThan(short theValue) {
        return this.greaterThan(new Short(theValue));
    }

    public Expression greaterThan(boolean theBoolean) {
        return this.greaterThan((Object)theBoolean);
    }

    public Expression greaterThanEqual(byte theValue) {
        return this.greaterThanEqual(new Byte(theValue));
    }

    public Expression greaterThanEqual(char theChar) {
        return this.greaterThanEqual(new Character(theChar));
    }

    public Expression greaterThanEqual(double theValue) {
        return this.greaterThanEqual(new Double(theValue));
    }

    public Expression greaterThanEqual(float theValue) {
        return this.greaterThanEqual(new Float(theValue));
    }

    public Expression greaterThanEqual(int theValue) {
        return this.greaterThanEqual(new Integer(theValue));
    }

    public Expression greaterThanEqual(long theValue) {
        return this.greaterThanEqual(new Long(theValue));
    }

    public Expression greaterThanEqual(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(10);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression greaterThanEqual(Expression theValue) {
        ExpressionOperator anOperator = this.getOperator(10);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression greaterThanEqual(short theValue) {
        return this.greaterThanEqual(new Short(theValue));
    }

    public Expression greaterThanEqual(boolean theBoolean) {
        return this.greaterThanEqual((Object)theBoolean);
    }

    public boolean hasAsOfClause() {
        return false;
    }

    public boolean hasBeenAliased() {
        return false;
    }

    public Expression hexToRaw() {
        ExpressionOperator anOperator = this.getOperator(32);
        return anOperator.expressionFor(this);
    }

    public Expression ifNull(Object nullValue) {
        ExpressionOperator anOperator = this.getOperator(104);
        return anOperator.expressionFor(this, nullValue);
    }

    public Expression in(byte[] theBytes) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theBytes.length; ++index) {
            ((Vector)vector).addElement(new Byte(theBytes[index]));
        }
        return this.in(vector);
    }

    public Expression in(char[] theChars) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theChars.length; ++index) {
            ((Vector)vector).addElement(new Character(theChars[index]));
        }
        return this.in(vector);
    }

    public Expression in(double[] theDoubles) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theDoubles.length; ++index) {
            ((Vector)vector).addElement(new Double(theDoubles[index]));
        }
        return this.in(vector);
    }

    public Expression in(float[] theFloats) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theFloats.length; ++index) {
            ((Vector)vector).addElement(new Float(theFloats[index]));
        }
        return this.in(vector);
    }

    public Expression in(int[] theInts) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theInts.length; ++index) {
            ((Vector)vector).addElement(new Integer(theInts[index]));
        }
        return this.in(vector);
    }

    public Expression in(long[] theLongs) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theLongs.length; ++index) {
            ((Vector)vector).addElement(new Long(theLongs[index]));
        }
        return this.in(vector);
    }

    public Expression in(Object[] theObjects) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theObjects.length; ++index) {
            ((Vector)vector).addElement(theObjects[index]);
        }
        return this.in(vector);
    }

    public Expression in(short[] theShorts) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theShorts.length; ++index) {
            ((Vector)vector).addElement(new Short(theShorts[index]));
        }
        return this.in(vector);
    }

    public Expression in(boolean[] theBooleans) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theBooleans.length; ++index) {
            ((Vector)vector).addElement(theBooleans[index]);
        }
        return this.in(vector);
    }

    public Expression in(Collection theObjects) {
        return this.in(new CollectionExpression(theObjects, this));
    }

    public Expression in(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(13);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression in(ReportQuery subQuery) {
        ExpressionOperator anOperator = this.getOperator(129);
        return anOperator.expressionFor(this, subQuery);
    }

    public Expression index() {
        throw QueryException.indexRequiresQueryKeyExpression(this);
    }

    public Expression indexOf(Object substring) {
        ExpressionOperator anOperator = this.getOperator(34);
        return anOperator.expressionFor(this, substring);
    }

    public boolean isClassTypeExpression() {
        return false;
    }

    public boolean isCompoundExpression() {
        return false;
    }

    public boolean isConstantExpression() {
        return false;
    }

    public boolean isDataExpression() {
        return false;
    }

    public Expression isEmpty(String attributeName) {
        return this.size(attributeName).equal(0);
    }

    public boolean isExpressionBuilder() {
        return false;
    }

    public boolean isFieldExpression() {
        return false;
    }

    public boolean isFunctionExpression() {
        return false;
    }

    public boolean isLiteralExpression() {
        return false;
    }

    public boolean isLogicalExpression() {
        return false;
    }

    public Expression isNull() {
        ExpressionOperator anOperator = this.getOperator(17);
        return anOperator.expressionFor(this);
    }

    public boolean isObjectExpression() {
        return false;
    }

    public boolean isParameterExpression() {
        return false;
    }

    public boolean isQueryKeyExpression() {
        return false;
    }

    public boolean isRelationExpression() {
        return false;
    }

    public boolean isTableExpression() {
        return false;
    }

    public boolean isMapEntryExpression() {
        return false;
    }

    public boolean isValueExpression() {
        return false;
    }

    public void iterateOn(ExpressionIterator iterator) {
        iterator.iterate(this);
    }

    public Expression lastDay() {
        ExpressionOperator anOperator = this.getOperator(49);
        return anOperator.expressionFor(this);
    }

    public Expression leftPad(int size, Object substring) {
        return this.leftPad(new Integer(size), substring);
    }

    public Expression leftPad(Object size, Object substring) {
        ExpressionOperator anOperator = this.getOperator(36);
        NonSynchronizedVector args = NonSynchronizedVector.newInstance(2);
        ((Vector)args).addElement(size);
        ((Vector)args).addElement(substring);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression leftTrim() {
        ExpressionOperator anOperator = this.getOperator(37);
        return anOperator.expressionFor(this);
    }

    public Expression leftTrim(Object substring) {
        ExpressionOperator anOperator = this.getOperator(122);
        return anOperator.expressionFor(this, substring);
    }

    public Expression length() {
        ExpressionOperator anOperator = this.getOperator(46);
        return anOperator.expressionFor(this);
    }

    public Expression lessThan(byte theValue) {
        return this.lessThan(new Byte(theValue));
    }

    public Expression lessThan(char theChar) {
        return this.lessThan(new Character(theChar));
    }

    public Expression lessThan(double theValue) {
        return this.lessThan(new Double(theValue));
    }

    public Expression lessThan(float theValue) {
        return this.lessThan(new Float(theValue));
    }

    public Expression lessThan(int theValue) {
        return this.lessThan(new Integer(theValue));
    }

    public Expression lessThan(long theValue) {
        return this.lessThan(new Long(theValue));
    }

    public Expression lessThan(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(7);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression lessThan(Expression theValue) {
        ExpressionOperator anOperator = this.getOperator(7);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression lessThan(short theValue) {
        return this.lessThan(new Short(theValue));
    }

    public Expression lessThan(boolean theBoolean) {
        return this.lessThan((Object)theBoolean);
    }

    public Expression lessThanEqual(byte theValue) {
        return this.lessThanEqual(new Byte(theValue));
    }

    public Expression lessThanEqual(char theChar) {
        return this.lessThanEqual(new Character(theChar));
    }

    public Expression lessThanEqual(double theValue) {
        return this.lessThanEqual(new Double(theValue));
    }

    public Expression lessThanEqual(float theValue) {
        return this.lessThanEqual(new Float(theValue));
    }

    public Expression lessThanEqual(int theValue) {
        return this.lessThanEqual(new Integer(theValue));
    }

    public Expression lessThanEqual(long theValue) {
        return this.lessThanEqual(new Long(theValue));
    }

    public Expression lessThanEqual(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(8);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression lessThanEqual(Expression theValue) {
        ExpressionOperator anOperator = this.getOperator(8);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression lessThanEqual(short theValue) {
        return this.lessThanEqual(new Short(theValue));
    }

    public Expression lessThanEqual(boolean theBoolean) {
        return this.lessThanEqual((Object)theBoolean);
    }

    public Expression like(String value) {
        return this.like(new ConstantExpression(value, this));
    }

    public Expression like(String value, String escapeSequence) {
        ExpressionOperator anOperator = this.getOperator(89);
        NonSynchronizedVector args = NonSynchronizedVector.newInstance();
        ((Vector)args).addElement(value);
        ((Vector)args).addElement(escapeSequence);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression like(Expression argument) {
        ExpressionOperator anOperator = this.getOperator(11);
        return anOperator.expressionFor(this, argument);
    }

    public Expression like(Expression value, Expression escapeSequence) {
        ExpressionOperator anOperator = this.getOperator(89);
        Vector<Expression> args = new Vector<Expression>();
        args.addElement(value);
        args.addElement(escapeSequence);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression likeIgnoreCase(String theValue) {
        return this.toUpperCase().like(theValue.toUpperCase());
    }

    public Expression likeIgnoreCase(Expression theValue) {
        return this.toUpperCase().like(theValue.toUpperCase());
    }

    public Expression locate(Object str) {
        ExpressionOperator anOperator = this.getOperator(112);
        NonSynchronizedVector args = NonSynchronizedVector.newInstance(1);
        ((Vector)args).addElement(str);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression locate(String str, int fromIndex) {
        return this.locate((Object)str, new Integer(fromIndex));
    }

    public Expression locate(Object str, Object fromIndex) {
        ExpressionOperator anOperator = this.getOperator(113);
        NonSynchronizedVector args = NonSynchronizedVector.newInstance(2);
        ((Vector)args).addElement(str);
        ((Vector)args).addElement(fromIndex);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression maximum() {
        return this.getFunction(22);
    }

    public Expression minimum() {
        return this.getFunction(23);
    }

    public Expression monthsBetween(Object otherDate) {
        ExpressionOperator anOperator = this.getOperator(50);
        return anOperator.expressionFor(this, otherDate);
    }

    public Expression mapEntry() {
        MapEntryExpression expression = new MapEntryExpression(this);
        expression.returnMapEntry();
        return expression;
    }

    public Expression mapKey() {
        return new MapEntryExpression(this);
    }

    public Expression newTime(String timeZoneFrom, String timeZoneTo) {
        ExpressionOperator anOperator = this.getOperator(103);
        NonSynchronizedVector args = NonSynchronizedVector.newInstance();
        ((Vector)args).addElement(timeZoneFrom);
        ((Vector)args).addElement(timeZoneTo);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression nextDay(Object dayName) {
        ExpressionOperator anOperator = this.getOperator(51);
        return anOperator.expressionFor(this, dayName);
    }

    public Expression noneOf(String attributeName, Expression criteria) {
        ReportQuery subQuery = new ReportQuery();
        subQuery.setShouldRetrieveFirstPrimaryKey(true);
        ExpressionBuilder builder = criteria.getBuilder();
        criteria = builder.equal(this.anyOf(attributeName)).and(criteria);
        subQuery.setSelectionCriteria(criteria);
        return this.notExists(subQuery);
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        this.validateNode();
        return this;
    }

    public Expression not() {
        ExpressionOperator anOperator = this.getOperator(3);
        return anOperator.expressionFor(this);
    }

    public Expression notBetween(byte leftValue, byte rightValue) {
        return this.notBetween(new Byte(leftValue), new Byte(rightValue));
    }

    public Expression notBetween(char leftChar, char rightChar) {
        return this.notBetween(new Character(leftChar), new Character(rightChar));
    }

    public Expression notBetween(double leftValue, double rightValue) {
        return this.notBetween(new Double(leftValue), new Double(rightValue));
    }

    public Expression notBetween(float leftValue, float rightValue) {
        return this.notBetween(new Float(leftValue), new Float(rightValue));
    }

    public Expression notBetween(int leftValue, int rightValue) {
        return this.notBetween(new Integer(leftValue), new Integer(rightValue));
    }

    public Expression notBetween(long leftValue, long rightValue) {
        return this.notBetween(new Long(leftValue), new Long(rightValue));
    }

    public Expression notBetween(Object leftValue, Object rightValue) {
        return this.between(leftValue, rightValue).not();
    }

    public Expression notBetween(Expression leftExpression, Expression rightExpression) {
        return this.between(leftExpression, rightExpression).not();
    }

    public Expression notBetween(short leftValue, short rightValue) {
        return this.notBetween(new Short(leftValue), new Short(rightValue));
    }

    public Expression notEmpty(String attributeName) {
        return this.size(attributeName).greaterThan(0);
    }

    public Expression notEqual(byte theValue) {
        return this.notEqual(new Byte(theValue));
    }

    public Expression notEqual(char theChar) {
        return this.notEqual(new Character(theChar));
    }

    public Expression notEqual(double theValue) {
        return this.notEqual(new Double(theValue));
    }

    public Expression notEqual(float theValue) {
        return this.notEqual(new Float(theValue));
    }

    public Expression notEqual(int theValue) {
        return this.notEqual(new Integer(theValue));
    }

    public Expression notEqual(long theValue) {
        return this.notEqual(new Long(theValue));
    }

    public Expression notEqual(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(5);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression notEqual(Expression theValue) {
        ExpressionOperator anOperator = this.getOperator(5);
        return anOperator.expressionFor(this, theValue);
    }

    public Expression notEqual(short theValue) {
        return this.notEqual(new Short(theValue));
    }

    public Expression notEqual(boolean theBoolean) {
        return this.notEqual((Object)theBoolean);
    }

    public Expression notExists(ReportQuery subQuery) {
        ExpressionOperator anOperator = this.getOperator(88);
        return anOperator.expressionFor(this.subQuery(subQuery));
    }

    public Expression notIn(byte[] theBytes) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theBytes.length; ++index) {
            ((Vector)vector).addElement(new Byte(theBytes[index]));
        }
        return this.notIn(vector);
    }

    public Expression notIn(char[] theChars) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theChars.length; ++index) {
            ((Vector)vector).addElement(new Character(theChars[index]));
        }
        return this.notIn(vector);
    }

    public Expression notIn(double[] theDoubles) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theDoubles.length; ++index) {
            ((Vector)vector).addElement(new Double(theDoubles[index]));
        }
        return this.notIn(vector);
    }

    public Expression notIn(float[] theFloats) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theFloats.length; ++index) {
            ((Vector)vector).addElement(new Float(theFloats[index]));
        }
        return this.notIn(vector);
    }

    public Expression notIn(int[] theInts) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theInts.length; ++index) {
            ((Vector)vector).addElement(new Integer(theInts[index]));
        }
        return this.notIn(vector);
    }

    public Expression notIn(long[] theLongs) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theLongs.length; ++index) {
            ((Vector)vector).addElement(new Long(theLongs[index]));
        }
        return this.notIn(vector);
    }

    public Expression notIn(Object[] theObjects) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theObjects.length; ++index) {
            ((Vector)vector).addElement(theObjects[index]);
        }
        return this.notIn(vector);
    }

    public Expression notIn(ReportQuery subQuery) {
        ExpressionOperator anOperator = this.getOperator(130);
        return anOperator.expressionFor(this, subQuery);
    }

    public Expression notIn(short[] theShorts) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theShorts.length; ++index) {
            ((Vector)vector).addElement(new Short(theShorts[index]));
        }
        return this.notIn(vector);
    }

    public Expression notIn(boolean[] theBooleans) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theBooleans.length; ++index) {
            ((Vector)vector).addElement(theBooleans[index]);
        }
        return this.notIn(vector);
    }

    public Expression notIn(Collection theObjects) {
        return this.notIn(new CollectionExpression(theObjects, this));
    }

    public Expression notIn(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(14);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression notLike(String aString) {
        return this.notLike(new ConstantExpression(aString, this));
    }

    public Expression notLike(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(12);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression notNull() {
        ExpressionOperator anOperator = this.getOperator(18);
        return anOperator.expressionFor(this);
    }

    public Expression or(Expression theExpression) {
        if (theExpression == null) {
            return this;
        }
        ExpressionBuilder base = this.getBuilder();
        Expression expressionToUse = theExpression;
        if (theExpression.getBuilder() != base && theExpression.getBuilder().getQueryClass() == null) {
            expressionToUse = theExpression.rebuildOn(base);
        }
        if (base == this) {
            return expressionToUse;
        }
        ExpressionOperator anOperator = this.getOperator(2);
        return anOperator.expressionFor(this, expressionToUse);
    }

    public Expression performOperator(ExpressionOperator anOperator, Vector args) {
        return anOperator.expressionForArguments(this, args);
    }

    protected void postCopyIn(Map alreadyDone) {
    }

    public Expression postfixSQL(String sqlString) {
        ExpressionOperator anOperator = new ExpressionOperator();
        anOperator.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(1);
        ((Vector)v).addElement(sqlString);
        anOperator.printsAs(v);
        anOperator.bePostfix();
        anOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return anOperator.expressionFor(this);
    }

    public Expression prefixSQL(String sqlString) {
        ExpressionOperator anOperator = new ExpressionOperator();
        anOperator.setType(5);
        NonSynchronizedVector v = NonSynchronizedVector.newInstance(1);
        ((Vector)v).addElement(sqlString);
        anOperator.printsAs(v);
        anOperator.bePrefix();
        anOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return anOperator.expressionFor(this);
    }

    public abstract void printSQL(ExpressionSQLPrinter var1);

    public void printJava(ExpressionJavaPrinter printer) {
    }

    public void printSQLWithoutConversion(ExpressionSQLPrinter printer) {
        this.printSQL(printer);
    }

    public abstract Expression rebuildOn(Expression var1);

    public Expression ref() {
        return this.getFunction(83);
    }

    protected Expression registerIn(Map alreadyDone) {
        Expression copy = this.shallowClone();
        alreadyDone.put(this, copy);
        copy.postCopyIn(alreadyDone);
        return copy;
    }

    public Expression replace(Object stringToReplace, Object stringToReplaceWith) {
        ExpressionOperator anOperator = this.getOperator(38);
        NonSynchronizedVector args = NonSynchronizedVector.newInstance(2);
        ((Vector)args).addElement(stringToReplace);
        ((Vector)args).addElement(stringToReplaceWith);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression replicate(int constant) {
        return this.replicate(new Integer(constant));
    }

    public Expression replicate(Object theValue) {
        ExpressionOperator anOperator = this.getOperator(100);
        return anOperator.expressionFor(this, theValue);
    }

    protected void resetCache() {
    }

    public Expression reverse() {
        return this.getFunction(99);
    }

    public Expression right(int characters) {
        return this.right(new Integer(characters));
    }

    public Expression right(Object characters) {
        ExpressionOperator anOperator = this.getOperator(101);
        return anOperator.expressionFor(this, characters);
    }

    public Expression rightPad(int size, Object substring) {
        return this.rightPad(new Integer(size), substring);
    }

    public Expression rightPad(Object size, Object substring) {
        ExpressionOperator anOperator = this.getOperator(39);
        NonSynchronizedVector args = NonSynchronizedVector.newInstance(2);
        ((Vector)args).addElement(size);
        ((Vector)args).addElement(substring);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression rightTrim() {
        ExpressionOperator anOperator = this.getOperator(40);
        return anOperator.expressionFor(this);
    }

    public Expression rightTrim(Object substring) {
        ExpressionOperator anOperator = this.getOperator(116);
        return anOperator.expressionFor(this, substring);
    }

    public Expression roundDate(Object yearOrMonthOrDayRoundToken) {
        ExpressionOperator anOperator = this.getOperator(52);
        return anOperator.expressionFor(this, yearOrMonthOrDayRoundToken);
    }

    public boolean selectIfOrderedBy() {
        return this.selectIfOrderedBy;
    }

    public void setLocalBase(Expression exp) {
    }

    public void setSelectIfOrderedBy(boolean selectIfOrderedBy) {
        this.selectIfOrderedBy = selectIfOrderedBy;
    }

    public Expression shallowClone() {
        Expression result = null;
        try {
            result = (Expression)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.toString());
        }
        return result;
    }

    public Expression size(String attributeName) {
        ReportQuery subQuery = new ReportQuery();
        subQuery.addCount();
        subQuery.setSelectionCriteria(subQuery.getExpressionBuilder().equal(this.anyOf(attributeName)));
        return this.subQuery(subQuery);
    }

    public Expression size(Class returnType) {
        ReportQuery subQuery = new ReportQuery();
        subQuery.addCount("COUNT", subQuery.getExpressionBuilder(), returnType);
        subQuery.setSelectionCriteria(subQuery.getExpressionBuilder().equal(this));
        if (((BaseExpression)this).getBaseExpression() == null) {
            return this.subQuery(subQuery);
        }
        return ((BaseExpression)this).getBaseExpression().subQuery(subQuery);
    }

    public Expression standardDeviation() {
        return this.getFunction(24);
    }

    public Expression subQuery(ReportQuery subQuery) {
        return new SubSelectExpression(subQuery, this);
    }

    public Expression substring(int startPosition, int size) {
        return this.substring(new Integer(startPosition), new Integer(size));
    }

    public Expression substring(Object startPosition, Object size) {
        ExpressionOperator anOperator = this.getOperator(41);
        NonSynchronizedVector args = NonSynchronizedVector.newInstance(2);
        ((Vector)args).addElement(startPosition);
        ((Vector)args).addElement(size);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression substring(int startPosition) {
        return this.substring(new Integer(startPosition));
    }

    public Expression substring(Object startPosition) {
        ExpressionOperator anOperator = this.getOperator(133);
        NonSynchronizedVector args = NonSynchronizedVector.newInstance(1);
        ((Vector)args).addElement(startPosition);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression sum() {
        return this.getFunction(20);
    }

    public Expression toCharacter() {
        ExpressionOperator anOperator = this.getOperator(30);
        return anOperator.expressionFor(this);
    }

    public Expression toDate() {
        ExpressionOperator anOperator = this.getOperator(53);
        return anOperator.expressionFor(this);
    }

    public Expression toChar() {
        ExpressionOperator anOperator = this.getOperator(114);
        return anOperator.expressionFor(this);
    }

    public Expression toChar(String format) {
        ExpressionOperator anOperator = this.getOperator(115);
        return anOperator.expressionFor(this, format);
    }

    public Expression toLowerCase() {
        ExpressionOperator anOperator = this.getOperator(29);
        return anOperator.expressionFor(this);
    }

    public Expression toNumber() {
        ExpressionOperator anOperator = this.getOperator(42);
        return anOperator.expressionFor(this);
    }

    public String toString() {
        try {
            StringWriter innerWriter = new StringWriter();
            BufferedWriter outerWriter = new BufferedWriter(innerWriter);
            this.toString(outerWriter, 0);
            outerWriter.flush();
            return innerWriter.toString();
        }
        catch (IOException e) {
            return ToStringLocalization.buildMessage("error_printing_expression", null);
        }
    }

    public void toString(BufferedWriter writer, int indent) throws IOException {
        writer.newLine();
        for (int i = 0; i < indent; ++i) {
            writer.write("   ");
        }
        writer.write(this.descriptionOfNodeType());
        writer.write(" ");
        this.writeDescriptionOn(writer);
        this.writeSubexpressionsTo(writer, indent + 1);
    }

    public Expression toUpperCase() {
        ExpressionOperator anOperator = this.getOperator(28);
        return anOperator.expressionFor(this);
    }

    public Expression toUppercaseCasedWords() {
        ExpressionOperator anOperator = this.getOperator(33);
        return anOperator.expressionFor(this);
    }

    public Expression translate(Object fromString, Object toString) {
        ExpressionOperator anOperator = this.getOperator(43);
        NonSynchronizedVector args = NonSynchronizedVector.newInstance(2);
        ((Vector)args).addElement(fromString);
        ((Vector)args).addElement(toString);
        return anOperator.expressionForArguments(this, args);
    }

    public Expression trim() {
        ExpressionOperator anOperator = this.getOperator(44);
        return anOperator.expressionFor(this);
    }

    public Expression trim(Object substring) {
        ExpressionOperator anOperator = this.getOperator(121);
        return anOperator.expressionForWithBaseLast(this, substring);
    }

    public Expression extract(String xpath) {
        ExpressionOperator anOperator = this.getOperator(106);
        return anOperator.expressionFor(this, xpath);
    }

    public Expression extractValue(String xpath) {
        ExpressionOperator anOperator = this.getOperator(107);
        return anOperator.expressionFor(this, xpath);
    }

    public Expression existsNode(String xpath) {
        ExpressionOperator anOperator = this.getOperator(108);
        return anOperator.expressionFor(this, xpath);
    }

    public Expression isFragment() {
        ExpressionOperator anOperator = this.getOperator(111);
        return anOperator.expressionFor(this);
    }

    public Expression getStringVal() {
        ExpressionOperator anOperator = this.getOperator(109);
        return anOperator.expressionFor(this);
    }

    public Expression getNumberVal() {
        ExpressionOperator anOperator = this.getOperator(110);
        return anOperator.expressionFor(this);
    }

    public Expression truncateDate(String datePart) {
        ExpressionOperator anOperator = this.getOperator(102);
        return anOperator.expressionFor(this, datePart);
    }

    public Expression twist(Expression expression, Expression newBase) {
        if (expression == null) {
            return null;
        }
        return expression.twistedForBaseAndContext(newBase, this);
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        return this;
    }

    public void validateNode() {
    }

    public Expression value() {
        ExpressionOperator anOperator = this.getOperator(85);
        return anOperator.expressionFor(this);
    }

    public Expression value(byte constant) {
        return this.value(new Byte(constant));
    }

    public Expression value(char constant) {
        return this.value(new Character(constant));
    }

    public Expression value(double constant) {
        return this.value(new Double(constant));
    }

    public Expression value(float constant) {
        return this.value(new Float(constant));
    }

    public Expression value(int constant) {
        return this.value(new Integer(constant));
    }

    public Expression value(long constant) {
        return this.value(new Long(constant));
    }

    public Expression value(Object constant) {
        return new ConstantExpression(constant, this);
    }

    public Expression value(short constant) {
        return this.value(new Short(constant));
    }

    public Expression value(boolean constant) {
        return this.value((Object)constant);
    }

    public Expression literal(String literal) {
        return new LiteralExpression(literal, this);
    }

    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        throw QueryException.cannotConformExpression();
    }

    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy) {
        return this.valueFromObject(object, session, translationRow, valueHolderPolicy, false);
    }

    public Expression variance() {
        return this.getFunction(25);
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write("some expression");
    }

    protected void writeField(ExpressionSQLPrinter printer, DatabaseField field, SQLSelectStatement statement) {
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        if (statement.requiresAliases()) {
            if (field.getTable() != this.lastTable) {
                this.lastTable = field.getTable();
                this.currentAlias = this.aliasForTable(this.lastTable);
            }
            printer.printString(this.currentAlias.getQualifiedNameDelimited(printer.getPlatform()));
            printer.printString(".");
        }
        printer.printString(field.getNameDelimited(printer.getPlatform()));
        if (statement.getUseUniqueFieldAliases()) {
            printer.printString(" AS " + field.getNameDelimited(printer.getPlatform()) + statement.getNextFieldCounterValue());
        }
    }

    protected void writeAlias(ExpressionSQLPrinter printer, DatabaseField field, SQLSelectStatement statement) {
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        if (statement.requiresAliases()) {
            if (field.getTable() != this.lastTable) {
                this.lastTable = field.getTable();
                this.currentAlias = this.aliasForTable(this.lastTable);
            }
            printer.printString(this.currentAlias.getQualifiedNameDelimited(printer.getPlatform()));
        } else {
            printer.printString(field.getTable().getQualifiedNameDelimited(printer.getPlatform()));
        }
    }

    public void writeFields(ExpressionSQLPrinter printer, Vector newFields, SQLSelectStatement statement) {
        Enumeration fieldsEnum = this.getFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            DatabaseField field = (DatabaseField)fieldsEnum.nextElement();
            newFields.addElement(field);
            this.writeField(printer, field, statement);
        }
    }

    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
    }

    public Expression any(byte[] theBytes) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theBytes.length; ++index) {
            ((Vector)vector).addElement(new Byte(theBytes[index]));
        }
        return this.any(vector);
    }

    public Expression any(char[] theChars) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theChars.length; ++index) {
            ((Vector)vector).addElement(new Character(theChars[index]));
        }
        return this.any(vector);
    }

    public Expression any(double[] theDoubles) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theDoubles.length; ++index) {
            ((Vector)vector).addElement(new Double(theDoubles[index]));
        }
        return this.any(vector);
    }

    public Expression any(float[] theFloats) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theFloats.length; ++index) {
            ((Vector)vector).addElement(new Float(theFloats[index]));
        }
        return this.any(vector);
    }

    public Expression any(int[] theInts) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theInts.length; ++index) {
            ((Vector)vector).addElement(new Integer(theInts[index]));
        }
        return this.any(vector);
    }

    public Expression any(long[] theLongs) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theLongs.length; ++index) {
            ((Vector)vector).addElement(new Long(theLongs[index]));
        }
        return this.any(vector);
    }

    public Expression any(Object[] theObjects) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theObjects.length; ++index) {
            ((Vector)vector).addElement(theObjects[index]);
        }
        return this.any(vector);
    }

    public Expression any(short[] theShorts) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theShorts.length; ++index) {
            ((Vector)vector).addElement(new Short(theShorts[index]));
        }
        return this.any(vector);
    }

    public Expression any(boolean[] theBooleans) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theBooleans.length; ++index) {
            ((Vector)vector).addElement(theBooleans[index]);
        }
        return this.any(vector);
    }

    public Expression any(Vector theObjects) {
        return this.any(new ConstantExpression(theObjects, this));
    }

    public Expression any(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(118);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression any(ReportQuery subQuery) {
        return this.any(this.subQuery(subQuery));
    }

    public Expression some(byte[] theBytes) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theBytes.length; ++index) {
            ((Vector)vector).addElement(new Byte(theBytes[index]));
        }
        return this.some(vector);
    }

    public Expression some(char[] theChars) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theChars.length; ++index) {
            ((Vector)vector).addElement(new Character(theChars[index]));
        }
        return this.some(vector);
    }

    public Expression some(double[] theDoubles) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theDoubles.length; ++index) {
            ((Vector)vector).addElement(new Double(theDoubles[index]));
        }
        return this.some(vector);
    }

    public Expression some(float[] theFloats) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theFloats.length; ++index) {
            ((Vector)vector).addElement(new Float(theFloats[index]));
        }
        return this.some(vector);
    }

    public Expression some(int[] theInts) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theInts.length; ++index) {
            ((Vector)vector).addElement(new Integer(theInts[index]));
        }
        return this.some(vector);
    }

    public Expression some(long[] theLongs) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theLongs.length; ++index) {
            ((Vector)vector).addElement(new Long(theLongs[index]));
        }
        return this.some(vector);
    }

    public Expression some(Object[] theObjects) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theObjects.length; ++index) {
            ((Vector)vector).addElement(theObjects[index]);
        }
        return this.some(vector);
    }

    public Expression some(short[] theShorts) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theShorts.length; ++index) {
            ((Vector)vector).addElement(new Short(theShorts[index]));
        }
        return this.some(vector);
    }

    public Expression some(boolean[] theBooleans) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theBooleans.length; ++index) {
            ((Vector)vector).addElement(theBooleans[index]);
        }
        return this.some(vector);
    }

    public Expression some(Vector theObjects) {
        return this.some(new ConstantExpression(theObjects, this));
    }

    public Expression some(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(119);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression some(ReportQuery subQuery) {
        return this.some(this.subQuery(subQuery));
    }

    public Expression all(byte[] theBytes) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theBytes.length; ++index) {
            ((Vector)vector).addElement(new Byte(theBytes[index]));
        }
        return this.all(vector);
    }

    public Expression all(char[] theChars) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theChars.length; ++index) {
            ((Vector)vector).addElement(new Character(theChars[index]));
        }
        return this.all(vector);
    }

    public Expression all(double[] theDoubles) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theDoubles.length; ++index) {
            ((Vector)vector).addElement(new Double(theDoubles[index]));
        }
        return this.all(vector);
    }

    public Expression all(float[] theFloats) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theFloats.length; ++index) {
            ((Vector)vector).addElement(new Float(theFloats[index]));
        }
        return this.all(vector);
    }

    public Expression all(int[] theInts) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theInts.length; ++index) {
            ((Vector)vector).addElement(new Integer(theInts[index]));
        }
        return this.all(vector);
    }

    public Expression all(long[] theLongs) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theLongs.length; ++index) {
            ((Vector)vector).addElement(new Long(theLongs[index]));
        }
        return this.all(vector);
    }

    public Expression all(Object[] theObjects) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theObjects.length; ++index) {
            ((Vector)vector).addElement(theObjects[index]);
        }
        return this.all(vector);
    }

    public Expression all(short[] theShorts) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theShorts.length; ++index) {
            ((Vector)vector).addElement(new Short(theShorts[index]));
        }
        return this.all(vector);
    }

    public Expression all(boolean[] theBooleans) {
        NonSynchronizedVector vector = NonSynchronizedVector.newInstance();
        for (int index = 0; index < theBooleans.length; ++index) {
            ((Vector)vector).addElement(theBooleans[index]);
        }
        return this.all(vector);
    }

    public Expression all(Vector theObjects) {
        return this.all(new ConstantExpression(theObjects, this));
    }

    public Expression all(Expression arguments) {
        ExpressionOperator anOperator = this.getOperator(120);
        return anOperator.expressionFor(this, arguments);
    }

    public Expression all(ReportQuery subQuery) {
        return this.all(this.subQuery(subQuery));
    }
}

