/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.record.ObjectUnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.SequencedUnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmappedContentHandlerWrapper;
import org.eclipse.persistence.internal.oxm.record.UnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.namespaces.StackUnmarshalNamespaceResolver;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceResolver;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.unmapped.DefaultUnmappedContentHandler;
import org.eclipse.persistence.oxm.unmapped.UnmappedContentHandler;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

public class UnmarshalRecord
extends XMLRecord
implements ContentHandler,
LexicalHandler {
    public static final UnmappedContentHandler DEFAULT_UNMAPPED_CONTENT_HANDLER = new DefaultUnmappedContentHandler();
    private XMLReader xmlReader;
    private TreeObjectBuilder treeObjectBuilder;
    private XPathFragment xPathFragment = new XPathFragment();
    private XPathNode xPathNode;
    private int levelIndex = 0;
    private UnmarshalRecord childRecord;
    private UnmarshalRecord parentRecord;
    private DOMRecord transformationRecord;
    private List<UnmarshalRecord> selfRecords;
    private Map indexMap;
    private List<NullCapableValue> nullCapableValues;
    private Map<ContainerValue, Object> containersMap;
    private boolean isBufferCDATA = false;
    private Attributes attributes;
    private QName typeQName;
    private String rootElementName;
    private String rootElementNamespaceUri;
    private SAXFragmentBuilder fragmentBuilder;
    private String encoding;
    private String version;
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private boolean isSelfRecord;
    private UnmarshalContext unmarshalContext;
    private UnmarshalNamespaceResolver unmarshalNamespaceResolver;
    private boolean isXsiNil;

    public UnmarshalRecord(TreeObjectBuilder treeObjectBuilder) {
        this.treeObjectBuilder = treeObjectBuilder;
        if (null != treeObjectBuilder) {
            this.xPathNode = treeObjectBuilder.getRootXPathNode();
            if (null != treeObjectBuilder.getNullCapableValues()) {
                this.nullCapableValues = new ArrayList<NullCapableValue>(treeObjectBuilder.getNullCapableValues());
            }
        }
        this.isSelfRecord = false;
    }

    public String getLocalName() {
        throw XMLMarshalException.operationNotSupported("getLocalName");
    }

    public String getNamespaceURI() {
        throw XMLMarshalException.operationNotSupported("getNamespaceURI");
    }

    public void clear() {
        throw XMLMarshalException.operationNotSupported("clear");
    }

    public Document getDocument() {
        throw XMLMarshalException.operationNotSupported("getDocument");
    }

    public Element getDOM() {
        throw XMLMarshalException.operationNotSupported("getDOM");
    }

    public String transformToXML() {
        throw XMLMarshalException.operationNotSupported("transformToXML");
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public UnmarshalRecord getChildRecord() {
        return this.childRecord;
    }

    public void setChildRecord(UnmarshalRecord childRecord) {
        this.childRecord = childRecord;
        if (null != childRecord) {
            childRecord.setParentRecord(this);
            childRecord.session = this.session;
            childRecord.xmlReader = this.xmlReader;
            childRecord.setFragmentBuilder(this.fragmentBuilder);
            childRecord.setUnmarshalNamespaceResolver(this.getUnmarshalNamespaceResolver());
        }
    }

    public UnmarshalRecord getParentRecord() {
        return this.parentRecord;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public void setRootElementName(String qName) {
        this.rootElementName = qName;
    }

    public String getRootElementNamespaceUri() {
        return this.rootElementNamespaceUri;
    }

    public void setRootElementNamespaceUri(String uri) {
        this.rootElementNamespaceUri = uri;
    }

    public void setParentRecord(UnmarshalRecord parentRecord) {
        this.parentRecord = parentRecord;
    }

    public DOMRecord getTransformationRecord() {
        return this.transformationRecord;
    }

    public void setTransformationRecord(DOMRecord transformationRecord) {
        this.transformationRecord = transformationRecord;
    }

    public UnmarshalNamespaceResolver getUnmarshalNamespaceResolver() {
        if (null == this.unmarshalNamespaceResolver) {
            this.unmarshalNamespaceResolver = new StackUnmarshalNamespaceResolver();
        }
        return this.unmarshalNamespaceResolver;
    }

    public void setUnmarshalNamespaceResolver(UnmarshalNamespaceResolver anUnmarshalNamespaceResolver) {
        this.unmarshalNamespaceResolver = anUnmarshalNamespaceResolver;
    }

    public List getNullCapableValues() {
        return this.nullCapableValues;
    }

    public void removeNullCapableValue(NullCapableValue nullCapableValue) {
        if (null != this.nullCapableValues) {
            this.nullCapableValues.remove(nullCapableValue);
        }
    }

    public Object getContainerInstance(ContainerValue containerValue) {
        if (null == this.containersMap) {
            return null;
        }
        return this.containersMap.get(containerValue);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public void setNoNamespaceSchemaLocation(String location) {
        this.noNamespaceSchemaLocation = location;
    }

    public StrBuffer getStringBuffer() {
        return this.getUnmarshaller().getStringBuffer();
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    public void setTypeQName(QName typeQName) {
        this.typeQName = typeQName;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.getParentRecord() == null && locator instanceof Locator2) {
            Locator2 loc = (Locator2)locator;
            this.setEncoding(loc.getEncoding());
            this.setVersion(loc.getXMLVersion());
        }
    }

    public Object get(DatabaseField key) {
        XMLField xmlField = this.convertToXMLField(key);
        XPathFragment lastFragment = xmlField.getLastXPathFragment();
        NamespaceResolver namespaceResolver = xmlField.getNamespaceResolver();
        String namespaceURI = "";
        if (null != namespaceResolver && null == (namespaceURI = namespaceResolver.resolveNamespacePrefix(lastFragment.getPrefix()))) {
            namespaceURI = "";
        }
        return this.attributes.getValue(namespaceURI, lastFragment.getLocalName());
    }

    public XPathNode getXPathNode() {
        return this.xPathNode;
    }

    public XMLDescriptor getDescriptor() {
        return (XMLDescriptor)this.treeObjectBuilder.getDescriptor();
    }

    public UnmarshalContext getUnmarshalContext() {
        return this.unmarshalContext;
    }

    public void setUnmarshalContext(UnmarshalContext unmarshalContext) {
        this.unmarshalContext = unmarshalContext;
    }

    public void startDocument() throws SAXException {
        this.startDocument(null);
    }

    public void startDocument(XMLMapping selfRecordMapping) throws SAXException {
        try {
            XMLDescriptor xmlDescriptor = (XMLDescriptor)this.treeObjectBuilder.getDescriptor();
            this.unmarshalContext = xmlDescriptor.isSequencedObject() ? new SequencedUnmarshalContext() : ObjectUnmarshalContext.getInstance();
            Object object = this.getXMLReader().getCurrentObject(this.session, selfRecordMapping);
            if (object == null) {
                object = this.treeObjectBuilder.buildNewInstance();
            }
            this.setCurrentObject(object);
            XMLUnmarshalListener xmlUnmarshalListener = this.getUnmarshaller().getUnmarshalListener();
            if (null != xmlUnmarshalListener) {
                if (null == this.parentRecord) {
                    xmlUnmarshalListener.beforeUnmarshal(object, null);
                } else {
                    xmlUnmarshalListener.beforeUnmarshal(object, this.parentRecord.getCurrentObject());
                }
            }
            if (null == this.parentRecord) {
                this.xmlReader.newObjectEvent(object, null, selfRecordMapping);
            } else {
                this.xmlReader.newObjectEvent(object, this.parentRecord.getCurrentObject(), selfRecordMapping);
            }
            List containerValues = this.treeObjectBuilder.getContainerValues();
            if (null != containerValues) {
                this.containersMap = new HashMap<ContainerValue, Object>(containerValues.size());
                int containerValuesSize = containerValues.size();
                for (int x = 0; x < containerValuesSize; ++x) {
                    ContainerValue containerValue = (ContainerValue)containerValues.get(x);
                    Object containerInstance = null;
                    if (containerValue.getReuseContainer()) {
                        containerInstance = containerValue.getMapping().getAttributeAccessor().getAttributeValueFromObject(object);
                    }
                    if (null == containerInstance) {
                        containerInstance = containerValue.getContainerInstance();
                    }
                    this.containersMap.put(containerValue, containerInstance);
                }
            }
            if (null != this.xPathNode.getSelfChildren()) {
                int selfChildrenSize = this.xPathNode.getSelfChildren().size();
                this.selfRecords = new ArrayList<UnmarshalRecord>(selfChildrenSize);
                for (int x = 0; x < selfChildrenSize; ++x) {
                    XPathNode selfNode = (XPathNode)this.xPathNode.getSelfChildren().get(x);
                    if (null == selfNode.getNodeValue()) continue;
                    this.selfRecords.add(selfNode.getNodeValue().buildSelfRecord(this, this.attributes));
                }
            }
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    public void endDocument() throws SAXException {
        ClassDescriptor xmlDescriptor;
        Object object = this.getCurrentObject();
        if (null != this.selfRecords) {
            int selfRecordsSize = this.selfRecords.size();
            for (int x = 0; x < selfRecordsSize; ++x) {
                UnmarshalRecord selfRecord = this.selfRecords.get(x);
                if (selfRecord == null) continue;
                selfRecord.endDocument();
            }
        }
        if (null != this.xPathNode.getSelfChildren()) {
            int selfChildrenSize = this.xPathNode.getSelfChildren().size();
            for (int x = 0; x < selfChildrenSize; ++x) {
                XPathNode selfNode = (XPathNode)this.xPathNode.getSelfChildren().get(x);
                if (null == selfNode.getNodeValue()) continue;
                selfNode.getNodeValue().endSelfNodeValue(this, this.attributes);
            }
        }
        try {
            ClassDescriptor xmlDescriptor2;
            List transformationMappings;
            if (null != this.containersMap) {
                for (Map.Entry<ContainerValue, Object> entry : this.containersMap.entrySet()) {
                    entry.getKey().setContainerInstance(object, entry.getValue());
                }
            }
            if (null != this.nullCapableValues) {
                int nullValuesSize = this.nullCapableValues.size();
                for (int x = 0; x < nullValuesSize; ++x) {
                    this.nullCapableValues.get(x).setNullValue(object, this.session);
                }
            }
            if (null != (transformationMappings = this.treeObjectBuilder.getTransformationMappings())) {
                ReadObjectQuery query = new ReadObjectQuery();
                query.setSession(this.session);
                int transformationMappingsSize = transformationMappings.size();
                for (int x = 0; x < transformationMappingsSize; ++x) {
                    AbstractTransformationMapping transformationMapping = (AbstractTransformationMapping)transformationMappings.get(x);
                    transformationMapping.readFromRowIntoObject(this.transformationRecord, null, object, query, this.session);
                }
            }
            if (this.getUnmarshaller().getUnmarshalListener() != null) {
                if (this.parentRecord != null) {
                    this.getUnmarshaller().getUnmarshalListener().afterUnmarshal(object, this.parentRecord.getCurrentObject());
                } else {
                    this.getUnmarshaller().getUnmarshalListener().afterUnmarshal(object, null);
                }
            }
            if ((xmlDescriptor2 = this.treeObjectBuilder.getDescriptor()).getEventManager().hasAnyEventListeners()) {
                DescriptorEvent event = new DescriptorEvent(object);
                event.setSession(this.session);
                event.setRecord(this);
                event.setEventCode(8);
                xmlDescriptor2.getEventManager().executeEvent(event);
            }
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
        if (this.session.isUnitOfWork() && (xmlDescriptor = this.treeObjectBuilder.getDescriptor()) != null && xmlDescriptor.getPrimaryKeyFieldNames().size() > 0) {
            Vector pk = this.treeObjectBuilder.extractPrimaryKeyFromObject(object, this.session);
            CacheKey key = this.session.getIdentityMapAccessorInstance().acquireDeferredLock(pk, xmlDescriptor.getJavaClass(), xmlDescriptor);
            key.setRecord(this);
            key.setObject(object);
            key.releaseDeferredLock();
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.getUnmarshalNamespaceResolver().push(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.getUnmarshalNamespaceResolver().pop(prefix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (null != this.xPathNode.getXPathFragment() && this.xPathNode.getXPathFragment().nameIsText() && null != this.xPathNode.getUnmarshalNodeValue()) {
            this.xPathNode.getUnmarshalNodeValue().endElement(this.xPathFragment, this);
            if (this.xPathNode.getParent() != null) {
                this.xPathNode = this.xPathNode.getParent();
            }
        }
        if (this.rootElementName == null) {
            this.rootElementName = qName;
            this.rootElementNamespaceUri = namespaceURI;
            this.schemaLocation = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            this.noNamespaceSchemaLocation = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
        }
        try {
            XPathNode node;
            if (null != this.selfRecords) {
                int selfRecordsSize = this.selfRecords.size();
                for (int x = 0; x < selfRecordsSize; ++x) {
                    UnmarshalRecord selfRecord = this.selfRecords.get(x);
                    if (selfRecord == null) {
                        this.getFragmentBuilder().startElement(namespaceURI, localName, qName, atts);
                        continue;
                    }
                    selfRecord.startElement(namespaceURI, localName, qName, atts);
                }
            }
            if (null == (node = this.getNonAttributeXPathNode(namespaceURI, localName, qName))) {
                NodeValue parentNodeValue = this.xPathNode.getUnmarshalNodeValue();
                if (null == this.xPathNode.getXPathFragment() && parentNodeValue != null) {
                    XPathFragment parentFragment = new XPathFragment();
                    if (namespaceURI != null && namespaceURI.length() == 0) {
                        parentFragment.setLocalName(qName);
                        parentFragment.setNamespaceURI(null);
                    } else {
                        parentFragment.setLocalName(localName);
                        parentFragment.setNamespaceURI(namespaceURI);
                    }
                    if (parentNodeValue.startElement(parentFragment, this, atts)) {
                        ++this.levelIndex;
                        return;
                    }
                    this.startUnmappedElement(namespaceURI, localName, qName, atts);
                    return;
                }
                ++this.levelIndex;
                this.startUnmappedElement(namespaceURI, localName, qName, atts);
                return;
            }
            this.xPathNode = node;
            this.unmarshalContext.startElement(this);
            ++this.levelIndex;
            this.isXsiNil = atts.getIndex("http://www.w3.org/2001/XMLSchema-instance", "nil") >= 0;
            NodeValue nodeValue = node.getUnmarshalNodeValue();
            if (null != nodeValue && !nodeValue.startElement(this.xPathFragment, this, atts)) {
                this.startUnmappedElement(namespaceURI, localName, qName, atts);
                return;
            }
            int i = 0;
            int size = atts.getLength();
            while (i < size) {
                String qname;
                String attNamespace = atts.getURI(i);
                String attLocalName = atts.getLocalName(i);
                String value = atts.getValue(i);
                NodeValue attributeNodeValue = null;
                if ((attLocalName == null || attLocalName.length() == 0) && (qname = atts.getQName(i)) != null && qname.length() > 0) {
                    int idx = qname.indexOf(58);
                    if (idx > 0) {
                        attLocalName = qname.substring(idx + 1, qname.length());
                        String attPrefix = qname.substring(0, idx);
                        if (attPrefix.equals("xmlns")) {
                            attNamespace = "http://www.w3.org/2000/xmlns/";
                        }
                    } else {
                        attLocalName = qname;
                        if (attLocalName.equals("xmlns")) {
                            attNamespace = "http://www.w3.org/2000/xmlns/";
                        }
                    }
                }
                if (this.selfRecords != null) {
                    for (int j = 0; j < this.selfRecords.size(); ++j) {
                        UnmarshalRecord nestedRecord = this.selfRecords.get(j);
                        if (nestedRecord == null || (attributeNodeValue = nestedRecord.getAttributeChildNodeValue(attNamespace, attLocalName)) == null) continue;
                        attributeNodeValue.attribute(nestedRecord, attNamespace, attLocalName, value);
                    }
                }
                if (attributeNodeValue == null) {
                    attributeNodeValue = this.getAttributeChildNodeValue(attNamespace, attLocalName);
                    if (attributeNodeValue != null) {
                        attributeNodeValue.attribute(this, attNamespace, attLocalName, value);
                    } else if (this.xPathNode.getAnyAttributeNodeValue() != null) {
                        this.xPathNode.getAnyAttributeNodeValue().attribute(this, attNamespace, attLocalName, value);
                    }
                }
                ++i;
            }
            return;
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader) throw e;
            if (null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    public void startUnmappedElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        UnmappedContentHandler unmappedContentHandler;
        if (null != this.selfRecords || null == this.xmlReader || this.isSelfRecord()) {
            return;
        }
        Class unmappedContentHandlerClass = this.getUnmarshaller().getUnmappedContentHandlerClass();
        if (null == unmappedContentHandlerClass) {
            unmappedContentHandler = DEFAULT_UNMAPPED_CONTENT_HANDLER;
        } else {
            try {
                PrivilegedNewInstanceFromClass privilegedNewInstanceFromClass = new PrivilegedNewInstanceFromClass(unmappedContentHandlerClass);
                unmappedContentHandler = (UnmappedContentHandler)privilegedNewInstanceFromClass.run();
            }
            catch (ClassCastException e) {
                throw XMLMarshalException.unmappedContentHandlerDoesntImplement(e, unmappedContentHandlerClass.getName());
            }
            catch (IllegalAccessException e) {
                throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
            }
            catch (InstantiationException e) {
                throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(e, unmappedContentHandlerClass.getName());
            }
        }
        UnmappedContentHandlerWrapper unmappedContentHandlerWrapper = new UnmappedContentHandlerWrapper(this, unmappedContentHandler);
        unmappedContentHandlerWrapper.startElement(namespaceURI, localName, qName, atts);
        this.xmlReader.setContentHandler(unmappedContentHandlerWrapper);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (null != this.selfRecords) {
                int selfRecordsSize = this.selfRecords.size();
                for (int x = 0; x < selfRecordsSize; ++x) {
                    UnmarshalRecord selfRecord = this.selfRecords.get(x);
                    if (selfRecord != null) {
                        selfRecord.endElement(namespaceURI, localName, qName);
                        continue;
                    }
                    this.getFragmentBuilder().endSelfElement(namespaceURI, localName, qName);
                }
            }
            if (null != this.xPathNode.getUnmarshalNodeValue()) {
                this.xPathNode.getUnmarshalNodeValue().endElement(this.xPathFragment, this);
                if (this.xPathNode.getParent() != null) {
                    this.xPathNode = this.xPathNode.getParent();
                }
            } else {
                XPathNode textNode = this.xPathNode.getTextNode();
                if (null != textNode && textNode.isWhitespaceAware() && this.getStringBuffer().length() == 0) {
                    if (!this.isXsiNil) {
                        if (textNode.getUnmarshalNodeValue().isMappingNodeValue()) {
                            textNode.getUnmarshalNodeValue().endElement(this.xPathFragment, this);
                        }
                    } else {
                        this.isXsiNil = false;
                    }
                }
            }
            if (null != this.xPathNode.getParent()) {
                if (namespaceURI != null && namespaceURI.length() == 0) {
                    this.xPathFragment.setLocalName(qName);
                    this.xPathFragment.setNamespaceURI(null);
                } else {
                    this.xPathFragment.setLocalName(localName);
                    this.xPathFragment.setNamespaceURI(namespaceURI);
                }
                if (this.xPathFragment.qNameEquals(this.xPathNode.getXPathFragment())) {
                    this.xPathNode = this.xPathNode.getParent();
                }
            }
            this.unmarshalContext.endElement(this);
            this.typeQName = null;
            --this.levelIndex;
            if (0 == this.levelIndex && null != this.getParentRecord() && !this.isSelfRecord()) {
                this.endDocument();
                UnmarshalRecord pRec = this.getParentRecord();
                while (pRec.isSelfRecord()) {
                    pRec = pRec.getParentRecord();
                }
                pRec.endElement(namespaceURI, localName, qName);
                this.xmlReader.setContentHandler(pRec);
            }
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader || null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            XPathNode textNode;
            if (null != this.selfRecords) {
                int selfRecordsSize = this.selfRecords.size();
                for (int x = 0; x < selfRecordsSize; ++x) {
                    UnmarshalRecord selfRecord = this.selfRecords.get(x);
                    if (selfRecord != null) {
                        selfRecord.characters(ch, start, length);
                        continue;
                    }
                    this.getFragmentBuilder().characters(ch, start, length);
                }
            }
            if (null == (textNode = this.xPathNode.getTextNode()) && this.xPathNode.getNonAttributeChildrenMap() != null && (textNode = this.xPathNode.getAnyNode()) != null) {
                if (0 == length) {
                    return;
                }
                String tmpString = new String(ch, start, length);
                if (!textNode.isWhitespaceAware() && tmpString.trim().length() == 0) {
                    return;
                }
            }
            if (null != textNode) {
                this.xPathNode = textNode;
                this.unmarshalContext.characters(this);
            }
            if (null != this.xPathNode.getUnmarshalNodeValue()) {
                this.getStringBuffer().append(ch, start, length);
            }
        }
        catch (EclipseLinkException e) {
            if (null == this.xmlReader.getErrorHandler()) {
                throw e;
            }
            SAXParseException saxParseException = new SAXParseException(null, null, null, 0, 0, e);
            this.xmlReader.getErrorHandler().error(saxParseException);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    protected XPathNode getNonAttributeXPathNode(String namespaceURI, String localName, String qName) {
        if (0 == this.levelIndex) {
            return this.xPathNode;
        }
        if (namespaceURI != null && namespaceURI.length() == 0) {
            this.xPathFragment.setLocalName(qName);
            this.xPathFragment.setNamespaceURI(null);
        } else {
            this.xPathFragment.setLocalName(localName);
            this.xPathFragment.setNamespaceURI(namespaceURI);
        }
        XPathNode resultNode = null;
        Map<XPathFragment, XPathNode> nonAttributeChildrenMap = this.xPathNode.getNonAttributeChildrenMap();
        if (null != nonAttributeChildrenMap) {
            resultNode = nonAttributeChildrenMap.get(this.xPathFragment);
            if (null == resultNode) {
                Integer newIndex;
                if (null == this.indexMap) {
                    this.indexMap = new HashMap();
                    newIndex = new Integer(1);
                } else {
                    Integer oldIndex = (Integer)this.indexMap.get(this.xPathFragment);
                    newIndex = null == oldIndex ? new Integer(1) : new Integer(oldIndex + 1);
                }
                this.indexMap.put(this.xPathFragment, newIndex);
                XPathFragment positionalFragment = new XPathFragment();
                positionalFragment.setNamespaceURI(this.xPathFragment.getNamespaceURI());
                positionalFragment.setLocalName(this.xPathFragment.getLocalName());
                positionalFragment.setIndexValue(newIndex);
                resultNode = nonAttributeChildrenMap.get(positionalFragment);
                if (null == resultNode) {
                    resultNode = this.xPathNode.getAnyNode();
                }
            }
            return resultNode;
        }
        return null;
    }

    public String resolveNamespacePrefix(String prefix) {
        String namespaceURI = this.getUnmarshalNamespaceResolver().getNamespaceURI(prefix);
        if (null == namespaceURI && null != this.getParentRecord()) {
            namespaceURI = this.getParentRecord().resolveNamespacePrefix(prefix);
        }
        return namespaceURI;
    }

    public String resolveNamespaceUri(String uri) {
        String prefix = this.getUnmarshalNamespaceResolver().getPrefix(uri);
        if (null == prefix && null != this.getParentRecord()) {
            prefix = this.getParentRecord().resolveNamespaceUri(uri);
        }
        return prefix;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(Helper.getShortClassName(this.getClass()));
        writer.write("()");
        return writer.toString();
    }

    public NodeValue getSelfNodeValueForAttribute(String namespace, String localName) {
        if (this.selfRecords != null) {
            int selfRecordsSize = this.selfRecords.size();
            for (int i = 0; i < selfRecordsSize; ++i) {
                NodeValue node;
                UnmarshalRecord nestedRecord = this.selfRecords.get(i);
                if (nestedRecord == null || (node = nestedRecord.getAttributeChildNodeValue(namespace, localName)) == null) continue;
                return node;
            }
        }
        return null;
    }

    public NodeValue getAttributeChildNodeValue(String namespace, String localName) {
        Map<XPathFragment, XPathNode> attributeChildrenMap = this.xPathNode.getAttributeChildrenMap();
        if (attributeChildrenMap != null) {
            this.xPathFragment.setLocalName(localName);
            if (namespace != null && namespace.length() == 0) {
                this.xPathFragment.setNamespaceURI(null);
            } else {
                this.xPathFragment.setNamespaceURI(namespace);
            }
            XPathNode node = attributeChildrenMap.get(this.xPathFragment);
            if (node != null) {
                return node.getUnmarshalNodeValue();
            }
        }
        return null;
    }

    public SAXFragmentBuilder getFragmentBuilder() {
        if (this.fragmentBuilder == null) {
            this.fragmentBuilder = new SAXFragmentBuilder(this);
        }
        return this.fragmentBuilder;
    }

    public void setFragmentBuilder(SAXFragmentBuilder builder) {
        this.fragmentBuilder = builder;
    }

    public void resetStringBuffer() {
        this.getStringBuffer().reset();
        this.isBufferCDATA = false;
    }

    public boolean isBufferCDATA() {
        return this.isBufferCDATA;
    }

    public void comment(char[] data, int start, int length) {
    }

    public void startCDATA() {
        if (this.xPathNode.getUnmarshalNodeValue() != null) {
            this.isBufferCDATA = true;
        }
    }

    public void endCDATA() {
    }

    public void startEntity(String entity) {
    }

    public void endEntity(String entity) {
    }

    public void startDTD(String a, String b, String c) {
    }

    public void endDTD() {
    }

    public void setSelfRecord(boolean isSelfRecord) {
        this.isSelfRecord = isSelfRecord;
    }

    public boolean isSelfRecord() {
        return this.isSelfRecord;
    }

    public int getLevelIndex() {
        return this.levelIndex;
    }

    public void setAttributeValue(Object value, DatabaseMapping mapping) {
        this.unmarshalContext.setAttributeValue(this, value, mapping);
    }

    public void addAttributeValue(ContainerValue containerValue, Object value) {
        this.unmarshalContext.addAttributeValue(this, containerValue, value);
    }

    public void addAttributeValue(ContainerValue containerValue, Object value, Object collection) {
        this.unmarshalContext.addAttributeValue(this, containerValue, value, collection);
    }

    public void reference(Reference reference) {
        this.unmarshalContext.reference(reference);
    }

    public void unmappedContent() {
        this.unmarshalContext.unmappedContent(this);
    }
}

