/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.scripting.jruby.monitor;

import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="jruby-runtime-pool-mon", group="monitoring")
@ManagedObject
@Description(value="JRuby runtime pool info")
public class JRubyRuntimePoolStatsProvider {
    private final Logger logger = Logger.getLogger(JRubyRuntimePoolStatsProvider.class.getName());
    private final String appName;
    private final String contextPath;
    private final CountStatisticImpl hardMinimum = new CountStatisticImpl("hardMinimum", "count", "Minimum active runtimes");
    private final CountStatisticImpl hardMaximum = new CountStatisticImpl("hardMaximum", "count", "Maximum active runtimes");
    private final CountStatisticImpl activeRuntimes = new CountStatisticImpl("activeRuntimes", "count", "Currently active runtimes");
    private final CountStatisticImpl queueSize = new CountStatisticImpl("queueSize", "count", "Maximum idle runtimes");
    private final CountStatisticImpl queueUpThreshold = new CountStatisticImpl("queueUpThreshold", "count", "How eager the pool is to increase the maximum idle runtimes");
    private final CountStatisticImpl queueDownThreshold = new CountStatisticImpl("queueDownThreshold", "count", "How eager the pool is to decrease the currently active runtimes");
    private final CountStatisticImpl newThreshold = new CountStatisticImpl("newThreshold", "count", "How eager the pool is to increase the currently active runtimes");

    public JRubyRuntimePoolStatsProvider(String appName, String contextPath) {
        this.appName = appName;
        this.contextPath = contextPath;
    }

    @ManagedAttribute(id="applicationname")
    @Description(value="Application name")
    public String getApplicationName() {
        return this.appName;
    }

    @ManagedAttribute(id="contextpath")
    @Description(value="Application context-path")
    public String getContextPath() {
        return this.contextPath;
    }

    @ProbeListener(value="glassfish:jruby:runtime-pool:runtimePoolStartEvent")
    @Description(value="JRuby runtime pool creation Event")
    public void runtimePoolStartedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="hardMinimum") int hardMinimum, @ProbeParam(value="hardMaximum") int hardMaximum, @ProbeParam(value="activeRuntimes") int activeRuntimes, @ProbeParam(value="queueSize") int queueSize, @ProbeParam(value="queueUpThreshold") int queueUpThreshold, @ProbeParam(value="queueDownThreshold") int queueDownThreshold, @ProbeParam(value="newThreshold") int newThreshold) {
        if (appName == null) {
            this.logger.warning("appName is null in runtimePoolStartedEvent! Looks like the event is not triggered properly, ignoring this monitoring event.");
            return;
        }
        this.hardMinimum.setCount((long)hardMinimum);
        this.hardMaximum.setCount((long)hardMaximum);
        this.activeRuntimes.setCount((long)activeRuntimes);
        this.queueSize.setCount((long)queueSize);
        this.queueUpThreshold.setCount((long)queueUpThreshold);
        this.queueDownThreshold.setCount((long)queueDownThreshold);
        this.newThreshold.setCount((long)newThreshold);
    }

    @ProbeListener(value="glassfish:jruby:runtime-pool:runtimePoolUpdateEvent")
    @Description(value="JRuby runtime pool update Event")
    public void runtimePoolUpdatedEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="activeRuntimes") int activeRuntimes, @ProbeParam(value="queueSize") int queueSize, @ProbeParam(value="queueUpThreshold") int queueUpThreshold, @ProbeParam(value="queueDownThreshold") int queueDownThreshold, @ProbeParam(value="newThreshold") int newThreshold) {
        if (appName == null) {
            this.logger.warning("appName is null in runtimePoolUpdatedEvent! Looks like the event is not triggered properly, ignoring this monitoring event.");
            return;
        }
        this.activeRuntimes.setCount((long)activeRuntimes);
        this.queueSize.setCount((long)queueSize);
        this.queueUpThreshold.setCount((long)queueUpThreshold);
        this.queueDownThreshold.setCount((long)queueDownThreshold);
        this.newThreshold.setCount((long)newThreshold);
    }

    @ManagedAttribute
    public CountStatistic getHardMinimum() {
        return this.hardMinimum;
    }

    @ManagedAttribute
    public CountStatistic getHardMaximum() {
        return this.hardMaximum;
    }

    @ManagedAttribute
    public CountStatistic getActiveRuntimes() {
        return this.activeRuntimes;
    }
}

