/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webbeans;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.AppListenerDescriptorImpl;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.SimpleDeployer;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.webbeans.DeploymentImpl;
import org.glassfish.webbeans.WebBeansApplicationContainer;
import org.glassfish.webbeans.WebBeansContainer;
import org.glassfish.webbeans.services.EjbServicesImpl;
import org.glassfish.webbeans.services.InjectionServicesImpl;
import org.glassfish.webbeans.services.ServletServicesImpl;
import org.glassfish.webbeans.services.TransactionServicesImpl;
import org.jboss.webbeans.bootstrap.WebBeansBootstrap;
import org.jboss.webbeans.bootstrap.api.Environment;
import org.jboss.webbeans.bootstrap.api.Environments;
import org.jboss.webbeans.bootstrap.api.Service;
import org.jboss.webbeans.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.webbeans.ejb.spi.EjbServices;
import org.jboss.webbeans.injection.spi.InjectionServices;
import org.jboss.webbeans.servlet.api.ServletServices;
import org.jboss.webbeans.transaction.spi.TransactionServices;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@org.jvnet.hk2.annotations.Service
public class WebBeansDeployer
extends SimpleDeployer<WebBeansContainer, WebBeansApplicationContainer>
implements PostConstruct,
EventListener {
    public static final String WEB_BEAN_EXTENSION = "org.glassfish.webbeans";
    public static final String WEB_BEAN_DEPLOYMENT = "org.glassfish.webbeans.WebBeansDeployment";
    static final String WEB_BEAN_BOOTSTRAP = "org.glassfish.webbeans.WebBeansBootstrap";
    private static final String WEB_BEAN_LISTENER = "org.jboss.webbeans.servlet.WebBeansListener";
    @Inject
    private Events events;
    @Inject
    private Habitat habitat;
    private Map<Application, WebBeansBootstrap> appToBootstrap = new HashMap<Application, WebBeansBootstrap>();
    private Map<BundleDescriptor, BeanDeploymentArchive> bundleToBeanDeploymentArchive = new HashMap<BundleDescriptor, BeanDeploymentArchive>();

    public MetaData getMetaData() {
        return new MetaData(true, null, new Class[]{Application.class});
    }

    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public void event(EventListener.Event event) {
        ApplicationInfo appInfo;
        Application app;
        if (event.is(Deployment.APPLICATION_LOADED)) {
            ApplicationInfo appInfo2 = (ApplicationInfo)event.hook();
            WebBeansBootstrap bootstrap = (WebBeansBootstrap)appInfo2.getTransientAppMetaData(WEB_BEAN_BOOTSTRAP, WebBeansBootstrap.class);
            if (bootstrap != null) {
                DeploymentImpl deploymentImpl = (DeploymentImpl)appInfo2.getTransientAppMetaData(WEB_BEAN_DEPLOYMENT, DeploymentImpl.class);
                bootstrap.startContainer((Environment)Environments.SERVLET, (org.jboss.webbeans.bootstrap.spi.Deployment)deploymentImpl, (BeanStore)new ConcurrentHashMapBeanStore());
                bootstrap.startInitialization();
                bootstrap.deployBeans();
            }
        } else if (event.is(Deployment.APPLICATION_STARTED)) {
            ApplicationInfo appInfo3 = (ApplicationInfo)event.hook();
            WebBeansBootstrap bootstrap = (WebBeansBootstrap)appInfo3.getTransientAppMetaData(WEB_BEAN_BOOTSTRAP, WebBeansBootstrap.class);
            if (bootstrap != null) {
                bootstrap.validateBeans();
                bootstrap.endInitialization();
            }
        } else if ((event.is(Deployment.APPLICATION_STOPPED) || event.is(Deployment.APPLICATION_UNLOADED)) && (app = (Application)(appInfo = (ApplicationInfo)event.hook()).getMetaData(Application.class)) != null) {
            for (BundleDescriptor next : app.getBundleDescriptors()) {
                if (!(next instanceof EjbBundleDescriptor) && !(next instanceof WebBundleDescriptor)) continue;
                this.bundleToBeanDeploymentArchive.remove(next);
            }
            this.appToBootstrap.remove(app);
        }
    }

    public BeanDeploymentArchive getBeanDeploymentArchiveForBundle(BundleDescriptor bundle) {
        return this.bundleToBeanDeploymentArchive.get(bundle);
    }

    public boolean is299Enabled(BundleDescriptor bundle) {
        return this.bundleToBeanDeploymentArchive.containsKey(bundle);
    }

    public WebBeansBootstrap getBootstrapForApp(Application app) {
        return this.appToBootstrap.get(app);
    }

    protected void generateArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    protected void cleanArtifacts(DeploymentContext dc) throws DeploymentException {
    }

    public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
        return null;
    }

    public WebBeansApplicationContainer load(WebBeansContainer container, DeploymentContext context) {
        WebBundleDescriptor bundle;
        ReadableArchive archive = context.getSource();
        WebBeansBootstrap bootstrap = (WebBeansBootstrap)context.getTransientAppMetaData(WEB_BEAN_BOOTSTRAP, WebBeansBootstrap.class);
        if (null == bootstrap) {
            bootstrap = new WebBeansBootstrap();
            Application app = (Application)context.getModuleMetaData(Application.class);
            this.appToBootstrap.put(app, bootstrap);
        }
        HashSet<EjbDescriptor> ejbs = new HashSet();
        EjbBundleDescriptor ejbBundle = this.getEjbBundleFromContext(context);
        EjbServicesImpl ejbServices = null;
        if (ejbBundle != null) {
            ejbs = ejbBundle.getEjbs();
            ejbServices = new EjbServicesImpl(this.habitat);
        }
        DeploymentImpl deploymentImpl = new DeploymentImpl(archive, ejbs);
        if (ejbBundle != null) {
            deploymentImpl.getServices().add(EjbServices.class, (Service)ejbServices);
        }
        ServletServicesImpl servletServices = new ServletServicesImpl(context);
        deploymentImpl.getServices().add(ServletServices.class, (Service)servletServices);
        TransactionServicesImpl transactionServices = new TransactionServicesImpl(this.habitat);
        deploymentImpl.getServices().add(TransactionServices.class, (Service)transactionServices);
        InjectionManager injectionMgr = (InjectionManager)this.habitat.getByContract(InjectionManager.class);
        InjectionServicesImpl injectionServices = new InjectionServicesImpl(injectionMgr);
        ((BeanDeploymentArchive)deploymentImpl.getBeanDeploymentArchives().iterator().next()).getServices().add(InjectionServices.class, (Service)injectionServices);
        WebBundleDescriptor wDesc = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class);
        if (wDesc != null) {
            wDesc.setExtensionProperty(WEB_BEAN_EXTENSION, "true");
            wDesc.addAppListenerDescriptor(new AppListenerDescriptorImpl(WEB_BEAN_LISTENER));
        }
        Object object = bundle = wDesc != null ? wDesc : ejbBundle;
        if (bundle != null) {
            this.bundleToBeanDeploymentArchive.put((BundleDescriptor)bundle, (BeanDeploymentArchive)deploymentImpl.getBeanDeploymentArchives().iterator().next());
        }
        WebBeansApplicationContainer wbApp = new WebBeansApplicationContainer(bootstrap);
        context.addTransientAppMetaData(WEB_BEAN_BOOTSTRAP, (Object)bootstrap);
        context.addTransientAppMetaData(WEB_BEAN_DEPLOYMENT, (Object)deploymentImpl);
        return wbApp;
    }

    private EjbBundleDescriptor getEjbBundleFromContext(DeploymentContext context) {
        Collection ejbBundles;
        WebBundleDescriptor wDesc;
        EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)context.getModuleMetaData(EjbBundleDescriptor.class);
        if (ejbBundle == null && (wDesc = (WebBundleDescriptor)context.getModuleMetaData(WebBundleDescriptor.class)) != null && (ejbBundles = wDesc.getExtensionsDescriptors(EjbBundleDescriptor.class)).iterator().hasNext()) {
            ejbBundle = (EjbBundleDescriptor)ejbBundles.iterator().next();
        }
        return ejbBundle;
    }
}

