/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.Util;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.HtmlAdaptor;
import org.glassfish.admingui.common.util.MiscUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class CommonHandlers {
    private static final int INDEX = 0;

    public static void initClusterSessionAttribute(HandlerContext handlerCtx) {
        Map<String, Object> sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
        sessionMap.put("appSummaryView", true);
        sessionMap.put("webSummaryView", true);
        sessionMap.put("ejbSummaryView", true);
        sessionMap.put("appclientSummaryView", true);
        sessionMap.put("rarSummaryView", true);
        sessionMap.put("lifecycleSummaryView", true);
        sessionMap.put("adminObjectSummaryView", true);
        sessionMap.put("connectorResSummaryView", true);
        sessionMap.put("customResSummaryView", true);
        sessionMap.put("externalResSummaryView", true);
        sessionMap.put("javaMailSessionSummaryView", true);
        sessionMap.put("jdbcResSummaryView", true);
        sessionMap.put("jmsConnectionSummaryView", true);
        sessionMap.put("jmsDestinationSummaryView", true);
    }

    public static void initSessionAttributes(HandlerContext handlerCtx) {
        Object initialized = FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("_SESSION_INITIALIZED");
        if (initialized == null) {
            GuiUtil.initSessionAttributes();
            if (System.getProperty("html.adaptor.port") != null) {
                HtmlAdaptor.registerHTMLAdaptor(V3AMX.getInstance().getMbeanServerConnection());
            }
        }
    }

    public static void initProductInfoAttributes(HandlerContext handlerCtx) {
        Map<String, Object> sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
        Object initialized = sessionMap.get("_INFO_SESSION_INITIALIZED");
        if (initialized != null) {
            return;
        }
        sessionMap.put("productImageURL", GuiUtil.getMessage("productImage.URL"));
        sessionMap.put("productImageWidth", Integer.parseInt(GuiUtil.getMessage("productImage.width")));
        sessionMap.put("productImageHeight", Integer.parseInt(GuiUtil.getMessage("productImage.height")));
        sessionMap.put("loginProductImageURL", GuiUtil.getMessage("login.productImage.URL"));
        sessionMap.put("loginProductImageWidth", Integer.parseInt(GuiUtil.getMessage("login.productImage.width")));
        sessionMap.put("loginProductImageHeight", Integer.parseInt(GuiUtil.getMessage("login.productImage.height")));
        sessionMap.put("fullProductName", GuiUtil.getMessage("versionImage.description"));
        sessionMap.put("loginButtonTooltip", GuiUtil.getMessage("loginButtonTooltip"));
        sessionMap.put("mastHeadDescription", GuiUtil.getMessage("mastHeadDescription"));
        sessionMap.put("_INFO_SESSION_INITIALIZED", "TRUE");
    }

    public static void getListElement(HandlerContext handlerCtx) {
        List list = (List)handlerCtx.getInputValue("list");
        Integer selectedIndex = (Integer)handlerCtx.getInputValue("index");
        String[] listItem = null;
        if (list != null) {
            if (selectedIndex == null) {
                selectedIndex = new Integer(0);
            }
            listItem = new String[]{(String)list.get(selectedIndex)};
        }
        handlerCtx.setOutputValue("selectedIndex", listItem);
    }

    public static void selectiveEncode(HandlerContext handlerCtx) {
        String value = (String)handlerCtx.getInputValue("value");
        String delim = (String)handlerCtx.getInputValue("delim");
        String encType = (String)handlerCtx.getInputValue("type");
        String encodedString = GuiUtil.encode(value, delim, encType);
        handlerCtx.setOutputValue("result", (Object)encodedString);
    }

    public static void logout(HandlerContext handlerCtx) {
        ExternalContext extContext = handlerCtx.getFacesContext().getExternalContext();
        HttpServletRequest request = (HttpServletRequest)extContext.getRequest();
        request.getSession().invalidate();
    }

    public static void setComponentRequired(HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("id");
        String required = (String)handlerCtx.getInputValue("required");
        UIViewRoot viewRoot = handlerCtx.getFacesContext().getViewRoot();
        if (viewRoot == null) {
            return;
        }
        try {
            UIInput targetComponent = (UIInput)((UIComponent)viewRoot).findComponent(id);
            if (targetComponent != null) {
                targetComponent.setRequired(Boolean.valueOf(required));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void testExists(HandlerContext handlerCtx) {
        String attr = (String)handlerCtx.getInputValue("attr");
        if (GuiUtil.isEmpty(attr)) {
            handlerCtx.setOutputValue("defined", (Object)false);
        } else {
            handlerCtx.setOutputValue("defined", (Object)true);
        }
    }

    public static void getRequestValue(HandlerContext handlerCtx) {
        String key = (String)handlerCtx.getInputValue("key");
        Object defaultValue = handlerCtx.getInputValue("default");
        Object value = handlerCtx.getFacesContext().getExternalContext().getRequestParameterMap().get(key);
        if (value == null || "".equals(value)) {
            value = handlerCtx.getFacesContext().getExternalContext().getRequestMap().get(key);
            if (value == null && defaultValue != null) {
                value = defaultValue;
            }
        } else {
            value = Util.htmlEscape((String)value);
        }
        handlerCtx.setOutputValue("value", value);
    }

    public void longAdd(HandlerContext handlerCtx) {
        Long long1 = (Long)handlerCtx.getInputValue("Long1");
        Long long2 = (Long)handlerCtx.getInputValue("Long2");
        Long result = new Long(long1 + long2);
        handlerCtx.setOutputValue("LongResult", (Object)result);
    }

    public void getCurrentTime(HandlerContext handlerCtx) {
        Date d = new Date(System.currentTimeMillis());
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, handlerCtx.getFacesContext().getViewRoot().getLocale());
        String currentTime = dateFormat.format(d);
        handlerCtx.setOutputValue("CurrentTime", (Object)currentTime);
    }

    public void checkRestart(HandlerContext handlerCtx) {
        List changes = V3AMX.getInstance().getDomainRoot().getExt().getSystemStatus().getRestartRequiredChanges();
        handlerCtx.setOutputValue("RestartRequired", (Object)(changes.size() > 0 ? 1 : 0));
        handlerCtx.setOutputValue("unprocessedChanges", (Object)changes);
    }

    public void testLoginBypass(HandlerContext handlerCtx) {
        String user = V3AMX.getInstance().getRealmsMgr().getAnonymousUser();
        handlerCtx.setOutputValue("byPass", (Object)(user == null ? Boolean.FALSE : Boolean.TRUE));
        handlerCtx.setOutputValue("loginUser", (Object)(user == null ? "" : user));
    }

    public static void setValueExpression(HandlerContext handlerCtx) {
        MiscUtil.setValueExpression((String)handlerCtx.getHandler().getInputValue("expression"), handlerCtx.getInputValue("value"));
    }

    public static void checkSupport(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("supportCluster", (Object)false);
        handlerCtx.setOutputValue("supportHADB", (Object)false);
    }
}

