/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.adapter;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFile;
import com.sun.enterprise.v3.admin.adapter.AdapterState;
import com.sun.enterprise.v3.admin.adapter.AdminConsoleAdapter;
import com.sun.enterprise.v3.server.ApplicationLoaderService;
import com.sun.pkg.client.Image;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InstallerThread
extends Thread {
    private final File ipsRoot;
    private final File warFile;
    private final String proxyHost;
    private final int proxyPort;
    private final Domain domain;
    private final ServerEnvironmentImpl env;
    private final String contextRoot;
    private final AdminConsoleAdapter adapter;
    private final Habitat habitat;
    private final Logger log;
    private final List<String> vss;

    InstallerThread(File ipsRoot, File warFile, String proxyHost, int proxyPort, AdminConsoleAdapter adapter, Habitat habitat, Domain domain, ServerEnvironmentImpl env, String contextRoot, Logger log, List<String> vss) {
        this.ipsRoot = ipsRoot;
        this.warFile = warFile;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.adapter = adapter;
        this.habitat = habitat;
        this.domain = domain;
        this.env = env;
        this.contextRoot = contextRoot;
        this.vss = vss;
        this.log = log;
    }

    @Override
    public void run() {
        try {
            this.download();
            this.expand();
            this.install();
            this.load();
            this.cleanup();
            this.adapter.setInstalling(false);
        }
        catch (Exception ex) {
            this.adapter.setInstalling(false);
            this.adapter.setStateMsg(AdapterState.APPLICATION_NOT_INSTALLED);
            this.log.log(Level.INFO, "Problem while attempting to install admin console!", ex);
        }
    }

    private void download() throws Exception {
        File warFile = this.getWarFile();
        if (warFile.exists()) {
            return;
        }
        this.adapter.setStateMsg(AdapterState.DOWNLOADING);
        Proxy proxy = null;
        if (this.proxyHost != null && !"".equals(this.proxyHost)) {
            InetSocketAddress address = new InetSocketAddress(this.proxyHost, this.proxyPort);
            proxy = new Proxy(Proxy.Type.HTTP, address);
        }
        try {
            Image image = new Image(this.ipsRoot);
            String[] pkgs = new String[]{this.adapter.getIPSPackageName()};
            if (proxy != null) {
                image.setProxy(proxy);
            }
            image.installPackages(pkgs);
            if (this.getWarFile().exists()) {
                this.log.log(Level.SEVERE, "Error in downloading Admin Console from UpdateCenter");
            }
            this.adapter.setDownloadedVersion();
            this.adapter.setStateMsg(AdapterState.DOWNLOADED);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void expand() throws Exception {
        File expFolder;
        File warFile = this.getWarFile();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Expanding the archive: " + warFile.getAbsolutePath());
        }
        if ((expFolder = new File(warFile.getParentFile(), "__admingui")).exists() && new File(expFolder, "WEB-INF").exists()) {
            return;
        }
        this.adapter.setStateMsg(AdapterState.EXPANDING);
        expFolder.mkdirs();
        ZipFile zip = new ZipFile(warFile, expFolder);
        ArrayList list = zip.explode();
        this.adapter.setStateMsg(AdapterState.EXPANDED);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Expanded the archive with :" + list.size() + " entries, at: " + warFile.getParentFile().getAbsolutePath());
        }
    }

    private File getWarFile() {
        return this.warFile;
    }

    private void install() throws Exception {
        if (this.domain.getSystemApplicationReferencedFrom(this.env.getInstanceName(), "__admingui") != null) {
            this.adapter.setStateMsg(AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED);
            this.adapter.updateDeployedVersion();
            return;
        }
        this.adapter.setStateMsg(AdapterState.INSTALLING);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Installing the Admin Console Application...");
        }
        ConfigCode code = new ConfigCode(){

            public Object run(ConfigBeanProxy ... proxies) throws PropertyVetoException, TransactionFailure {
                SystemApplications sa = (SystemApplications)proxies[0];
                Application app = (Application)sa.createChild(Application.class);
                sa.getModules().add(app);
                app.setName("__admingui");
                app.setEnabled(Boolean.TRUE.toString());
                app.setObjectType("system-admin");
                app.setDirectoryDeployed("true");
                app.setContextRoot(InstallerThread.this.contextRoot);
                File warFile = InstallerThread.this.getWarFile();
                try {
                    app.setLocation("${com.sun.aas.installRootURI}/lib/install/applications/__admingui");
                }
                catch (Exception me) {
                    throw new RuntimeException(me);
                }
                Module singleModule = (Module)app.createChild(Module.class);
                app.getModule().add(singleModule);
                singleModule.setName(app.getName());
                Engine webe = (Engine)singleModule.createChild(Engine.class);
                webe.setSniffer("web");
                Engine sece = (Engine)singleModule.createChild(Engine.class);
                sece.setSniffer("security");
                singleModule.getEngines().add(webe);
                singleModule.getEngines().add(sece);
                Server s = (Server)proxies[1];
                List arefs = s.getApplicationRef();
                ApplicationRef aref = (ApplicationRef)s.createChild(ApplicationRef.class);
                aref.setRef(app.getName());
                aref.setEnabled(Boolean.TRUE.toString());
                aref.setVirtualServers(InstallerThread.this.getVirtualServerList());
                arefs.add(aref);
                return true;
            }
        };
        this.adapter.updateDeployedVersion();
        Server server = this.domain.getServerNamed(this.env.getInstanceName());
        ConfigSupport.apply(code, new ConfigBeanProxy[]{this.domain.getSystemApplications(), server});
        this.adapter.setStateMsg(AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Admin Console Application Installed.");
        }
    }

    private String getVirtualServerList() {
        if (this.vss == null) {
            return "";
        }
        String s = Arrays.toString(this.vss.toArray(new String[0]));
        s = s.substring(1, s.length() - 1);
        return s;
    }

    private void load() {
        Application config = this.adapter.getConfig();
        if (config == null) {
            throw new IllegalStateException("Admin Console application has no system app entry!");
        }
        this.adapter.setStateMsg(AdapterState.APPLICATION_LOADING);
        String sn = this.env.getInstanceName();
        ApplicationRef ref = this.domain.getApplicationRefInServer(sn, "__admingui");
        ((ApplicationLoaderService)this.habitat.getComponent(ApplicationLoaderService.class)).processApplication(config, ref, this.log);
        this.adapter.setStateMsg(AdapterState.APPLICATION_LOADED);
    }

    private void cleanup() {
        File backup = new File(this.warFile.getParentFile(), "__admingui.backup");
        if (backup.exists()) {
            this.adapter.setStateMsg(AdapterState.APPLICATION_BACKUP_CLEANING);
            FileUtils.whack((File)backup);
            this.adapter.setStateMsg(AdapterState.APPLICATION_BACKUP_CLEANED);
        }
    }
}

