/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl.monitor;

import com.sun.enterprise.v3.services.impl.monitor.GrizzlyMonitoring;
import com.sun.enterprise.v3.services.impl.monitor.MonitorableWorkerThread;
import com.sun.grizzly.http.StatsThreadPool;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class MonitorableThreadPool
extends StatsThreadPool {
    private final GrizzlyMonitoring monitoring;
    private final String threadPoolMonitoringName;

    public MonitorableThreadPool(GrizzlyMonitoring monitoring, String threadPoolMonitoringName) {
        this.monitoring = monitoring;
        this.threadPoolMonitoringName = threadPoolMonitoringName;
        this.setThreadFactory(new ProbeWorkerThreadFactory());
    }

    public MonitorableThreadPool(GrizzlyMonitoring monitoring, String threadPoolMonitoringName, String threadPoolName, int corePoolSize, int maximumPoolSize, int maxTasksCount, long keepAliveTime, TimeUnit unit) {
        super(threadPoolName, corePoolSize, maximumPoolSize, maxTasksCount, keepAliveTime, unit);
        this.monitoring = monitoring;
        this.threadPoolMonitoringName = threadPoolMonitoringName;
        this.setThreadFactory(new ProbeWorkerThreadFactory());
    }

    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        this.monitoring.getThreadPoolProbeProvider().threadDispatchedFromPoolEvent(this.threadPoolMonitoringName, thread.getName());
    }

    protected void afterExecute(Runnable r, Throwable t) {
        this.monitoring.getThreadPoolProbeProvider().threadReturnedToPoolEvent(this.threadPoolMonitoringName, Thread.currentThread().getName());
        super.afterExecute(r, t);
    }

    public class ProbeWorkerThreadFactory
    implements ThreadFactory {
        public Thread newThread(Runnable r) {
            MonitorableWorkerThread thread = new MonitorableWorkerThread(MonitorableThreadPool.this, r, MonitorableThreadPool.this.name + "-(" + MonitorableThreadPool.this.workerThreadCounter.getAndIncrement() + ")", MonitorableThreadPool.this.initialByteBufferSize, MonitorableThreadPool.this.monitoring);
            MonitorableThreadPool.this.monitoring.getThreadPoolProbeProvider().newThreadsAllocatedEvent(MonitorableThreadPool.this.threadPoolMonitoringName, 1, true);
            return thread;
        }
    }
}

