/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.container.common.spi.WebServiceReferenceManager;
import com.sun.enterprise.deployment.Addressing;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.RespectBinding;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.api.FeatureConstructor;
import com.sun.xml.ws.resources.ModelerMessages;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceFactory;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;
import org.glassfish.webservices.JAXWSServiceDelegate;
import org.glassfish.webservices.ServiceInvocationHandler;
import org.glassfish.webservices.WSContainerResolver;
import org.glassfish.webservices.WebServiceContextImpl;
import org.glassfish.webservices.WsUtil;
import org.jvnet.hk2.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class WebServiceReferenceManagerImpl
implements WebServiceReferenceManager {
    protected Logger logger = LogDomains.getLogger(this.getClass(), (String)"javax.enterprise.webservices");

    public Object getWSContextObject() {
        return new WebServiceContextImpl();
    }

    public Object resolveWSReference(ServiceReferenceDescriptor desc, Context context) throws NamingException {
        Class<?> serviceInterfaceClass = null;
        Object returnObj = null;
        WsUtil wsUtil = new WsUtil();
        try {
            WSContainerResolver.set(desc);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            serviceInterfaceClass = cl.loadClass(desc.getServiceInterface());
            this.resolvePortComponentLinks(desc);
            javax.xml.rpc.Service serviceDelegate = null;
            Object jaxwsDelegate = null;
            Object injValue = null;
            if (desc.hasGeneratedServiceInterface() || desc.hasWsdlFile()) {
                String serviceImplName = desc.getServiceImplClassName();
                if (serviceImplName != null) {
                    Class<?> serviceImplClass = cl.loadClass(serviceImplName);
                    serviceDelegate = (javax.xml.rpc.Service)serviceImplClass.newInstance();
                } else {
                    if (javax.xml.ws.Service.class.isAssignableFrom(serviceInterfaceClass) && !javax.xml.ws.Service.class.equals(serviceInterfaceClass)) {
                        injValue = this.initiateInstance(serviceInterfaceClass, desc);
                    } else if (desc.isInjectable()) {
                        Class<?> targetClass;
                        InjectionTarget target = (InjectionTarget)desc.getInjectionTargets().iterator().next();
                        Class<?> serviceType = null;
                        if (target.isFieldInjectable()) {
                            Field f = target.getField();
                            if (f == null) {
                                String fName = target.getFieldName();
                                targetClass = cl.loadClass(target.getClassName());
                                try {
                                    f = targetClass.getDeclaredField(target.getFieldName());
                                }
                                catch (NoSuchFieldException nsfe) {
                                    // empty catch block
                                }
                            }
                            serviceType = f.getType();
                        }
                        if (target.isMethodInjectable()) {
                            Method m = target.getMethod();
                            if (m == null) {
                                String mName = target.getMethodName();
                                targetClass = cl.loadClass(target.getClassName());
                                try {
                                    m = targetClass.getDeclaredMethod(target.getMethodName(), new Class[0]);
                                }
                                catch (NoSuchMethodException nsfe) {
                                    // empty catch block
                                }
                            }
                            if (m.getParameterTypes().length == 1) {
                                serviceType = m.getParameterTypes()[0];
                            }
                        }
                        if (serviceType != null) {
                            Class<?> loadedSvcClass = cl.loadClass(serviceType.getCanonicalName());
                            injValue = this.initiateInstance(loadedSvcClass, desc);
                        }
                    }
                    if (injValue == null) {
                        javax.xml.ws.Service svc = javax.xml.ws.Service.create((URL)new WsUtil().privilegedGetServiceRefWsdl(desc), (QName)desc.getServiceName());
                        jaxwsDelegate = new JAXWSServiceDelegate(desc, svc, cl);
                    }
                }
                if (desc.hasHandlers()) {
                    javax.xml.rpc.Service configuredService = wsUtil.createConfiguredService(desc);
                    Iterator ports = configuredService.getPorts();
                    wsUtil.configureHandlerChain(desc, serviceDelegate, ports, cl);
                }
                if (javax.xml.ws.Service.class.isAssignableFrom(serviceInterfaceClass)) {
                    Object service;
                    Object object = service = injValue != null ? (javax.xml.ws.Service)injValue : jaxwsDelegate;
                    if (service != null) {
                        wsUtil.configureJAXWSClientHandlers((javax.xml.ws.Service)service, desc);
                    }
                    if (injValue != null && desc.getInjectionTargetType() != null) {
                        Class<?> requestedPortType = service.getClass().getClassLoader().loadClass(desc.getInjectionTargetType());
                        ArrayList<WebServiceFeature> wsFeatures = this.getWebServiceFeatures(desc);
                        injValue = wsFeatures.size() > 0 ? service.getPort(requestedPortType, wsFeatures.toArray(new WebServiceFeature[0])) : service.getPort(requestedPortType);
                    }
                }
            } else {
                QName serviceName = desc.getServiceName();
                if (serviceName == null) {
                    serviceName = new QName("urn:noservice", "servicename");
                }
                ServiceFactory serviceFac = ServiceFactory.newInstance();
                serviceDelegate = serviceFac.createService(serviceName);
            }
            ServiceInvocationHandler handler = null;
            if (serviceDelegate != null) {
                handler = new ServiceInvocationHandler(desc, serviceDelegate, cl);
                returnObj = Proxy.newProxyInstance(cl, new Class[]{serviceInterfaceClass}, (InvocationHandler)handler);
            } else if (jaxwsDelegate != null) {
                returnObj = jaxwsDelegate;
            } else if (injValue != null) {
                returnObj = injValue;
            }
        }
        catch (PrivilegedActionException pae) {
            this.logger.log(Level.WARNING, "", pae);
            NamingException ne = new NamingException();
            ne.initCause(pae.getCause());
            throw ne;
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "", e);
            NamingException ne = new NamingException();
            ne.initCause(e);
            throw ne;
        }
        finally {
            WSContainerResolver.unset();
        }
        return returnObj;
    }

    private Object initiateInstance(Class svcClass, ServiceReferenceDescriptor desc) throws Exception {
        WsUtil wsu = new WsUtil();
        URL wsdlFile = wsu.privilegedGetServiceRefWsdl(desc);
        if (desc.getBundleDescriptor().getApplication() != null) {
            String genXmlDir = desc.getBundleDescriptor().getApplication().getGeneratedXMLDirectory();
            if (!desc.getBundleDescriptor().getApplication().isVirtual()) {
                String subDirName = desc.getBundleDescriptor().getModuleDescriptor().getArchiveUri();
                genXmlDir = genXmlDir + File.separator + subDirName.replaceAll("\\.", "_");
            }
        } else {
            String genXmlDir = desc.getBundleDescriptor().getModuleDescriptor().getArchiveUri();
        }
        Object obj = null;
        Constructor cons = svcClass.getConstructor(URL.class, QName.class);
        obj = cons.newInstance(wsdlFile, desc.getServiceName());
        return obj;
    }

    private ArrayList<WebServiceFeature> getWebServiceFeatures(ServiceReferenceDescriptor desc) {
        RespectBinding rb;
        Addressing add;
        ArrayList<WebServiceFeature> wsFeatures = new ArrayList<WebServiceFeature>();
        if (desc.isMtomEnabled()) {
            wsFeatures.add((WebServiceFeature)new MTOMFeature(true, desc.getMtomThreshold()));
        }
        if ((add = desc.getAddressing()) != null) {
            wsFeatures.add((WebServiceFeature)new AddressingFeature(add.isEnabled(), add.isRequired(), this.getResponse(add.getResponses())));
        }
        if ((rb = desc.getRespectBinding()) != null) {
            wsFeatures.add((WebServiceFeature)new RespectBindingFeature(rb.isEnabled()));
        }
        Map otherAnnotations = desc.getOtherAnnotations();
        Iterator it = otherAnnotations.values().iterator();
        while (it.hasNext()) {
            wsFeatures.add(this.getWebServiceFeatureBean((Annotation)it.next()));
        }
        return wsFeatures;
    }

    private AddressingFeature.Responses getResponse(String s) {
        if (s != null) {
            return (AddressingFeature.Responses)AddressingFeature.Responses.valueOf(AddressingFeature.Responses.class, (String)s);
        }
        return AddressingFeature.Responses.ALL;
    }

    private void resolvePortComponentLinks(ServiceReferenceDescriptor desc) throws Exception {
        for (ServiceRefPortInfo portInfo : desc.getPortsInfo()) {
            if (!portInfo.isLinkedToPortComponent()) continue;
            WebServiceEndpoint linkedPortComponent = portInfo.getPortComponentLink();
            if (portInfo.hasWsdlPort()) continue;
            portInfo.setWsdlPort(linkedPortComponent.getWsdlPort());
        }
    }

    private WebServiceFeature getWebServiceFeatureBean(Annotation a) {
        WebServiceFeature bean;
        WebServiceFeatureAnnotation wsfa = a.annotationType().getAnnotation(WebServiceFeatureAnnotation.class);
        Class beanClass = wsfa.bean();
        Constructor<?> ftrCtr = null;
        String[] paramNames = null;
        for (Constructor<?> con : beanClass.getConstructors()) {
            FeatureConstructor ftrCtrAnn = con.getAnnotation(FeatureConstructor.class);
            if (ftrCtrAnn == null) continue;
            if (ftrCtr == null) {
                ftrCtr = con;
                paramNames = ftrCtrAnn.value();
                continue;
            }
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_MORETHANONE_FTRCONSTRUCTOR((Object)a, (Object)beanClass));
        }
        if (ftrCtr == null) {
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_NO_FTRCONSTRUCTOR((Object)a, (Object)beanClass));
        }
        if (ftrCtr.getParameterTypes().length != paramNames.length) {
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_ILLEGAL_FTRCONSTRUCTOR((Object)a, (Object)beanClass));
        }
        try {
            Object[] params = new Object[paramNames.length];
            for (int i = 0; i < paramNames.length; ++i) {
                Method m = a.annotationType().getDeclaredMethod(paramNames[i], new Class[0]);
                params[i] = m.invoke((Object)a, new Object[0]);
            }
            bean = (WebServiceFeature)ftrCtr.newInstance(params);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        return bean;
    }
}

