/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.ExtensionModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.Mbean;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import com.sun.enterprise.config.serverbeans.WebModule;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
public class UpgradeService
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Domain domain;
    private static final String MODULE_TYPE = "moduleType";

    public void postConstruct() {
        this.upgradeApplicationElements();
    }

    private void upgradeApplicationElements() {
        this.upgradeV2ApplicationElements();
        this.upgradeV3PreludeApplicationElements();
    }

    private void upgradeV3PreludeApplicationElements() {
        for (Application app : this.domain.getApplications().getModules(Application.class)) {
            if (app.getEngine() == null || app.getEngine().size() <= 0 || app.getModule() != null && app.getModule().size() != 0) continue;
            try {
                ConfigSupport.apply(new SingleConfigCode<Application>(){

                    @Override
                    public Object run(Application application) throws PropertyVetoException, TransactionFailure {
                        Module module = application.createChild(Module.class);
                        module.setName(application.getName());
                        for (Engine engine : application.getEngine()) {
                            module.getEngines().add(engine);
                        }
                        application.getModule().add(module);
                        application.getEngine().clear();
                        return null;
                    }
                }, app);
            }
            catch (TransactionFailure tf) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading application " + app.getName() + " please redeploy", tf);
                throw new RuntimeException(tf);
            }
        }
    }

    private void upgradeV2ApplicationElements() {
        Applications apps = this.domain.getApplications();
        Server server = this.domain.getServerNamed("server");
        SystemApplications sApps = this.domain.getSystemApplications();
        if (sApps != null && sApps.getModules().size() > 0) {
            return;
        }
        try {
            ConfigSupport.apply(new ConfigCode(){

                public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                    Property prop2;
                    Property prop;
                    Property prop3;
                    Application app;
                    Applications applications = (Applications)params[0];
                    Server servr = (Server)params[1];
                    Domain dom = (Domain)params[2];
                    for (ConnectorModule connectorModule : applications.getModules(ConnectorModule.class)) {
                        app = applications.createChild(Application.class);
                        app.setName(connectorModule.getName());
                        app.setLocation(UpgradeService.this.getLocationAsURIString(connectorModule.getLocation()));
                        app.setObjectType(connectorModule.getObjectType());
                        app.setDescription(connectorModule.getDescription());
                        app.setEnabled(connectorModule.getEnabled());
                        app.setDirectoryDeployed(connectorModule.getDirectoryDeployed());
                        for (Property property : connectorModule.getProperty()) {
                            prop3 = app.createChild(Property.class);
                            prop3.setName(property.getName());
                            prop3.setValue(property.getValue());
                            app.getProperty().add(prop3);
                        }
                        prop = app.createChild(Property.class);
                        prop.setName(UpgradeService.MODULE_TYPE);
                        prop.setValue("connector-module");
                        app.getProperty().add(prop);
                        applications.getModules().remove(connectorModule);
                        applications.getModules().add(app);
                    }
                    for (EjbModule ejbModule : applications.getModules(EjbModule.class)) {
                        app = applications.createChild(Application.class);
                        app.setName(ejbModule.getName());
                        app.setLocation(UpgradeService.this.getLocationAsURIString(ejbModule.getLocation()));
                        app.setObjectType(ejbModule.getObjectType());
                        app.setDescription(ejbModule.getDescription());
                        app.setEnabled(ejbModule.getEnabled());
                        app.setDirectoryDeployed(ejbModule.getDirectoryDeployed());
                        app.setLibraries(ejbModule.getLibraries());
                        app.setAvailabilityEnabled(ejbModule.getAvailabilityEnabled());
                        for (Property property : ejbModule.getProperty()) {
                            prop3 = app.createChild(Property.class);
                            prop3.setName(property.getName());
                            prop3.setValue(property.getValue());
                            app.getProperty().add(prop3);
                        }
                        prop = app.createChild(Property.class);
                        prop.setName(UpgradeService.MODULE_TYPE);
                        prop.setValue("ejb-module");
                        app.getProperty().add(prop);
                        applications.getModules().remove(ejbModule);
                        applications.getModules().add(app);
                    }
                    for (WebModule webModule : applications.getModules(WebModule.class)) {
                        app = applications.createChild(Application.class);
                        app.setName(webModule.getName());
                        app.setLocation(UpgradeService.this.getLocationAsURIString(webModule.getLocation()));
                        app.setObjectType(webModule.getObjectType());
                        app.setDescription(webModule.getDescription());
                        app.setEnabled(webModule.getEnabled());
                        app.setDirectoryDeployed(webModule.getDirectoryDeployed());
                        app.setLibraries(webModule.getLibraries());
                        app.setContextRoot(webModule.getContextRoot());
                        app.setAvailabilityEnabled(webModule.getAvailabilityEnabled());
                        for (Property property : webModule.getProperty()) {
                            prop3 = app.createChild(Property.class);
                            prop3.setName(property.getName());
                            prop3.setValue(property.getValue());
                            app.getProperty().add(prop3);
                        }
                        prop = app.createChild(Property.class);
                        prop.setName(UpgradeService.MODULE_TYPE);
                        prop.setValue("web-module");
                        app.getProperty().add(prop);
                        applications.getModules().remove(webModule);
                        applications.getModules().add(app);
                    }
                    for (AppclientModule appclientModule : applications.getModules(AppclientModule.class)) {
                        app = applications.createChild(Application.class);
                        app.setName(appclientModule.getName());
                        app.setLocation(UpgradeService.this.getLocationAsURIString(appclientModule.getLocation()));
                        app.setObjectType("user");
                        app.setDescription(appclientModule.getDescription());
                        app.setEnabled("true");
                        app.setDirectoryDeployed(appclientModule.getDirectoryDeployed());
                        for (Property property : appclientModule.getProperty()) {
                            prop3 = app.createChild(Property.class);
                            prop3.setName(property.getName());
                            prop3.setValue(property.getValue());
                            app.getProperty().add(prop3);
                        }
                        prop = app.createChild(Property.class);
                        prop.setName("java-web-start-enabled");
                        prop.setValue(appclientModule.getJavaWebStartEnabled());
                        app.getProperty().add(prop);
                        prop2 = app.createChild(Property.class);
                        prop2.setName(UpgradeService.MODULE_TYPE);
                        prop2.setValue("appclient-module");
                        app.getProperty().add(prop2);
                        applications.getModules().remove(appclientModule);
                        applications.getModules().add(app);
                    }
                    for (J2eeApplication j2eeApp : applications.getModules(J2eeApplication.class)) {
                        app = applications.createChild(Application.class);
                        app.setName(j2eeApp.getName());
                        app.setLocation(UpgradeService.this.getLocationAsURIString(j2eeApp.getLocation()));
                        app.setObjectType(j2eeApp.getObjectType());
                        app.setDescription(j2eeApp.getDescription());
                        app.setEnabled(j2eeApp.getEnabled());
                        app.setDirectoryDeployed(j2eeApp.getDirectoryDeployed());
                        app.setLibraries(j2eeApp.getLibraries());
                        app.setAvailabilityEnabled(j2eeApp.getAvailabilityEnabled());
                        for (Property property : j2eeApp.getProperty()) {
                            prop3 = app.createChild(Property.class);
                            prop3.setName(property.getName());
                            prop3.setValue(property.getValue());
                            app.getProperty().add(prop3);
                        }
                        prop = app.createChild(Property.class);
                        prop.setName("java-web-start-enabled");
                        prop.setValue(j2eeApp.getJavaWebStartEnabled());
                        app.getProperty().add(prop);
                        prop2 = app.createChild(Property.class);
                        prop2.setName(UpgradeService.MODULE_TYPE);
                        prop2.setValue("j2ee-application");
                        app.getProperty().add(prop2);
                        applications.getModules().remove(j2eeApp);
                        applications.getModules().add(app);
                    }
                    if (applications.getModules(ExtensionModule.class).size() > 0) {
                        Logger.getAnonymousLogger().log(Level.WARNING, "Ignoring extension-module elements. GlassFish v3 does not support extension modules from GlassFish v2.");
                    }
                    for (ExtensionModule extensionModule : applications.getModules(ExtensionModule.class)) {
                        applications.getModules().remove(extensionModule);
                    }
                    for (LifecycleModule lifecycleModule : applications.getModules(LifecycleModule.class)) {
                        app = applications.createChild(Application.class);
                        app.setName(lifecycleModule.getName());
                        app.setObjectType(lifecycleModule.getObjectType());
                        app.setDescription(lifecycleModule.getDescription());
                        app.setEnabled(lifecycleModule.getEnabled());
                        for (Property property : lifecycleModule.getProperty()) {
                            prop3 = app.createChild(Property.class);
                            prop3.setName(property.getName());
                            prop3.setValue(property.getValue());
                            app.getProperty().add(prop3);
                        }
                        prop = app.createChild(Property.class);
                        prop.setName("class-name");
                        prop.setValue(lifecycleModule.getClassName());
                        app.getProperty().add(prop);
                        if (lifecycleModule.getClasspath() != null) {
                            Property prop1 = app.createChild(Property.class);
                            prop1.setName("classpath");
                            prop1.setValue(lifecycleModule.getClasspath());
                            app.getProperty().add(prop1);
                        }
                        if (lifecycleModule.getLoadOrder() != null) {
                            prop2 = app.createChild(Property.class);
                            prop2.setName("load-order");
                            prop2.setValue(lifecycleModule.getLoadOrder());
                            app.getProperty().add(prop2);
                        }
                        Property prop32 = app.createChild(Property.class);
                        prop32.setName("is-failure-fatal");
                        prop32.setValue(lifecycleModule.getIsFailureFatal());
                        app.getProperty().add(prop32);
                        Property prop4 = app.createChild(Property.class);
                        prop4.setName("isLifecycle");
                        prop4.setValue("true");
                        app.getProperty().add(prop4);
                        applications.getModules().remove(lifecycleModule);
                        applications.getModules().add(app);
                    }
                    if (applications.getModules(Mbean.class).size() > 0) {
                        Logger.getAnonymousLogger().log(Level.WARNING, "Ignoring mbean elements. GlassFish v3 does not support custom MBeans from GlassFish v2.");
                    }
                    for (Mbean mbean : applications.getModules(Mbean.class)) {
                        applications.getModules().remove(mbean);
                    }
                    for (Application application : applications.getModules(Application.class)) {
                        if (!application.getObjectType().startsWith("system-")) continue;
                        applications.getModules().remove(application);
                        ApplicationRef appRef = servr.getApplicationRef(application.getName());
                        if (appRef == null) continue;
                        servr.getApplicationRef().remove(appRef);
                    }
                    SystemApplications systemApps = dom.createChild(SystemApplications.class);
                    dom.setSystemApplications(systemApps);
                    return null;
                }
            }, apps, server, this.domain);
        }
        catch (TransactionFailure tf) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Failure while upgrading application", tf);
            throw new RuntimeException(tf);
        }
    }

    private String getLocationAsURIString(String location) {
        File appFile = new File(location);
        return appFile.toURI().toString();
    }
}

