/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.connectors.admin.cli.ConnectorConnectionPoolManager;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="create-connector-connection-pool")
@Scoped(value=PerLookup.class)
@I18n(value="create.connector.connection.pool")
public class CreateConnectorConnectionPool
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateConnectorConnectionPool.class);
    @Param(name="raname")
    String raname;
    @Param(name="connectiondefinition")
    String connectiondefinition;
    @Param(name="steadypoolsize", optional=true)
    String steadypoolsize = "8";
    @Param(name="maxpoolsize", optional=true)
    String maxpoolsize = "32";
    @Param(name="maxwait", optional=true)
    String maxwait = "60000";
    @Param(name="poolresize", optional=true)
    String poolresize = "2";
    @Param(name="idletimeout", optional=true)
    String idletimeout = "300";
    @Param(name="isconnectvalidatereq", optional=true, defaultValue="false")
    Boolean isconnectvalidatereq;
    @Param(name="failconnection", optional=true, defaultValue="false")
    Boolean failconnection;
    @Param(name="leaktimeout", optional=true)
    String leaktimeout = "0";
    @Param(name="leakreclaim", optional=true, defaultValue="false")
    Boolean leakreclaim;
    @Param(name="creationretryattempts", optional=true)
    String creationretryattempts = "0";
    @Param(name="creationretryinterval", optional=true)
    String creationretryinterval = "10";
    @Param(name="lazyconnectionenlistment", optional=true, defaultValue="false")
    Boolean lazyconnectionenlistment;
    @Param(name="lazyconnectionassociation", optional=true, defaultValue="false")
    Boolean lazyconnectionassociation;
    @Param(name="associatewiththread", optional=true, defaultValue="false")
    Boolean associatewiththread;
    @Param(name="matchconnections", optional=true, defaultValue="false")
    Boolean matchconnections;
    @Param(name="maxconnectionusagecount", optional=true)
    String maxconnectionusagecount = "0";
    @Param(name="validateatmostonceperiod", optional=true)
    String validateatmostonceperiod;
    @Param(name="transactionsupport", acceptableValues="XATransaction,LocalTransaction,NoTransaction", optional=true)
    String transactionsupport;
    @Param(name="description", optional=true)
    String description;
    @Param(name="property", optional=true, separator=58)
    Properties properties;
    @Param(optional=true)
    String target = "server";
    @Param(name="poolname", primary=true)
    String poolname;
    @Inject
    Resources resources;
    @Inject
    Domain domain;
    @Inject
    private Habitat habitat;

    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        HashMap<String, String> attrList = new HashMap<String, String>();
        attrList.put("resource-adapter-name", this.raname);
        attrList.put("connection-definition-name", this.connectiondefinition);
        attrList.put("description", this.description);
        attrList.put("steady-pool-size", this.steadypoolsize);
        attrList.put("max-pool-size", this.maxpoolsize);
        attrList.put("max-wait-time-in-millis", this.maxwait);
        attrList.put("pool-resize-quantity", this.poolresize);
        attrList.put("idle-timeout-in-seconds", this.idletimeout);
        attrList.put("is-connection-validation-required", this.isconnectvalidatereq.toString());
        attrList.put("fail-all-connections", this.failconnection.toString());
        attrList.put("validate-atmost-once-period-in-seconds", this.validateatmostonceperiod);
        attrList.put("connection-leak-timeout-in-seconds", this.leaktimeout);
        attrList.put("connection-leak-reclaim", this.leakreclaim.toString());
        attrList.put("connection-creation-retry-attempts", this.creationretryattempts);
        attrList.put("connection-creation-retry-interval-in-seconds", this.creationretryinterval);
        attrList.put("lazy-connection-association", this.lazyconnectionassociation.toString());
        attrList.put("lazy-connection-enlistment", this.lazyconnectionenlistment.toString());
        attrList.put("associate-with-thread", this.associatewiththread.toString());
        attrList.put("match-connections", this.matchconnections.toString());
        attrList.put("max-connection-usage-count", this.maxconnectionusagecount);
        attrList.put("name", this.poolname);
        try {
            ConnectorConnectionPoolManager connPoolMgr = this.habitat.getComponent(ConnectorConnectionPoolManager.class);
            rs = connPoolMgr.create(this.resources, attrList, this.properties, targetServer);
        }
        catch (Exception e) {
            Logger.getLogger(CreateConnectorConnectionPool.class.getName()).log(Level.SEVERE, "Unable to create connector connection pool " + this.poolname, e);
            String def = "Connector connection pool: {0} could not be created, reason: {1}";
            report.setMessage(localStrings.getLocalString("create.connector.connection.pool.fail", def, new Object[]{this.poolname}) + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getMessage() != null) {
                report.setMessage(rs.getMessage());
            } else {
                report.setMessage(localStrings.getLocalString("create.connector.connection.pool.fail", "Connector connection pool {0} creation failed", new Object[]{this.poolname, ""}));
            }
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        report.setActionExitCode(ec);
    }
}

