/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone;

import com.sun.grizzly.standalone.RailsSelectorThread;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.ClassLoaderUtil;
import java.io.File;
import java.io.IOException;

public class JRuby {
    private static final String SELECTOR_THREAD = "com.sun.grizzly.selectorThread";
    private static final String ADAPTER = "com.sun.grizzly.adapterClass";
    private static int port = 3000;
    private static String folder = "/public";
    private static int numberOfRuntime = 1;

    public static void main(String[] args) throws IOException, InstantiationException {
        StaticResourcesAdapter adapter;
        String adapterClass;
        if (args.length == 0) {
            JRuby.printHelpAndExit();
        }
        for (int i = 0; i < args.length - 1; ++i) {
            String num;
            String arg = args[i];
            if ("-h".equals(arg) || "--help".equals(arg)) {
                JRuby.printHelpAndExit();
                continue;
            }
            if ("-n".equals(arg)) {
                JRuby.setNumberOfRuntimes(args[++i]);
                continue;
            }
            if (arg.startsWith("--num-runtimes=")) {
                num = arg.substring("--num-runtimes=".length(), arg.length());
                JRuby.setNumberOfRuntimes(num);
                continue;
            }
            if ("-p".equals(arg)) {
                JRuby.setPort(args[++i]);
                continue;
            }
            if (!arg.startsWith("--port=")) continue;
            num = arg.substring("--port=".length(), arg.length());
            JRuby.setPort(num);
        }
        String railsRoot = args[args.length - 1];
        if (!new File(railsRoot).isDirectory()) {
            System.err.println("Illegal Rails root");
            JRuby.printHelpAndExit();
        }
        if (new File("lib").exists()) {
            Thread.currentThread().setContextClassLoader(ClassLoaderUtil.createClassloader((File)new File("lib"), (ClassLoader)JRuby.class.getClassLoader()));
        }
        RailsSelectorThread selectorThread = null;
        String selectorThreadClassname = System.getProperty(SELECTOR_THREAD);
        selectorThread = selectorThreadClassname != null ? (RailsSelectorThread)((Object)JRuby.loadInstance(selectorThreadClassname)) : new RailsSelectorThread();
        String applicationRoot = railsRoot + folder;
        selectorThread.setDisplayConfiguration(true);
        selectorThread.setRailsRoot(railsRoot);
        RailsSelectorThread.setWebAppRootPath((String)applicationRoot);
        selectorThread.setPort(port);
        selectorThread.setNumberOfRuntime(numberOfRuntime);
        String rdebug = System.getProperty("glassfish.rdebug");
        if (rdebug != null && rdebug.length() > 0) {
            selectorThread.setKeepAliveTimeoutInSeconds(-1);
        }
        if ((adapterClass = System.getProperty(ADAPTER)) == null) {
            adapter = new StaticResourcesAdapter();
            adapter.setRootFolder(folder);
        } else {
            adapter = (Adapter)JRuby.loadInstance(adapterClass);
        }
        selectorThread.setAdapter((Adapter)adapter);
        selectorThread.initEndpoint();
        selectorThread.startEndpoint();
    }

    private static Object loadInstance(String property) {
        Class<?> className = null;
        try {
            className = Class.forName(property, true, Thread.currentThread().getContextClassLoader());
            return className.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static void setNumberOfRuntimes(String num) {
        try {
            numberOfRuntime = Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            System.err.println("Illegal number -- " + num);
            JRuby.printHelpAndExit();
        }
    }

    private static void setPort(String num) {
        try {
            port = Integer.parseInt(num);
        }
        catch (NumberFormatException e) {
            System.err.println("Illegal port number -- " + num);
            JRuby.printHelpAndExit();
        }
    }

    private static void printHelpAndExit() {
        System.err.println("Usage: " + JRuby.class.getCanonicalName() + " [options] RAILS_ROOT");
        System.err.println();
        System.err.println("    -p, --port=port                  Runs Rails on the specified port.");
        System.err.println("                                     Default: 3000");
        System.err.println("    -n, --num-runtimes=num           Specifies number of JRuby runtimes.");
        System.err.println("                                     Default: 1");
        System.err.println("    -h, --help                       Show this help message.");
        System.exit(1);
    }
}

