/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.JmsService;
import org.glassfish.api.Startup;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class JmsProviderLifecycle
implements Startup,
PostConstruct {
    private static final String JMS_EAGER_STARTUP = "org.glassfish.jms.EagerStartup";
    public static final String EMBEDDED = "EMBEDDED";
    public static final String LOCAL = "LOCAL";
    public static final String REMOTE = "REMOTE";
    public static final String JMS_SERVICE = "jms-service";
    @Inject
    Habitat habitat;

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void postConstruct() {
        if (this.eagerStartupRequired()) {
            try {
                String module = "jmsra";
                String loc = ConnectorsUtil.getSystemModuleLocation(module);
                ConnectorRuntime connectorRuntime = (ConnectorRuntime)this.habitat.getComponent(ConnectorRuntime.class);
                connectorRuntime.createActiveResourceAdapter(loc, module, null);
            }
            catch (ConnectorRuntimeException e) {
                e.printStackTrace();
                e.printStackTrace();
            }
        }
    }

    private boolean eagerStartupRequired() {
        String integrationMode = this.getJmsService().getType();
        if (REMOTE.equals(integrationMode)) {
            return false;
        }
        String jmsEagerStartup = System.getProperty(JMS_EAGER_STARTUP);
        if (EMBEDDED.equals(integrationMode) && (jmsEagerStartup == null || "".equals(jmsEagerStartup) || "false".equals(jmsEagerStartup))) {
            return false;
        }
        if (LOCAL.equals(integrationMode) && "false".equals(jmsEagerStartup)) {
            return false;
        }
        return LOCAL.equals(integrationMode);
    }

    private JmsService getJmsService() {
        return (JmsService)this.habitat.getComponent(JmsService.class);
    }
}

