/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import com.sun.enterprise.tools.upgrade.common.SourceAppSrvObj;
import com.sun.enterprise.tools.upgrade.common.TargetAppSrvObj;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;

public class CommonInfoModel {
    private static final StringManager stringManager = StringManager.getManager(CommonInfoModel.class);
    private static final Logger logger = LogService.getLogger();
    private static final CommonInfoModel instance = new CommonInfoModel();
    private TargetAppSrvObj tAppSrvObj = new TargetAppSrvObj();
    private SourceAppSrvObj sAppSrvObj = new SourceAppSrvObj();
    private boolean nopromptMode = false;
    private boolean alreadyCloned = false;

    private CommonInfoModel() {
    }

    public static CommonInfoModel getInstance() {
        return instance;
    }

    public SourceAppSrvObj getSource() {
        return this.sAppSrvObj;
    }

    public TargetAppSrvObj getTarget() {
        return this.tAppSrvObj;
    }

    public void setupTasks() throws Exception {
        String domainName = this.sAppSrvObj.getDomainName();
        this.tAppSrvObj.setDomainName(domainName);
        if (!this.alreadyCloned) {
            UpgradeUtils.getUpgradeUtils(this).cloneDomain(this.sAppSrvObj.getInstallDir(), this.tAppSrvObj.getDomainDir());
        } else {
            this.alreadyCloned = false;
        }
    }

    public boolean isNoprompt() {
        return this.nopromptMode;
    }

    public void setNoprompt(boolean flag) {
        this.nopromptMode = flag;
    }

    public void setAlreadyCloned(boolean alreadyCloned) {
        this.alreadyCloned = alreadyCloned;
    }

    public boolean isUpgradeSupported() {
        boolean retVal = true;
        String sourceVersion = this.sAppSrvObj.getVersion();
        String targetVersion = this.tAppSrvObj.getVersion();
        if (!sourceVersion.equals("9.1") && !sourceVersion.equals("3.0")) {
            logger.info(stringManager.getString("upgrade.common.upgrade_not_supported", sourceVersion, this.sAppSrvObj.getEdition(), targetVersion, this.tAppSrvObj.getEdition()));
            retVal = false;
        }
        return retVal;
    }
}

