/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx.log;

import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import com.sun.messaging.bridge.service.jms.tx.log.TxLog;
import com.sun.messaging.jmq.util.timer.WakeupableTimer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

class TransactionReaper
implements Runnable {
    private TxLog _txlog = null;
    private Logger _logger = null;
    private Vector removes = new Vector();
    private WakeupableTimer reapTimer = null;
    private int _reapLimit = 1;
    private long _reapInterval = 1000L;

    public TransactionReaper(TxLog txLog, int n, int n2) {
        this._txlog = txLog;
        this._logger = this._txlog.getLogger();
        this._reapLimit = n;
        if (this._reapInterval <= 0L) {
            this._reapInterval = 60L;
        }
        this._reapInterval = n2 * 1000;
    }

    public void addTransaction(GlobalXid globalXid) {
        this.removes.add(globalXid);
        this.createTimer();
        if (this.removes.size() > this._reapLimit) {
            this.reapTimer.wakeup();
        }
    }

    private synchronized void createTimer() {
        if (this.reapTimer == null) {
            try {
                String string = "Transaction reaper thread has started for TM " + this._txlog.getTMName();
                String string2 = "Transaction reaper thread for TM " + this._txlog.getTMName() + " is exiting";
                this.reapTimer = new WakeupableTimer("JMSBridgeTMTransactionReaper-" + this._txlog.getTMName(), this, this._reapInterval, this._reapInterval, string, string2, this._logger);
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, "Unable to start transaction reaper thread for TM " + this._txlog.getTMName(), exception);
            }
        }
    }

    public synchronized void destroy() {
        if (this.reapTimer != null) {
            this.reapTimer.cancel();
            this.reapTimer = null;
        }
        this.removes.clear();
    }

    public void run() {
        GlobalXid[] globalXidArray = this.removes.toArray(new GlobalXid[0]);
        int n = globalXidArray.length - this._reapLimit;
        for (int i = 0; i < n; ++i) {
            String string = globalXidArray[i].toString();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Cleaning up global transaction " + string);
            }
            try {
                this._txlog.reap(string);
                this.removes.remove(globalXidArray[i]);
                continue;
            }
            catch (Exception exception) {
                this._logger.log(Level.WARNING, "Failed to cleanup global transaction " + string, exception);
            }
        }
    }
}

