/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ASMain;
import com.sun.enterprise.glassfish.bootstrap.ASMainNonOSGi;
import com.sun.enterprise.glassfish.bootstrap.MaskingClassLoader;
import com.sun.enterprise.glassfish.bootstrap.Rejar;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.ArgumentManager;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.single.SingleModulesRegistry;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import com.sun.hk2.component.InhabitantsParser;
import com.sun.hk2.component.InhabitantsParserDecorator;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMainStatic
extends ASMainNonOSGi {
    private File out;
    private Habitat habitat;

    @Override
    protected String getPreferedCacheDir() {
        return "static-cache/gf/";
    }

    @Override
    public String getName() {
        return ASMain.Platform.Static.toString();
    }

    @Override
    public <T> T getStartedService(Class<T> serviceType) {
        if (this.habitat != null) {
            return this.habitat.getComponent(serviceType);
        }
        return null;
    }

    @Override
    protected void setUpCache(File sourceDir, File cacheDir) throws IOException {
    }

    @Override
    public void run(final Logger logger, String ... args) throws Exception {
        super.run(logger, args);
        StartupContext sc = this.getContext(StartupContext.class);
        if (sc == null) {
            Properties p = ArgumentManager.argsToMap(args);
            for (String arg : args) {
                if (!arg.equals("-upgrade")) continue;
                p.put("hk2.startup.context.moduleStartup", "upgrade");
            }
            sc = new StartupContext(this.findBootstrapFile().getParentFile().getParentFile(), p);
        }
        super.setContext(sc);
        File modulesDir = new File(sc.getRootDirectory(), "modules");
        final StartupContext startupContext = sc;
        this.setSystemProperties();
        ClassLoader parent = this.getClass().getClassLoader();
        ClassLoader maskingClassLoade = this.getMaskingClassLoader(parent, sc.getRootDirectory());
        ClassLoader singleClassLoader = this.createTmpClassLoader(maskingClassLoade, modulesDir);
        if (singleClassLoader == null) {
            throw new BootException("Could not create single class loader from the cache");
        }
        final SingleModulesRegistry modulesRegistry = new SingleModulesRegistry(singleClassLoader);
        modulesRegistry.setParentClassLoader(singleClassLoader);
        final ClassLoader cl = singleClassLoader;
        Thread launcherThread = new Thread(new Runnable(){

            public void run() {
                Main main = new Main(){

                    protected Habitat createHabitat(ModulesRegistry registry, StartupContext context) throws BootException {
                        Habitat habitat = registry.newHabitat();
                        for (Object c : ASMainStatic.this.getContexts()) {
                            habitat.add(Inhabitants.create(c));
                        }
                        habitat.add(new ExistingSingletonInhabitant<ModulesRegistry>(ModulesRegistry.class, registry));
                        habitat.add(new ExistingSingletonInhabitant<Logger>(Logger.class, logger));
                        registry.createHabitat("default", this.createInhabitantsParser(habitat));
                        ASMainStatic.this.habitat = habitat;
                        return habitat;
                    }

                    protected InhabitantsParser createInhabitantsParser(Habitat habitat) {
                        InhabitantsParser parser = super.createInhabitantsParser(habitat);
                        ServiceLoader<InhabitantsParserDecorator> decorators = ServiceLoader.load(InhabitantsParserDecorator.class, cl);
                        for (InhabitantsParserDecorator decorator : decorators) {
                            decorator.decorate(parser);
                        }
                        return parser;
                    }
                };
                try {
                    main.launch(modulesRegistry, startupContext);
                }
                catch (BootException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }, "Static Framework Launcher");
        launcherThread.setContextClassLoader(singleClassLoader);
        launcherThread.setDaemon(true);
        launcherThread.start();
        try {
            launcherThread.join();
        }
        catch (InterruptedException e) {
            logger.warning("main thread interrupted");
        }
        logger.fine("Framework successfully started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassLoader getMaskingClassLoader(ClassLoader parent, File root) {
        File f = new File(root, "osgi/felix");
        if (!(f = new File(f, "conf/config.properties")).exists()) {
            return parent;
        }
        Properties props = new Properties();
        FileReader reader = null;
        try {
            reader = new FileReader(f);
            props.load(reader);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Cannot load " + f.getAbsolutePath());
            ClassLoader classLoader = parent;
            return classLoader;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
        }
        String punchins = props.getProperty("jre-1.6");
        StringTokenizer st = new StringTokenizer(punchins, ",");
        ArrayList<String> p = new ArrayList<String>();
        ArrayList<String> multiples = new ArrayList<String>();
        multiples.add("org.jvnet");
        multiples.add("org.glassfish");
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            if (tk.contains(";")) {
                tk = tk.substring(0, tk.indexOf(";"));
            }
            p.add(tk.trim());
        }
        return new MaskingClassLoader(parent, p, multiples);
    }

    @Override
    Logger getLogger() {
        return this.logger;
    }

    @Override
    boolean createCache(File cacheDir) throws IOException {
        cacheDir.mkdirs();
        Rejar rejar = new Rejar();
        rejar.rejar(this.out, this.bootstrapFile.getParentFile());
        return true;
    }

    public ClassLoader createClassLoader(File cacheDir) throws Exception {
        if (this.out != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(this.out.toURI().toURL());
            this.findDerbyClient(urls);
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
        }
        return null;
    }

    public ClassLoader createTmpClassLoader(ClassLoader parent, File moduleDir) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        Set<ModuleInfo> modules = this.getAlreadyLoadedModules();
        this.insertURLs(moduleDir, modules, urls);
        this.findDerbyClient(urls);
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }

    private URL getJarFileURL(URL url) throws MalformedURLException {
        String urlString = url.toExternalForm();
        return new URL(urlString.substring("jar:".length(), urlString.length() - "META-INF/MANIFEST.MF".length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ModuleInfo> getAlreadyLoadedModules() throws IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        HashSet<ModuleInfo> modules = new HashSet<ModuleInfo>();
        Enumeration<URL> urls = cl.getResources("META-INF/MANIFEST.MF");
        while (urls.hasMoreElements()) {
            InputStream is = null;
            URL url = urls.nextElement();
            try {
                is = url.openStream();
                Manifest m = new Manifest(is);
                if (m.getMainAttributes().getValue("HK2-Bundle-Name") == null) continue;
                modules.add(new ModuleInfo(m.getMainAttributes().getValue("HK2-Bundle-Name"), m.getMainAttributes().getValue("Bundle-Version")));
            }
            finally {
                try {
                    if (is == null) continue;
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return modules;
    }

    private void insertURLs(File directory, Set<ModuleInfo> modules, List<URL> result) throws Exception {
        for (File file : directory.listFiles()) {
            if (file.isFile() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
                this.processFile(file, modules, result);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.insertURLs(file, modules, result);
        }
    }

    private void processFile(File file, Set<ModuleInfo> modules, List<URL> result) throws IOException {
        JarFile jarFile = new JarFile(file);
        Manifest m = jarFile.getManifest();
        String bundleName = m.getMainAttributes().getValue("HK2-Bundle-Name");
        if (bundleName != null) {
            String version = m.getMainAttributes().getValue("Bundle-Version");
            ModuleInfo info = new ModuleInfo(bundleName, version);
            if (!modules.contains(info)) {
                result.add(file.toURI().toURL());
                modules.add(info);
            }
        } else {
            result.add(file.toURI().toURL());
        }
        String classpath = m.getMainAttributes().getValue("Class-Path");
        if (classpath != null) {
            StringTokenizer st = new StringTokenizer(classpath);
            while (st.hasMoreTokens()) {
                String cpe = st.nextToken();
            }
        }
    }

    private void findDerbyClient(List<URL> urls) throws IOException {
        String derbyHome = System.getProperty("AS_DERBY_INSTALL");
        File derbyLib = null;
        if (derbyHome != null) {
            derbyLib = new File(derbyHome, "lib");
        }
        if (!(derbyLib != null && derbyLib.exists() || System.getProperty("java.version").compareTo("1.6") <= 0)) {
            File jdkHome = new File(System.getProperty("java.home"));
            derbyLib = new File(jdkHome, "../db/lib");
        }
        if (!derbyLib.exists()) {
            this.logger.fine("Cannot find javadb client jar file, jdbc driver not available");
            return;
        }
        urls.add(new File(derbyLib, "derby.jar").toURI().toURL());
        urls.add(new File(derbyLib, "derbyclient.jar").toURI().toURL());
    }

    private final class ModuleInfo {
        final String bundleName;
        final String bundleVersion;

        private ModuleInfo(String bundleName, String bundleVersion) {
            this.bundleName = bundleName;
            this.bundleVersion = bundleVersion;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ModuleInfo)) {
                return false;
            }
            ModuleInfo o = (ModuleInfo)other;
            return this.bundleName.equals(o.bundleName) && this.bundleVersion.equals(o.bundleVersion);
        }
    }
}

