/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaskingClassLoader
extends ClassLoader {
    private final Set<String> punchins = new HashSet<String>();
    private final String[] multiples;

    public MaskingClassLoader(ClassLoader parent, Collection<String> punchins, Collection<String> multiples) {
        super(parent);
        this.punchins.addAll(punchins);
        this.multiples = multiples.toArray(new String[multiples.size()]);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.findSystemClass(name);
        }
        catch (ClassNotFoundException e) {
            if (!name.startsWith("javax.") && !name.startsWith("org.")) {
                return super.loadClass(name, resolve);
            }
            String packageName = name.substring(0, name.lastIndexOf("."));
            if (this.punchins.contains(packageName)) {
                return super.loadClass(name, resolve);
            }
            for (String multiple : this.multiples) {
                if (!name.startsWith(multiple)) continue;
                return super.loadClass(name, resolve);
            }
            throw new ClassNotFoundException(name);
        }
    }
}

