/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.CorbaAcceptor;
import com.sun.corba.ee.spi.transport.ORBSocketFactory;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.security.integration.AppClientSSL;
import com.sun.grizzly.config.dom.Ssl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.IIOPSSLUtil;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.CipherInfo;

public class IIOPSSLSocketFactory
implements ORBSocketFactory,
Serializable {
    private static Logger _logger = null;
    private static final String TLS = "TLS";
    private static final String SSL3 = "SSLv3";
    private static final String SSL2 = "SSLv2";
    private static final String SSL = "SSL";
    private static final String SSL_MUTUALAUTH = "SSL_MUTUALAUTH";
    private static final String PERSISTENT_SSL = "PERSISTENT_SSL";
    private static final int BACKLOG = 50;
    private Map portToSSLInfo = new Hashtable();
    private SSLInfo clientSslInfo = null;
    private ORB orb;

    public IIOPSSLSocketFactory() {
        try {
            boolean notServerOrACC;
            ProcessEnvironment penv = null;
            ProcessEnvironment.ProcessType processType = null;
            boolean bl = notServerOrACC = Globals.getDefaultHabitat() == null;
            if (!notServerOrACC) {
                penv = (ProcessEnvironment)Globals.get(ProcessEnvironment.class);
                processType = penv.getProcessType();
            }
            if (processType != null && processType == ProcessEnvironment.ProcessType.Server) {
                Ssl outboundSsl;
                IiopService iiopBean = Globals.getDefaultHabitat().getComponent(IiopService.class);
                List iiopListeners = iiopBean.getIiopListener();
                for (IiopListener listener : iiopListeners) {
                    Ssl ssl = listener.getSsl();
                    SSLInfo sslInfo = null;
                    boolean securityEnabled = Boolean.valueOf(listener.getSecurityEnabled());
                    if (!securityEnabled) continue;
                    if (ssl != null) {
                        boolean ssl2Enabled = Boolean.valueOf(ssl.getSsl2Enabled());
                        boolean tlsEnabled = Boolean.valueOf(ssl.getTlsEnabled());
                        boolean ssl3Enabled = Boolean.valueOf(ssl.getSsl3Enabled());
                        sslInfo = this.init(ssl.getCertNickname(), ssl2Enabled, ssl.getSsl2Ciphers(), ssl3Enabled, ssl.getSsl3TlsCiphers(), tlsEnabled);
                    } else {
                        sslInfo = this.getDefaultSslInfo();
                    }
                    this.portToSSLInfo.put(new Integer(listener.getPort()), sslInfo);
                }
                if (iiopBean.getSslClientConfig() != null && iiopBean.getSslClientConfig().getSsl() != null && (outboundSsl = iiopBean.getSslClientConfig().getSsl()) != null) {
                    boolean ssl2Enabled = Boolean.valueOf(outboundSsl.getSsl2Enabled());
                    boolean ssl3Enabled = Boolean.valueOf(outboundSsl.getSsl3Enabled());
                    boolean tlsEnabled = Boolean.valueOf(outboundSsl.getTlsEnabled());
                    this.clientSslInfo = this.init(outboundSsl.getCertNickname(), ssl2Enabled, outboundSsl.getSsl2Ciphers(), ssl3Enabled, outboundSsl.getSsl3TlsCiphers(), tlsEnabled);
                }
                if (this.clientSslInfo == null) {
                    this.clientSslInfo = this.getDefaultSslInfo();
                }
            } else {
                IIOPSSLUtil sslUtil;
                AppClientSSL clientSsl;
                this.clientSslInfo = processType != null && processType == ProcessEnvironment.ProcessType.ACC ? ((clientSsl = (AppClientSSL)(sslUtil = Globals.getDefaultHabitat().getComponent(IIOPSSLUtil.class)).getAppClientSSL()) != null ? this.init(clientSsl.getCertNickname(), clientSsl.getSsl2Enabled(), clientSsl.getSsl2Ciphers(), clientSsl.getSsl3Enabled(), clientSsl.getSsl3TlsCiphers(), clientSsl.getTlsEnabled()) : this.getDefaultSslInfo()) : this.getDefaultSslInfo();
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.init_exception", e);
            throw new IllegalStateException(e);
        }
    }

    private SSLInfo getDefaultSslInfo() throws Exception {
        return this.init(null, false, null, true, null, true);
    }

    private SSLInfo init(String alias, boolean ssl2Enabled, String ssl2Ciphers, boolean ssl3Enabled, String ssl3TlsCiphers, boolean tlsEnabled) throws Exception {
        String protocol = tlsEnabled ? TLS : (ssl3Enabled ? SSL3 : (ssl2Enabled ? SSL2 : SSL));
        String[] ssl3TlsCipherArr = null;
        if (tlsEnabled || ssl3Enabled) {
            ssl3TlsCipherArr = this.getEnabledCipherSuites(ssl3TlsCiphers, false, ssl3Enabled, tlsEnabled);
        }
        String[] ssl2CipherArr = null;
        if (ssl2Enabled) {
            ssl2CipherArr = this.getEnabledCipherSuites(ssl2Ciphers, true, false, false);
        }
        SSLContext ctx = SSLContext.getInstance(protocol);
        if (Globals.getDefaultHabitat() != null) {
            IIOPSSLUtil sslUtil = Globals.getDefaultHabitat().getComponent(IIOPSSLUtil.class);
            KeyManager[] mgrs = sslUtil.getKeyManagers(alias);
            ctx.init(mgrs, sslUtil.getTrustManagers(), sslUtil.getInitializedSecureRandom());
        }
        return new SSLInfo(ctx, ssl3TlsCipherArr, ssl2CipherArr);
    }

    public void setORB(ORB orb) {
        this.orb = orb;
    }

    public ServerSocket createServerSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Creating server socket for type =" + type + " inetSocketAddress =" + inetSocketAddress);
        }
        if (type.equals(SSL_MUTUALAUTH) || type.equals(SSL) || type.equals(PERSISTENT_SSL)) {
            return this.createSSLServerSocket(type, inetSocketAddress);
        }
        ServerSocket serverSocket = null;
        if (this.orb.getORBData().acceptorSocketType().equals("SocketChannel")) {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocket = serverSocketChannel.socket();
        } else {
            serverSocket = new ServerSocket();
        }
        serverSocket.bind(inetSocketAddress);
        return serverSocket;
    }

    public Socket createSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        try {
            String host = inetSocketAddress.getHostName();
            int port = inetSocketAddress.getPort();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "createSocket(" + type + ", " + host + ", " + port + ")");
            }
            if (type.equals(SSL) || type.equals(SSL_MUTUALAUTH)) {
                return this.createSSLSocket(host, port);
            }
            Socket socket = null;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Creating CLEAR_TEXT socket for:" + port);
            }
            if (this.orb.getORBData().connectionSocketType().equals("SocketChannel")) {
                SocketChannel socketChannel = ORBUtility.openSocketChannel((SocketAddress)inetSocketAddress);
                socket = socketChannel.socket();
            } else {
                socket = new Socket(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            }
            socket.setTcpNoDelay(true);
            return socket;
        }
        catch (Exception ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Exception creating socket", ex);
            }
            throw new RuntimeException(ex);
        }
    }

    public void setAcceptedSocketOptions(CorbaAcceptor acceptor, ServerSocket serverSocket, Socket socket) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "setAcceptedSocketOptions: " + acceptor + " " + serverSocket + " " + socket);
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException ex) {
            throw new RuntimeException(ex);
        }
    }

    private ServerSocket createSSLServerSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        if (inetSocketAddress == null) {
            throw new IOException(this.getFormatMessage("iiop.invalid_sslserverport", new Object[]{null}));
        }
        int port = inetSocketAddress.getPort();
        Integer iport = new Integer(port);
        SSLInfo sslInfo = (SSLInfo)this.portToSSLInfo.get(iport);
        if (sslInfo == null) {
            throw new IOException(this.getFormatMessage("iiop.invalid_sslserverport", new Object[]{iport}));
        }
        SSLServerSocketFactory ssf = sslInfo.getContext().getServerSocketFactory();
        String[] ssl3TlsCiphers = sslInfo.getSsl3TlsCiphers();
        String[] ssl2Ciphers = sslInfo.getSsl2Ciphers();
        String[] ciphers = null;
        if (ssl3TlsCiphers != null || ssl2Ciphers != null) {
            String[] socketCiphers = ssf.getDefaultCipherSuites();
            ciphers = this.mergeCiphers(socketCiphers, ssl3TlsCiphers, ssl2Ciphers);
        }
        String[] cs = null;
        if (_logger.isLoggable(Level.FINE)) {
            cs = ssf.getSupportedCipherSuites();
            for (int i = 0; i < cs.length; ++i) {
                _logger.log(Level.FINE, "Cipher Suite: " + cs[i]);
            }
        }
        ServerSocket ss = null;
        try {
            ss = ssf.createServerSocket(port, 50, inetSocketAddress.getAddress());
            if (ciphers != null) {
                ((SSLServerSocket)ss).setEnabledCipherSuites(ciphers);
            }
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "iiop.createsocket_exception", new Object[]{type, String.valueOf(port)});
            _logger.log(Level.SEVERE, "", e);
            throw e;
        }
        try {
            if (type.equals(SSL_MUTUALAUTH)) {
                _logger.log(Level.FINE, "Setting Mutual auth");
                ((SSLServerSocket)ss).setNeedClientAuth(true);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iiop.cipher_exception", e);
            throw new IOException(e.getMessage());
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Created server socket:" + ss);
        }
        return ss;
    }

    private Socket createSSLSocket(String host, int port) throws IOException {
        SSLSocket socket = null;
        SSLSocketFactory factory = null;
        try {
            factory = this.clientSslInfo.getContext().getSocketFactory();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Creating SSL Socket for host:" + host + " port:" + port);
            }
            String[] ssl3TlsCiphers = this.clientSslInfo.getSsl3TlsCiphers();
            String[] ssl2Ciphers = this.clientSslInfo.getSsl2Ciphers();
            String[] clientCiphers = null;
            if (ssl3TlsCiphers != null || ssl2Ciphers != null) {
                String[] socketCiphers = factory.getDefaultCipherSuites();
                clientCiphers = this.mergeCiphers(socketCiphers, ssl3TlsCiphers, ssl2Ciphers);
            }
            socket = (SSLSocket)factory.createSocket(host, port);
            if (clientCiphers != null) {
                socket.setEnabledCipherSuites(clientCiphers);
            }
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "iiop.createsocket_exception", new Object[]{host, String.valueOf(port)});
                _logger.log(Level.FINE, "", e);
            }
            IOException e2 = new IOException("Error opening SSL socket to host=" + host + " port=" + port);
            e2.initCause(e);
            throw e2;
        }
        return socket;
    }

    private String[] getEnabledCipherSuites(String cipherSuiteStr, boolean ssl2Enabled, boolean ssl3Enabled, boolean tlsEnabled) {
        String[] cipherArr = null;
        if (cipherSuiteStr != null && cipherSuiteStr.length() > 0) {
            ArrayList<String> cipherList = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(cipherSuiteStr, ",");
            while (tokens.hasMoreTokens()) {
                CipherInfo cipherInfo;
                String cipher;
                String cipherAction = tokens.nextToken();
                if (cipherAction.startsWith("+")) {
                    cipher = cipherAction.substring(1);
                    cipherInfo = CipherInfo.getCipherInfo((String)cipher);
                    if (cipherInfo != null && this.isValidProtocolCipher(cipherInfo, ssl2Enabled, ssl3Enabled, tlsEnabled)) {
                        cipherList.add(cipherInfo.getCipherName());
                        continue;
                    }
                    throw new IllegalStateException(this.getFormatMessage("iiop.unknown_cipher", new Object[]{cipher}));
                }
                if (cipherAction.startsWith("-")) {
                    cipher = cipherAction.substring(1);
                    cipherInfo = CipherInfo.getCipherInfo((String)cipher);
                    if (cipherInfo != null && this.isValidProtocolCipher(cipherInfo, ssl2Enabled, ssl3Enabled, tlsEnabled)) continue;
                    throw new IllegalStateException(this.getFormatMessage("iiop.unknown_cipher", new Object[]{cipher}));
                }
                if (cipherAction.trim().length() <= 0) continue;
                throw new IllegalStateException(this.getFormatMessage("iiop.invalid_cipheraction", new Object[]{cipherAction}));
            }
            cipherArr = cipherList.toArray(new String[cipherList.size()]);
        }
        return cipherArr;
    }

    private String[] mergeCiphers(String[] enableCiphers, String[] ssl3TlsCiphers, String[] ssl2Ciphers) {
        CipherInfo cInfo;
        String cipher;
        int i;
        int eSize;
        if (ssl3TlsCiphers == null && ssl2Ciphers == null) {
            return null;
        }
        int n = eSize = enableCiphers != null ? enableCiphers.length : 0;
        if (_logger.isLoggable(Level.FINE)) {
            StringBuffer buf = new StringBuffer("Default socket ciphers: ");
            for (i = 0; i < eSize; ++i) {
                buf.append(enableCiphers[i] + ", ");
            }
            _logger.log(Level.FINE, buf.toString());
        }
        ArrayList<String> cList = new ArrayList<String>();
        if (ssl3TlsCiphers != null) {
            for (i = 0; i < ssl3TlsCiphers.length; ++i) {
                cList.add(ssl3TlsCiphers[i]);
            }
        } else {
            for (i = 0; i < eSize; ++i) {
                cipher = enableCiphers[i];
                cInfo = CipherInfo.getCipherInfo((String)cipher);
                if (cInfo == null || !cInfo.isTLS() && !cInfo.isSSL3()) continue;
                cList.add(cipher);
            }
        }
        if (ssl2Ciphers != null) {
            for (i = 0; i < ssl2Ciphers.length; ++i) {
                cList.add(ssl2Ciphers[i]);
            }
        } else {
            for (i = 0; i < eSize; ++i) {
                cipher = enableCiphers[i];
                cInfo = CipherInfo.getCipherInfo((String)cipher);
                if (cInfo == null || !cInfo.isSSL2()) continue;
                cList.add(cipher);
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Merged socket ciphers: " + cList);
        }
        return cList.toArray(new String[cList.size()]);
    }

    private boolean isValidProtocolCipher(CipherInfo cipherInfo, boolean ssl2Enabled, boolean ssl3Enabled, boolean tlsEnabled) {
        return tlsEnabled && cipherInfo.isTLS() || ssl3Enabled && cipherInfo.isSSL3() || ssl2Enabled && cipherInfo.isSSL2();
    }

    private String getFormatMessage(String key, Object[] params) {
        return MessageFormat.format(_logger.getResourceBundle().getString(key), params);
    }

    static {
        _logger = LogDomains.getLogger(IIOPSSLSocketFactory.class, (String)"javax.enterprise.resource.corba");
    }

    class SSLInfo {
        private SSLContext ctx;
        private String[] ssl3TlsCiphers = null;
        private String[] ssl2Ciphers = null;

        SSLInfo(SSLContext ctx, String[] ssl3TlsCiphers, String[] ssl2Ciphers) {
            this.ctx = ctx;
            this.ssl3TlsCiphers = ssl3TlsCiphers;
            this.ssl2Ciphers = ssl2Ciphers;
        }

        SSLContext getContext() {
            return this.ctx;
        }

        String[] getSsl3TlsCiphers() {
            return this.ssl3TlsCiphers;
        }

        String[] getSsl2Ciphers() {
            return this.ssl2Ciphers;
        }
    }
}

