/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight;

import com.sun.enterprise.config.serverbeans.MonitoringService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.glassfish.api.monitoring.DTraceContract;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.jvnet.hk2.component.Habitat;

public class FlashlightUtils {
    private static Habitat habitat;
    private static MonitoringService monConfig;
    private static DTraceContract dt;
    private static boolean dtraceEnabled;
    private static boolean monitoringEnabled;
    private static final Object LOCK;
    private static final Class[] INTEGRAL_CLASSES;

    private FlashlightUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Habitat h, MonitoringService mc) {
        Object object = LOCK;
        synchronized (object) {
            if (habitat == null) {
                habitat = h;
                monConfig = mc;
                FlashlightUtils.setDTraceAvailabilty();
                FlashlightUtils.setDTraceEnabled(Boolean.parseBoolean(monConfig.getDtraceEnabled()));
                FlashlightUtils.setMonitoringEnabled(Boolean.parseBoolean(monConfig.getMonitoringEnabled()));
            }
        }
    }

    public static void setDTraceEnabled(boolean b) {
        FlashlightUtils.ok();
        dtraceEnabled = b;
    }

    public static void setMonitoringEnabled(boolean b) {
        FlashlightUtils.ok();
        monitoringEnabled = b;
    }

    public static boolean isMonitoringEnabled() {
        FlashlightUtils.ok();
        return monitoringEnabled;
    }

    public static boolean isDtraceAvailable() {
        FlashlightUtils.ok();
        if (dt == null) {
            return false;
        }
        if (!dtraceEnabled) {
            return false;
        }
        return monitoringEnabled;
    }

    public static boolean isDtraceEnabled() {
        return dtraceEnabled;
    }

    public static DTraceContract getDtraceEngine() {
        return FlashlightUtils.isDtraceAvailable() ? dt : null;
    }

    private static void setDTraceAvailabilty() {
        FlashlightUtils.ok();
        dt = habitat.getByContract(DTraceContract.class);
        if (dt == null) {
            return;
        }
        if (!dt.isSupported()) {
            dt = null;
        }
    }

    public static String[] getParamNames(Method method) {
        String[] paramNames = new String[method.getParameterTypes().length];
        Annotation[][] allAnns = method.getParameterAnnotations();
        int index = 0;
        Annotation[][] arr$ = allAnns;
        int len$ = arr$.length;
        block0: for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] paramAnns;
            for (Annotation ann : paramAnns = arr$[i$]) {
                if (!(ann instanceof ProbeParam)) continue;
                paramNames[index++] = ((ProbeParam)ann).value();
                continue block0;
            }
        }
        if (index != paramNames.length) {
            throw new RuntimeException("All params have to be  named with a ProbeParam Annotation.  This method (" + method + ") did not have them.");
        }
        return paramNames;
    }

    public static boolean isLegalDtraceParam(Class clazz) {
        return FlashlightUtils.isIntegral(clazz) || String.class.equals((Object)clazz);
    }

    public static boolean isIntegral(Class clazz) {
        for (Class c : INTEGRAL_CLASSES) {
            if (!c.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean compareIntegral(Class c1, Class c2) {
        if (!FlashlightUtils.isIntegral(c1) || !FlashlightUtils.isIntegral(c2)) {
            return false;
        }
        if (c1.equals(c2)) {
            return true;
        }
        if (c1.equals(Short.TYPE)) {
            return c2.equals(Short.class);
        }
        if (c1.equals(Long.TYPE)) {
            return c2.equals(Long.class);
        }
        if (c1.equals(Integer.TYPE)) {
            return c2.equals(Integer.class);
        }
        if (c1.equals(Byte.TYPE)) {
            return c2.equals(Byte.class);
        }
        if (c1.equals(Character.TYPE)) {
            return c2.equals(Character.class);
        }
        if (c1.equals(Boolean.TYPE)) {
            return c2.equals(Boolean.class);
        }
        if (c2.equals(Short.TYPE)) {
            return c1.equals(Short.class);
        }
        if (c2.equals(Long.TYPE)) {
            return c1.equals(Long.class);
        }
        if (c2.equals(Integer.TYPE)) {
            return c1.equals(Integer.class);
        }
        if (c2.equals(Byte.TYPE)) {
            return c1.equals(Byte.class);
        }
        if (c2.equals(Character.TYPE)) {
            return c1.equals(Character.class);
        }
        if (c2.equals(Boolean.TYPE)) {
            return c1.equals(Boolean.class);
        }
        return false;
    }

    private static void ok() {
        if (habitat == null || monConfig == null) {
            throw new RuntimeException("Internal Error: habitat was not set in " + FlashlightUtils.class);
        }
    }

    static {
        LOCK = new Object();
        INTEGRAL_CLASSES = new Class[]{Integer.TYPE, Long.TYPE, Short.TYPE, Boolean.TYPE, Character.TYPE, Byte.TYPE, Integer.class, Long.class, Short.class, Boolean.class, Character.class, Byte.class};
    }
}

