/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.container.common.LocalPassword;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityLifecycle;
import com.sun.enterprise.security.SecuritySniffer;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.file.FileRealm;
import com.sun.enterprise.security.auth.realm.file.FileRealmUser;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.security.common.Group;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

@Service
public class GenericAdminAuthenticator
implements AdminAccessController,
JMXAuthenticator {
    @Inject
    Habitat habitat;
    @Inject
    SecuritySniffer snif;
    @Inject
    volatile SecurityService ss;
    @Inject
    volatile AdminService as;
    @Inject
    LocalPassword localPassword;
    @Inject
    ClassLoaderHierarchy clh;
    private static LocalStringManagerImpl lsm = new LocalStringManagerImpl(GenericAdminAuthenticator.class);
    private final Logger logger = Logger.getAnonymousLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loginAsAdmin(String user, String password, String realm) throws LoginException {
        if (this.as.usesFileRealm()) {
            return this.handleFileRealm(user, password);
        }
        ClassLoader pc = null;
        boolean hack = false;
        boolean authenticated = false;
        try {
            pc = Thread.currentThread().getContextClassLoader();
            if (!this.clh.getCommonClassLoader().equals(pc)) {
                Thread.currentThread().setContextClassLoader(this.clh.getCommonClassLoader());
                hack = true;
            }
            Inhabitant<SecurityLifecycle> sl = this.habitat.getInhabitantByType(SecurityLifecycle.class);
            sl.get();
            this.snif.setup(System.getProperty("com.sun.aas.installRoot") + "/modules/security", Logger.getAnonymousLogger());
            LoginContextDriver.login((String)user, (String)password, (String)realm);
            authenticated = true;
            boolean bl = this.ensureGroupMembership(user, realm);
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (hack) {
                Thread.currentThread().setContextClassLoader(pc);
            }
        }
    }

    private boolean ensureGroupMembership(String user, String realm) {
        try {
            SecurityContext sc = SecurityContext.getCurrent();
            Set ps = sc.getPrincipalSet();
            for (Object principal : ps) {
                Group group;
                if (!(principal instanceof Group) || !(group = (Group)principal).getName().equals("asadmin")) continue;
                return true;
            }
            this.logger.fine("User is not the member of the special admin group");
            return false;
        }
        catch (Exception e) {
            this.logger.fine("User is not the member of the special admin group: " + e.getMessage());
            return false;
        }
    }

    private boolean handleFileRealm(String user, String password) throws LoginException {
        boolean isLocal = this.isLocalPassword(user, password);
        if (isLocal) {
            return true;
        }
        if (user == null || user.length() == 0) {
            String defuser = this.getDefaultAdminUser();
            if (defuser != null) {
                user = defuser;
                this.logger.fine("Using default user: " + defuser);
            } else {
                this.logger.fine("No default user");
            }
        }
        try {
            AuthRealm ar = this.as.getAssociatedAuthRealm();
            if (FileRealm.class.getName().equals(ar.getClassname())) {
                String adminKeyFilePath = ar.getPropertyValue("file");
                FileRealm fr = new FileRealm(adminKeyFilePath);
                FileRealmUser fru = (FileRealmUser)fr.getUser(user);
                for (String group : fru.getGroups()) {
                    if (!group.equals("asadmin")) continue;
                    return fr.authenticate(user, password) != null;
                }
                return false;
            }
        }
        catch (NoSuchUserException ue) {
            return false;
        }
        catch (Exception e) {
            LoginException le = new LoginException(e.getMessage());
            le.initCause(e);
            throw le;
        }
        return false;
    }

    private String getDefaultAdminUser() {
        AuthRealm realm = this.as.getAssociatedAuthRealm();
        if (realm == null) {
            throw new RuntimeException("Warning: Configuration is bad, realm: " + this.as.getAuthRealmName() + " does not exist!");
        }
        if (!FileRealm.class.getName().equals(realm.getClassname())) {
            this.logger.fine("CAN'T FIND DEFAULT ADMIN USER: IT'S NOT A FILE REALM");
            return null;
        }
        String pv = realm.getPropertyValue("file");
        File rf = null;
        if (pv == null || !(rf = new File(pv)).exists()) {
            this.logger.fine("CAN'T FIND DEFAULT ADMIN USER: THE KEYFILE DOES NOT EXIST");
            return null;
        }
        try {
            FileRealm fr = new FileRealm(rf.getAbsolutePath());
            Enumeration users = fr.getUserNames();
            if (users.hasMoreElements()) {
                FileRealmUser fru;
                String[] arr$;
                int len$;
                int i$;
                String au = (String)users.nextElement();
                if (!users.hasMoreElements() && (i$ = 0) < (len$ = (arr$ = (fru = (FileRealmUser)fr.getUser(au)).getGroups()).length)) {
                    String group = arr$[i$];
                    if (group.equals("asadmin")) {
                        this.logger.fine("Attempting access using default admin user: " + au);
                    }
                    return au;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private boolean isLocalPassword(String user, String password) {
        if (!this.localPassword.isLocalPassword(password)) {
            this.logger.finest("Password is not the local password");
            return false;
        }
        this.logger.fine("Allowing access using local password");
        return true;
    }

    public Subject authenticate(Object credentials) {
        String realm;
        String user = "";
        String password = "";
        if (credentials instanceof String[]) {
            String[] up = (String[])credentials;
            if (up.length == 1) {
                user = up[0];
            } else if (up.length >= 2) {
                user = up[0];
                password = up[1];
                if (password == null) {
                    password = "";
                }
            }
        }
        if ((realm = this.as.getSystemJmxConnector().getAuthRealmName()) == null) {
            realm = this.as.getAuthRealmName();
        }
        try {
            boolean ok = this.loginAsAdmin(user, password, realm);
            if (!ok) {
                String msg = lsm.getLocalString("authentication.failed", "User [{0}] does not have administration access", new Object[]{user});
                throw new SecurityException(msg);
            }
            return null;
        }
        catch (LoginException e) {
            throw new SecurityException(e);
        }
    }
}

