/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

@Service
public class JavaModuleNamingProxy
implements NamedNamingObjectProxy,
PostConstruct {
    @Inject
    Habitat habitat;
    private static Logger _logger = LogDomains.getLogger(JavaModuleNamingProxy.class, (String)"javax.enterprise.system.core.naming");
    private InitialContext ic;
    private static final String JAVA_MODULE_CONTEXT = "java:module/";
    private static final String JAVA_APP_CONTEXT = "java:app/";
    private static final String JAVA_APP_NAME = "java:app/AppName";
    private static final String JAVA_MODULE_NAME = "java:module/ModuleName";

    public void postConstruct() {
        try {
            this.ic = new InitialContext();
        }
        catch (NamingException ne) {
            throw new RuntimeException("JavaModuleNamingProxy InitialContext creation failure", ne);
        }
    }

    public Object handle(String name) throws NamingException {
        Object returnValue = null;
        if (name.equals(JAVA_APP_NAME)) {
            returnValue = this.getAppName();
        } else if (name.equals(JAVA_MODULE_NAME)) {
            returnValue = this.getModuleName();
        } else if (name.startsWith(JAVA_MODULE_CONTEXT) || name.startsWith(JAVA_APP_CONTEXT)) {
            returnValue = this.getJavaModuleOrAppEJB(name);
        }
        return returnValue;
    }

    private String getAppName() throws NamingException {
        ComponentEnvManager namingMgr = this.habitat.getComponent(ComponentEnvManager.class);
        String appName = null;
        if (namingMgr != null) {
            JndiNameEnvironment env = namingMgr.getCurrentJndiNameEnvironment();
            EjbBundleDescriptor bd = null;
            if (env instanceof EjbDescriptor) {
                bd = ((EjbDescriptor)env).getEjbBundleDescriptor();
            } else if (env instanceof BundleDescriptor) {
                bd = (BundleDescriptor)env;
            }
            if (bd != null) {
                Application app = bd.getApplication();
                appName = app.getAppName();
            }
        }
        if (appName == null) {
            throw new NamingException("Could not resolve java:app/AppName");
        }
        return appName;
    }

    private String getModuleName() throws NamingException {
        ComponentEnvManager namingMgr = this.habitat.getComponent(ComponentEnvManager.class);
        String moduleName = null;
        if (namingMgr != null) {
            JndiNameEnvironment env = namingMgr.getCurrentJndiNameEnvironment();
            EjbBundleDescriptor bd = null;
            if (env instanceof EjbDescriptor) {
                bd = ((EjbDescriptor)env).getEjbBundleDescriptor();
            } else if (env instanceof BundleDescriptor) {
                bd = (BundleDescriptor)env;
            }
            if (bd != null) {
                moduleName = bd.getModuleDescriptor().getModuleName();
            }
        }
        if (moduleName == null) {
            throw new NamingException("Could not resolve java:module/ModuleName");
        }
        return moduleName;
    }

    private Object getJavaModuleOrAppEJB(String name) throws NamingException {
        ComponentEnvManager namingMgr;
        String newName = null;
        Object returnValue = null;
        if (this.habitat != null && (namingMgr = this.habitat.getComponent(ComponentEnvManager.class)) != null) {
            JndiNameEnvironment env = namingMgr.getCurrentJndiNameEnvironment();
            EjbBundleDescriptor bd = null;
            if (env instanceof EjbDescriptor) {
                bd = ((EjbDescriptor)env).getEjbBundleDescriptor();
            } else if (env instanceof BundleDescriptor) {
                bd = (BundleDescriptor)env;
            }
            if (bd != null) {
                Application app = bd.getApplication();
                String appName = null;
                if (!app.isVirtual()) {
                    appName = app.getAppName();
                }
                String moduleName = bd.getModuleDescriptor().getModuleName();
                StringBuffer javaGlobalName = new StringBuffer("java:global/");
                if (name.startsWith(JAVA_APP_CONTEXT)) {
                    if (appName != null) {
                        javaGlobalName.append(appName);
                        javaGlobalName.append("/");
                    }
                    int javaAppLength = JAVA_APP_CONTEXT.length();
                    javaGlobalName.append(name.substring(javaAppLength));
                } else {
                    if (appName != null) {
                        javaGlobalName.append(appName);
                        javaGlobalName.append("/");
                    }
                    javaGlobalName.append(moduleName);
                    javaGlobalName.append("/");
                    int javaModuleLength = JAVA_MODULE_CONTEXT.length();
                    javaGlobalName.append(name.substring(javaModuleLength));
                }
                newName = javaGlobalName.toString();
            }
        }
        if (newName != null) {
            try {
                returnValue = this.ic.lookup(newName);
            }
            catch (NamingException ne) {
                _logger.log(Level.FINE, newName + " Unable to map " + name + " to derived name " + newName, ne);
            }
        }
        return returnValue;
    }
}

